/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RsIterator;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.SqlHelper;

public class ReportQueryRsIterator
extends RsIterator {
    private ResultSetMetaData rsMetaData;
    private int columnCount;

    public ReportQueryRsIterator(Query query, ClassDescriptor classDescriptor, PersistenceBrokerImpl persistenceBrokerImpl) {
        super(query, classDescriptor, persistenceBrokerImpl);
        try {
            this.rsMetaData = this.m_rsAndStmt.m_rs.getMetaData();
            this.columnCount = this.rsMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerException(sQLException);
        }
    }

    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        Object[] objectArray = new Object[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            try {
                Object object;
                int n = this.rsMetaData.getColumnType(i + 1);
                objectArray[i] = object = SqlHelper.getObjectFromColumn(this.m_rsAndStmt.m_rs, n, i + 1);
                continue;
            }
            catch (SQLException sQLException) {
                throw new PersistenceBrokerException(sQLException);
            }
        }
        return objectArray;
    }
}

