/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.ConstructorHelper;
import org.apache.ojb.broker.util.SqlHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PkEnumeration
implements Enumeration,
Serializable {
    protected boolean hasCalledCheck = false;
    protected boolean hasNext = false;
    protected PersistenceBroker broker;
    protected ResultSetAndStatement resultSetAndStatment;
    protected ClassDescriptor classDescriptor;
    protected Constructor constructor;
    static /* synthetic */ Class class$org$apache$ojb$broker$Identity;

    public PkEnumeration(Query query, ClassDescriptor classDescriptor, Class clazz, PersistenceBroker persistenceBroker) {
        this.resultSetAndStatment = persistenceBroker.serviceJdbcAccess().executeQuery(query, classDescriptor);
        this.classDescriptor = classDescriptor;
        this.broker = persistenceBroker;
        try {
            Class[] classArray = new Class[]{class$org$apache$ojb$broker$Identity == null ? (class$org$apache$ojb$broker$Identity = PkEnumeration.class$("org.apache.ojb.broker.Identity")) : class$org$apache$ojb$broker$Identity};
            this.constructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LoggerFactory.getDefaultLogger().error(clazz.getName() + " must implement a Constructor with one argument of type org.apache.ojb.broker.Identity");
            throw new PersistenceBrokerException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            LoggerFactory.getDefaultLogger().error(securityException);
            throw new PersistenceBrokerException(securityException);
        }
    }

    private Identity getIdentityFromResultSet() {
        try {
            Constructor constructor = this.classDescriptor.getZeroArgumentConstructor();
            Object object = ConstructorHelper.instantiate(constructor);
            FieldDescriptor[] fieldDescriptorArray = this.classDescriptor.getPkFields();
            for (int i = 0; i < fieldDescriptorArray.length; ++i) {
                FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
                Object object2 = SqlHelper.getObjectFromColumn(this.resultSetAndStatment.m_rs, fieldDescriptor);
                fieldDescriptor.getPersistentField().set(object, object2);
            }
            Identity identity = new Identity(object, this.broker, this.classDescriptor);
            return identity;
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerSQLException("Error reading object from column", sQLException);
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException("Error reading Identity from result set", exception);
        }
    }

    public boolean hasMoreElements() {
        try {
            if (!this.hasCalledCheck) {
                this.hasCalledCheck = true;
                this.hasNext = this.resultSetAndStatment.m_rs.next();
                if (!this.hasNext) {
                    this.releaseDbResources();
                }
            }
        }
        catch (SQLException sQLException) {
            LoggerFactory.getDefaultLogger().error(sQLException);
            this.hasNext = false;
        }
        return this.hasNext;
    }

    private void releaseDbResources() {
        this.broker.serviceStatementManager().closeResources(this.resultSetAndStatment.m_stmt, this.resultSetAndStatment.m_rs);
    }

    public Object nextElement() {
        try {
            if (!this.hasCalledCheck) {
                this.hasMoreElements();
            }
            this.hasCalledCheck = false;
            if (this.hasNext) {
                Identity identity = this.getIdentityFromResultSet();
                Object[] objectArray = new Identity[]{identity};
                return this.constructor.newInstance(objectArray);
            }
            throw new NoSuchElementException();
        }
        catch (Exception exception) {
            LoggerFactory.getDefaultLogger().error(exception);
            throw new NoSuchElementException();
        }
    }

    protected void finalize() {
        this.releaseDbResources();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

