/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.MaterializationListener;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class IndirectionHandler
implements InvocationHandler,
Serializable {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$IndirectionHandler == null ? (class$org$apache$ojb$broker$accesslayer$IndirectionHandler = IndirectionHandler.class$("org.apache.ojb.broker.accesslayer.IndirectionHandler")) : class$org$apache$ojb$broker$accesslayer$IndirectionHandler);
    private transient PersistenceBroker m_broker = null;
    private PBKey brokerKey;
    private Object realSubject = null;
    private Identity id = null;
    private transient ArrayList listeners;
    private boolean needsClose;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$IndirectionHandler;

    public IndirectionHandler(PBKey pBKey, Identity identity) {
        this.id = identity;
        this.setBrokerKey(pBKey);
    }

    public synchronized void addListener(MaterializationListener materializationListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(materializationListener);
    }

    public synchronized void removeListener(MaterializationListener materializationListener) {
        if (this.listeners != null) {
            this.listeners.remove(materializationListener);
        }
    }

    protected void beforeMaterialization() {
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                MaterializationListener materializationListener = (MaterializationListener)this.listeners.get(i);
                materializationListener.beforeMaterialization(this, this.id);
            }
        }
    }

    protected void afterMaterialization() {
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                MaterializationListener materializationListener = (MaterializationListener)this.listeners.get(i);
                materializationListener.afterMaterialization(this, this.realSubject);
            }
        }
    }

    public Identity getIdentity() {
        return this.id;
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker persistenceBroker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (persistenceBroker == null && this.m_broker == null) {
            this.m_broker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this.needsClose = true;
            persistenceBroker = this.m_broker;
        }
        return persistenceBroker;
    }

    protected void releaseBroker() {
        if (this.m_broker != null && this.needsClose) {
            this.needsClose = false;
            this.m_broker.close();
            this.m_broker = null;
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) {
        Object object2 = null;
        String string = method.getName();
        try {
            if ("hashCode".equals(string)) {
                return new Integer(this.hashCode());
            }
            if (this.realSubject == null && "toString".equals(string)) {
                return "unmaterialized proxy for " + this.id;
            }
            object2 = this.getRealSubject();
            return method.invoke(object2, objectArray);
        }
        catch (Exception exception) {
            log.error("Method invoking failed for method *" + method.getName() + "* on object " + object2, exception);
            throw new PersistenceBrokerException("Error invoking:" + method.getName(), exception);
        }
    }

    public Object getRealSubject() throws PersistenceBrokerException {
        if (this.realSubject == null) {
            this.materializeSubject();
        }
        return this.realSubject;
    }

    public void setRealSubject(Object object) {
        this.realSubject = object;
    }

    private synchronized void materializeSubject() throws PersistenceBrokerException {
        try {
            this.beforeMaterialization();
            this.realSubject = this.getBroker().getObjectByIdentity(this.id);
            if (this.realSubject == null) {
                log.warn("Can not materialize object for Identity " + this.id + " - using PBKey " + this.brokerKey);
            }
            this.afterMaterialization();
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            this.releaseBroker();
        }
    }

    public boolean alreadyMaterialized() {
        return this.realSubject != null;
    }

    protected PBKey getBrokerKey() {
        return this.brokerKey;
    }

    protected void setBrokerKey(PBKey pBKey) {
        this.brokerKey = pBKey;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

