/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionFactoryPooledImpl
extends ConnectionFactoryAbstractImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryPooledImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl);
    private Map connectionPools = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor;

    public void returnConnectionToPool(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) throws LookupException {
        try {
            ((ObjectPool)this.connectionPools.get(jdbcConnectionDescriptor.getPBKey())).returnObject((Object)connection);
        }
        catch (Exception exception) {
            throw new LookupException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnectionFromPool(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        ObjectPool objectPool = (ObjectPool)this.connectionPools.get(jdbcConnectionDescriptor.getPBKey());
        if (objectPool == null) {
            this.log.info("Create new connection pool:" + jdbcConnectionDescriptor);
            objectPool = this.createConnectionPool(jdbcConnectionDescriptor);
            Map map = this.connectionPools;
            synchronized (map) {
                this.connectionPools.put(jdbcConnectionDescriptor.getPBKey(), objectPool);
            }
        }
        try {
            return (Connection)objectPool.borrowObject();
        }
        catch (Exception exception) {
            throw new LookupException("Could not borrow connection from pool - " + (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor).getName() + ":  " + jdbcConnectionDescriptor, exception);
        }
    }

    public ObjectPool createConnectionPool(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("createPool was called");
        }
        ConPoolFactory conPoolFactory = new ConPoolFactory(this, jdbcConnectionDescriptor);
        GenericObjectPool.Config config = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getObjectPoolConfig();
        GenericObjectPool genericObjectPool = new GenericObjectPool((PoolableObjectFactory)conPoolFactory, config);
        return genericObjectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllResources() {
        super.releaseAllResources();
        Map map = this.connectionPools;
        synchronized (map) {
            Collection collection = this.connectionPools.values();
            this.connectionPools = new HashMap();
            ObjectPool objectPool = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    objectPool = (ObjectPool)iterator.next();
                    objectPool.close();
                }
                catch (Exception exception) {
                    this.log.error("Exception occured while closing pool " + objectPool, exception);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConPoolFactory
    extends BasePoolableObjectFactory {
        int failedValidationQuery;
        JdbcConnectionDescriptor jcd;
        ConnectionFactoryPooledImpl cf;

        public ConPoolFactory(ConnectionFactoryPooledImpl connectionFactoryPooledImpl2, JdbcConnectionDescriptor jdbcConnectionDescriptor) {
            this.cf = connectionFactoryPooledImpl2;
            this.jcd = jdbcConnectionDescriptor;
        }

        public boolean validateObject(Object object) {
            Connection connection = (Connection)object;
            String string = this.jcd.getConnectionPoolDescriptor().getValidationQuery();
            if (string == null || string.trim().equals("")) {
                try {
                    return !connection.isClosed();
                }
                catch (SQLException sQLException) {
                    ConnectionFactoryPooledImpl.this.log.warn("Connection validation failed: " + sQLException.getMessage());
                    if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                        ConnectionFactoryPooledImpl.this.log.debug(sQLException);
                    }
                    return false;
                }
            }
            return this.validateConnection(connection, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean validateConnection(Connection connection, String string) {
            Statement statement = null;
            ResultSet resultSet = null;
            if (this.failedValidationQuery > 100) {
                throw new OJBRuntimeException("Validation of connection " + connection + " using validation query " + string + " failed more than 100 times.");
            }
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                if (resultSet.next()) {
                    this.failedValidationQuery = 0;
                    boolean bl = true;
                    return bl;
                }
                ++this.failedValidationQuery;
                ConnectionFactoryPooledImpl.this.log.warn("Validation query '" + string + "' result set does not match, discard connection");
                boolean bl = false;
                return bl;
            }
            catch (SQLException sQLException) {
                ++this.failedValidationQuery;
                ConnectionFactoryPooledImpl.this.log.warn("Validation query for connection failed, discard connection. Query was " + string + ", Message was " + sQLException.getMessage());
                if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                    ConnectionFactoryPooledImpl.this.log.debug(sQLException);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }

        public Object makeObject() throws Exception {
            if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                ConnectionFactoryPooledImpl.this.log.debug("makeObject called");
            }
            return this.cf.newConnectionFromDriverManager(this.jcd);
        }

        public void destroyObject(Object object) throws Exception {
            ConnectionFactoryPooledImpl.this.log.info("Destroy object was called, try to close connection: " + object);
            try {
                ((Connection)object).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

