/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionFactoryDBCPImpl
extends ConnectionFactoryAbstractImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl = ConnectionFactoryDBCPImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryDBCPImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl);
    private Map poolMap = new HashMap();
    private ObjectPool connectionPool;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl;

    public Connection getConnectionFromPool(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        DataSource dataSource = (DataSource)this.poolMap.get(jdbcConnectionDescriptor.getPBKey());
        if (dataSource == null) {
            try {
                dataSource = this.setupPool(jdbcConnectionDescriptor);
                this.poolMap.put(jdbcConnectionDescriptor.getPBKey(), dataSource);
            }
            catch (Exception exception) {
                this.log.error("Could not setup DataSource for " + jdbcConnectionDescriptor, exception);
                throw new LookupException(exception);
            }
        }
        try {
            Connection connection = dataSource.getConnection();
            return connection;
        }
        catch (SQLException sQLException) {
            throw new LookupException("Can't get connection from DBCP-DataSource", sQLException);
        }
    }

    public void returnConnectionToPool(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) throws LookupException {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.log.warn("Connection close failed", sQLException);
        }
    }

    protected DataSource setupPool(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws Exception {
        this.log.info("Create new DBCP connection pool:" + jdbcConnectionDescriptor);
        try {
            ClassHelper.newInstance(jdbcConnectionDescriptor.getDriver());
        }
        catch (Exception exception) {
            this.log.error("Could not instantiate jdbc driver", exception);
        }
        GenericObjectPool.Config config = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getObjectPoolConfig();
        this.connectionPool = new GenericObjectPool(null, config);
        DriverManagerConnectionFactory driverManagerConnectionFactory = new DriverManagerConnectionFactory(this.getDbURL(jdbcConnectionDescriptor), jdbcConnectionDescriptor.getUserName(), jdbcConnectionDescriptor.getPassWord());
        GenericKeyedObjectPoolFactory genericKeyedObjectPoolFactory = new GenericKeyedObjectPoolFactory(null);
        String string = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getValidationQuery();
        boolean bl = false;
        boolean bl2 = jdbcConnectionDescriptor.getUseAutoCommit() != 2;
        AbandonedConfig abandonedConfig = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getAbandonedConfig();
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, this.connectionPool, (KeyedObjectPoolFactory)genericKeyedObjectPoolFactory, string, bl, bl2, abandonedConfig);
        PoolingDataSource poolingDataSource = new PoolingDataSource(this.connectionPool);
        return poolingDataSource;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

