/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.CollectionProxyListener;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.query.Query;

public class CollectionProxy
implements Collection,
ManageableCollection {
    private transient PersistenceBroker m_broker;
    private PBKey m_brokerKey;
    private Query m_query;
    private Collection m_data;
    private Class m_collectionClass;
    private int m_size = -1;
    private boolean needsClose;
    private transient ArrayList m_listeners;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;

    public CollectionProxy(PBKey pBKey, Query query) {
        this(pBKey, class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = CollectionProxy.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query);
    }

    public CollectionProxy(PBKey pBKey, Class clazz, Query query) {
        this.setBrokerKey(pBKey);
        this.setCollectionClass(clazz);
        this.setQuery(query);
    }

    public boolean isLoaded() {
        return this.m_data != null;
    }

    protected synchronized void loadSize() throws PersistenceBrokerException {
        try {
            this.m_size = this.getBroker().getCount(this.getQuery());
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            this.releaseBroker();
        }
    }

    protected Collection loadData() throws PersistenceBrokerException {
        try {
            this.beforeLoading();
            Collection collection = this.m_data != null ? this.m_data : (this.m_size != 0 ? (Collection)((Object)this.getBroker().getCollectionByQuery(this.getCollectionClass(), this.getQuery())) : (Collection)this.getCollectionClass().newInstance());
            this.afterLoading();
            Collection collection2 = collection;
            return collection2;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
        finally {
            this.releaseBroker();
        }
    }

    protected void beforeLoading() {
        if (this.m_listeners != null) {
            for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
                CollectionProxyListener collectionProxyListener = (CollectionProxyListener)this.m_listeners.get(i);
                collectionProxyListener.beforeLoading(this);
            }
        }
    }

    protected void afterLoading() {
        if (this.m_listeners != null) {
            for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
                CollectionProxyListener collectionProxyListener = (CollectionProxyListener)this.m_listeners.get(i);
                collectionProxyListener.afterLoading(this);
            }
        }
    }

    public int size() {
        if (this.isLoaded()) {
            return this.getData().size();
        }
        if (this.m_size < 0) {
            this.loadSize();
        }
        return this.m_size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        return this.getData().contains(object);
    }

    public Iterator iterator() {
        return this.getData().iterator();
    }

    public Object[] toArray() {
        return this.getData().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getData().toArray(objectArray);
    }

    public boolean add(Object object) {
        return this.getData().add(object);
    }

    public boolean remove(Object object) {
        return this.getData().remove(object);
    }

    public boolean containsAll(Collection collection) {
        return this.getData().containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        return this.getData().addAll(collection);
    }

    public boolean removeAll(Collection collection) {
        return this.getData().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.getData().retainAll(collection);
    }

    public void clear() {
        ArrayList arrayList;
        try {
            arrayList = (ArrayList)this.getCollectionClass().newInstance();
        }
        catch (Exception exception) {
            arrayList = new ArrayList();
        }
        this.setData(arrayList);
        this.m_size = 0;
    }

    protected Query getQuery() {
        return this.m_query;
    }

    protected void setQuery(Query query) {
        this.m_query = query;
    }

    protected synchronized void releaseBroker() {
        if (this.m_broker != null && this.needsClose) {
            this.needsClose = false;
            this.m_broker.close();
            this.m_broker = null;
        }
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker persistenceBroker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (persistenceBroker == null && this.m_broker == null) {
            this.m_broker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this.needsClose = true;
            persistenceBroker = this.m_broker;
        }
        return persistenceBroker;
    }

    public synchronized Collection getData() {
        if (!this.isLoaded()) {
            this.setData(this.loadData());
        }
        return this.m_data;
    }

    protected void setData(Collection collection) {
        this.m_data = collection;
    }

    protected Class getCollectionClass() {
        return this.m_collectionClass;
    }

    protected void setCollectionClass(Class clazz) {
        this.m_collectionClass = clazz;
    }

    public void ojbAdd(Object object) {
        this.add(object);
    }

    public void ojbAddAll(ManageableCollection manageableCollection) {
        this.addAll((Collection)((CollectionProxy)manageableCollection));
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        Collection collection = this.getData();
        if (collection instanceof ManageableCollection) {
            ((ManageableCollection)((Object)collection)).afterStore(persistenceBroker);
        }
    }

    protected PBKey getBrokerKey() {
        return this.m_brokerKey;
    }

    protected void setBrokerKey(PBKey pBKey) {
        this.m_brokerKey = pBKey;
    }

    public synchronized void addListener(CollectionProxyListener collectionProxyListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        this.m_listeners.add(collectionProxyListener);
    }

    public synchronized void removeListener(CollectionProxyListener collectionProxyListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(collectionProxyListener);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

