/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.CollectionProxy;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.collections.RemovalAwareCollection;

public class CollectionPrefetcher
extends RelationshipPrefetcherImpl {
    public CollectionPrefetcher(PersistenceBroker persistenceBroker, ObjectReferenceDescriptor objectReferenceDescriptor) {
        super(persistenceBroker, objectReferenceDescriptor);
    }

    protected Query[] buildPrefetchQueries(Collection collection, Collection collection2) {
        ClassDescriptor classDescriptor = this.getOwnerClassDescriptor();
        Class clazz = this.getBroker().getTopLevelClass(classDescriptor.getClassOfObject());
        BrokerHelper brokerHelper = this.getBroker().serviceBrokerHelper();
        ArrayList<Query> arrayList = new ArrayList<Query>();
        HashSet<Identity> hashSet = new HashSet<Identity>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object[] objectArray = brokerHelper.getKeyValues(classDescriptor, e);
            Identity identity = new Identity(null, clazz, objectArray);
            hashSet.add(identity);
            if (hashSet.size() != this.pkLimit) continue;
            arrayList.add(this.buildPrefetchQuery(hashSet));
            hashSet.clear();
        }
        if (hashSet.size() > 0) {
            arrayList.add(this.buildPrefetchQuery(hashSet));
        }
        return arrayList.toArray(new Query[arrayList.size()]);
    }

    protected Query buildPrefetchQuery(Collection collection) {
        CollectionDescriptor collectionDescriptor = this.getCollectionDescriptor();
        QueryByCriteria queryByCriteria = this.buildPrefetchQuery(collection, collectionDescriptor.getForeignKeyFieldDescriptors(this.getItemClassDescriptor()));
        if (!collectionDescriptor.getOrderBy().isEmpty()) {
            Iterator iterator = collectionDescriptor.getOrderBy().iterator();
            while (iterator.hasNext()) {
                queryByCriteria.addOrderBy((FieldHelper)iterator.next());
            }
        }
        return queryByCriteria;
    }

    protected void associateBatched(Collection collection, Collection collection2) {
        ArrayList arrayList;
        Identity identity;
        CollectionDescriptor collectionDescriptor = this.getCollectionDescriptor();
        ClassDescriptor classDescriptor = this.getItemClassDescriptor();
        PersistentField persistentField = collectionDescriptor.getPersistentField();
        PersistenceBroker persistenceBroker = this.getBroker();
        Class clazz = persistenceBroker.getTopLevelClass(this.getOwnerClassDescriptor().getClassOfObject());
        Class clazz2 = collectionDescriptor.getCollectionClass();
        HashMap hashMap = new HashMap();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object[] objectArray = collectionDescriptor.getForeignKeyValues(e, classDescriptor);
            identity = new Identity(null, clazz, objectArray);
            arrayList = (ArrayList)hashMap.get(identity);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(identity, arrayList);
            }
            arrayList.add(e);
        }
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            Object e = iterator.next();
            identity = new Identity(e, persistenceBroker);
            arrayList = (ArrayList)hashMap.get(identity);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if (clazz2 == null && persistentField.getType().isArray()) {
                int n = arrayList.size();
                object3 = persistentField.getType().getComponentType();
                object2 = Array.newInstance(object3, n);
                for (int i = 0; i < n; ++i) {
                    Array.set(object2, i, arrayList.get(i));
                }
            } else {
                if (clazz2 == null) {
                    object = new RemovalAwareCollection();
                } else {
                    try {
                        object = (ManageableCollection)clazz2.newInstance();
                    }
                    catch (Exception exception) {
                        throw new OJBRuntimeException("Can't create new Collection for owner", exception);
                    }
                }
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object.ojbAdd(object3.next());
                }
                object2 = object;
            }
            if ((object = persistentField.get(e)) instanceof CollectionProxy && object2 instanceof Collection) {
                ((CollectionProxy)object).setData((Collection)object2);
                continue;
            }
            persistentField.set(e, object2);
        }
    }

    protected CollectionDescriptor getCollectionDescriptor() {
        return (CollectionDescriptor)this.getObjectReferenceDescriptor();
    }

    protected Class getCollectionClass() {
        return this.getCollectionDescriptor().getCollectionClass();
    }
}

