/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class BasePrefetcher
implements RelationshipPrefetcher {
    private Logger logger;
    private PersistenceBroker broker;
    protected ClassDescriptor itemClassDesc;
    protected final int pkLimit;
    protected static final int IN_LIMIT = BasePrefetcher.getPrefetchInLimit();

    private static int getPrefetchInLimit() {
        try {
            PersistenceBrokerConfiguration persistenceBrokerConfiguration = (PersistenceBrokerConfiguration)((Object)PersistenceBrokerFactory.getConfigurator().getConfigurationFor(null));
            return persistenceBrokerConfiguration.getSqlInLimit();
        }
        catch (ConfigurationException configurationException) {
            return 200;
        }
    }

    public BasePrefetcher(PersistenceBroker persistenceBroker, Class clazz) {
        this.broker = persistenceBroker;
        this.itemClassDesc = persistenceBroker.getDescriptorRepository().getDescriptorFor(clazz);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.pkLimit = BasePrefetcher.getPrefetchInLimit() / this.getItemClassDescriptor().getPkFields().length;
    }

    public int getLimit() {
        return this.pkLimit;
    }

    protected abstract void associateBatched(Collection var1, Collection var2);

    public void prefetchRelationship(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Class clazz = this.getCollectionClass();
        Query[] queryArray = this.buildPrefetchQueries(collection, arrayList);
        for (int i = 0; i < queryArray.length; ++i) {
            Collection collection2 = clazz != null ? (Collection)((Object)this.broker.getCollectionByQuery(clazz, queryArray[i])) : this.broker.getCollectionByQuery(queryArray[i]);
            arrayList.addAll(collection2);
        }
        this.associateBatched(collection, arrayList);
    }

    protected QueryByCriteria buildPrefetchQuery(Collection collection, FieldDescriptor[] fieldDescriptorArray) {
        return this.buildPrefetchQuery(this.getItemClassDescriptor().getClassOfObject(), collection, fieldDescriptorArray);
    }

    protected QueryByCriteria buildPrefetchQuery(Class clazz, Collection collection, FieldDescriptor[] fieldDescriptorArray) {
        Criteria criteria = fieldDescriptorArray.length == 1 ? this.buildPrefetchCriteriaSingleKey(collection, fieldDescriptorArray[0]) : this.buildPrefetchCriteriaMultipleKeys(collection, fieldDescriptorArray);
        return QueryFactory.newQuery(clazz, criteria);
    }

    protected Criteria buildPrefetchCriteriaSingleKey(Collection collection, FieldDescriptor fieldDescriptor) {
        Criteria criteria = new Criteria();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            arrayList.add(identity.getPrimaryKeyValues()[0]);
        }
        switch (arrayList.size()) {
            case 0: {
                break;
            }
            case 1: {
                criteria.addEqualTo(fieldDescriptor.getAttributeName(), arrayList.get(0));
                break;
            }
            default: {
                criteria.addIn(fieldDescriptor.getAttributeName(), arrayList);
            }
        }
        return criteria;
    }

    private Criteria buildPrefetchCriteriaMultipleKeys(Collection collection, FieldDescriptor[] fieldDescriptorArray) {
        Criteria criteria = new Criteria();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Criteria criteria2 = new Criteria();
            Identity identity = (Identity)iterator.next();
            Object[] objectArray = identity.getPrimaryKeyValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    criteria2.addIsNull(fieldDescriptorArray[i].getAttributeName());
                    continue;
                }
                criteria2.addEqualTo(fieldDescriptorArray[i].getAttributeName(), objectArray[i]);
            }
            criteria.addOrCriteria(criteria2);
        }
        return criteria;
    }

    protected DescriptorRepository getDescriptorRepository() {
        return this.getBroker().getDescriptorRepository();
    }

    public ClassDescriptor getItemClassDescriptor() {
        return this.itemClassDesc;
    }

    protected abstract Query[] buildPrefetchQueries(Collection var1, Collection var2);

    protected PersistenceBroker getBroker() {
        return this.broker;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected Class getCollectionClass() {
        return null;
    }
}

