/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;

public class Identity
implements Serializable {
    private Class m_objectsTopLevelClass;
    private Class m_objectsRealClass = null;
    private Object[] m_pkValues;
    private String m_stringRepresentation = null;
    private Integer m_hashCode;

    public Identity(Class clazz, Class clazz2, Object[] objectArray) {
        this.m_objectsTopLevelClass = clazz2;
        this.m_objectsRealClass = clazz;
        this.m_pkValues = objectArray;
        this.checkForPrimaryKeys();
    }

    public Identity(Object object, PersistenceBroker persistenceBroker) {
        this.init(object, persistenceBroker, null);
    }

    public Identity(Object object, PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor) {
        this.init(object, persistenceBroker, classDescriptor);
    }

    private void init(Object object, PersistenceBroker persistenceBroker, ClassDescriptor classDescriptor) {
        try {
            if (object instanceof VirtualProxy) {
                VirtualProxy virtualProxy = (VirtualProxy)object;
                Identity identity = virtualProxy.getIdentity();
                this.m_objectsTopLevelClass = identity.m_objectsTopLevelClass;
                this.m_objectsRealClass = identity.m_objectsRealClass;
                this.m_pkValues = identity.m_pkValues;
            } else if (object instanceof Proxy) {
                IndirectionHandler indirectionHandler = (IndirectionHandler)Proxy.getInvocationHandler(object);
                Identity identity = indirectionHandler.getIdentity();
                this.m_objectsTopLevelClass = identity.m_objectsTopLevelClass;
                this.m_objectsRealClass = identity.m_objectsRealClass;
                this.m_pkValues = identity.m_pkValues;
            } else {
                if (classDescriptor == null) {
                    classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
                }
                this.m_objectsTopLevelClass = persistenceBroker.getTopLevelClass(object.getClass());
                this.m_objectsRealClass = object.getClass();
                this.m_pkValues = persistenceBroker.serviceBrokerHelper().getKeyValues(classDescriptor, object, false);
            }
            this.checkForPrimaryKeys();
        }
        catch (Exception exception) {
            throw new ClassNotPersistenceCapableException("Can not init Identity for given object " + object.getClass(), exception);
        }
    }

    public static Identity fromByteArray(byte[] byArray) throws PersistenceBrokerException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            Identity identity = (Identity)objectInputStream.readObject();
            objectInputStream.close();
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return identity;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
    }

    public Class getObjectsTopLevelClass() {
        return this.m_objectsTopLevelClass;
    }

    public Class getObjectsRealClass() {
        return this.m_objectsRealClass;
    }

    public void setObjectsRealClass(Class clazz) {
        this.m_objectsRealClass = clazz;
    }

    public byte[] serialize() throws PersistenceBrokerException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw new PersistenceBrokerException(exception);
        }
    }

    public String toString() {
        if (this.m_stringRepresentation == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_objectsTopLevelClass.getName());
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                stringBuffer.append(i == 0 ? "{" : ",");
                stringBuffer.append(this.m_pkValues[i]);
            }
            stringBuffer.append("}");
            this.m_stringRepresentation = stringBuffer.toString();
        }
        return this.m_stringRepresentation;
    }

    protected void checkForPrimaryKeys() throws ClassNotPersistenceCapableException {
        if (this.m_pkValues.length == 0) {
            throw new ClassNotPersistenceCapableException("OJB needs at least one primary key attribute for class  objectsRealClass=" + this.m_objectsRealClass + ", objectTopLevelClass=" + this.m_objectsTopLevelClass);
        }
    }

    public Object[] getPrimaryKeyValues() {
        return this.m_pkValues;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object instanceof Identity) {
            Identity identity = (Identity)object;
            Object[] objectArray = identity.getPrimaryKeyValues();
            bl = this.getObjectsTopLevelClass().equals(identity.getObjectsTopLevelClass());
            bl = bl && this.m_pkValues.length == objectArray.length;
            for (int i = 0; bl && i < this.m_pkValues.length; ++i) {
                bl = this.m_pkValues[i] == null ? objectArray[i] == null : this.m_pkValues[i].equals(objectArray[i]);
            }
        } else {
            bl = super.equals(object);
        }
        return bl;
    }

    public int hashCode() {
        if (this.m_hashCode == null) {
            int n = this.getObjectsTopLevelClass().hashCode();
            for (int i = 0; i < this.m_pkValues.length; ++i) {
                if (this.m_pkValues[i] == null) continue;
                n ^= this.m_pkValues[i].hashCode();
            }
            this.m_hashCode = new Integer(n);
        }
        return this.m_hashCode;
    }
}

