/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.lexicon;

import java.util.Enumeration;
import java.util.Vector;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.lexicon.Lexeme;

public class Lexicon {
    private Vector lexemes = new Vector();
    private String location = null;

    public void addLexeme(Lexeme lexeme) {
        this.lexemes.addElement(lexeme);
    }

    public Object clone() throws CloneNotSupportedException {
        Lexicon clone = new Lexicon();
        int i = 0;
        while (i < this.lexemes.size()) {
            clone.lexemes.addElement(((Lexeme)this.lexemes.elementAt(i)).clone());
            ++i;
        }
        clone.location = this.location;
        return clone;
    }

    public Lexeme getLexeme(int index) {
        return (Lexeme)this.lexemes.elementAt(index);
    }

    public int getLexemeCount() {
        return this.lexemes.size();
    }

    public String getLocation() {
        return this.location;
    }

    public void removeLexeme(Lexeme lexeme) {
        this.lexemes.removeElement(lexeme);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.lexemes.size() == 0) {
            violations.addViolation("Lexicon contains not lexemes", this.location);
        }
        Enumeration en = this.lexemes.elements();
        while (en.hasMoreElements()) {
            violations.addViolations(((Lexeme)en.nextElement()).validate());
        }
        return violations;
    }
}

