/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.sax;

import java.util.Stack;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.grammar.Production;
import net.sourceforge.chaperon.model.symbol.Nonterminal;
import net.sourceforge.chaperon.model.symbol.Symbol;
import net.sourceforge.chaperon.model.symbol.Terminal;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GrammarFactory
extends DefaultHandler {
    public static final String URI = "http://chaperon.sourceforge.net/schema/grammar/1.0";
    public static final String GRAMMAR_ELEMENT = "grammar";
    public static final String PRODUCTION_ELEMENT = "production";
    public static final String NONTERMINALSYMBOL_ELEMENT = "nonterminal";
    public static final String TERMINALSYMBOL_ELEMENT = "terminal";
    public static final String STARTSYMBOL_ELEMENT = "start";
    public static final String SYMBOL_ATTRIBUTE = "symbol";
    private Grammar grammar;
    private Stack stack;

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (namespaceURI.equals(URI)) {
                if (localName.equals(GRAMMAR_ELEMENT)) {
                    this.grammar = (Grammar)this.stack.pop();
                } else if (localName.equals(PRODUCTION_ELEMENT)) {
                    Production production = (Production)this.stack.pop();
                    Grammar grammar = (Grammar)this.stack.peek();
                    grammar.addProduction(production);
                } else if (localName.equals(NONTERMINALSYMBOL_ELEMENT)) {
                    Symbol ntsymbol = (Symbol)this.stack.pop();
                    Production production = (Production)this.stack.peek();
                    production.getDefinition().addSymbol(ntsymbol);
                } else if (localName.equals(TERMINALSYMBOL_ELEMENT)) {
                    Symbol tsymbol = (Symbol)this.stack.pop();
                    Production production = (Production)this.stack.peek();
                    production.getDefinition().addSymbol(tsymbol);
                } else if (localName.equals(STARTSYMBOL_ELEMENT)) {
                    Nonterminal ssymbol = (Nonterminal)this.stack.pop();
                    Grammar grammar = (Grammar)this.stack.peek();
                    grammar.setStartSymbol(ssymbol);
                } else {
                    System.out.println("name=" + localName + " ns=" + namespaceURI + " qname=" + qName + " would not process");
                }
            } else {
                System.out.println("name=" + localName + " ns=" + namespaceURI + " qname=" + qName + " would not process");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public void startDocument() {
        this.stack = new Stack();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (namespaceURI.equals(URI)) {
                if (localName.equals(GRAMMAR_ELEMENT)) {
                    this.grammar = new Grammar();
                    this.stack.push(this.grammar);
                } else if (localName.equals(PRODUCTION_ELEMENT)) {
                    Production production = new Production(new Nonterminal(atts.getValue(SYMBOL_ATTRIBUTE)));
                    this.stack.push(production);
                } else if (localName.equals(NONTERMINALSYMBOL_ELEMENT)) {
                    this.stack.push(new Nonterminal(atts.getValue(SYMBOL_ATTRIBUTE)));
                } else if (localName.equals(TERMINALSYMBOL_ELEMENT)) {
                    this.stack.push(new Terminal(atts.getValue(SYMBOL_ATTRIBUTE)));
                } else if (localName.equals(STARTSYMBOL_ELEMENT)) {
                    this.stack.push(new Nonterminal(atts.getValue(SYMBOL_ATTRIBUTE)));
                } else {
                    System.out.println("name=" + localName + " ns=" + namespaceURI + " qname=" + qName + " would not process");
                }
            } else {
                System.out.println("name=" + localName + " ns=" + namespaceURI + " qname=" + qName + " would not process");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

