/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.avalon;

import net.sourceforge.chaperon.adapter.avalon.PatternFactory;
import net.sourceforge.chaperon.model.lexicon.Lexeme;
import net.sourceforge.chaperon.model.lexicon.Lexicon;
import net.sourceforge.chaperon.model.symbol.Terminal;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class LexiconFactory {
    public static final String NS = "http://chaperon.sourceforge.net/schema/lexicon/1.0";
    public static final String LEXEME_ELEMENT = "lexeme";
    public static final String SYMBOL_ATTRIBUTE = "symbol";
    public static final String LEXICON_ELEMENT = "lexicon";

    public static Lexicon createLexicon(Configuration config) throws ConfigurationException {
        if (!config.getName().equals(LEXICON_ELEMENT)) {
            return null;
        }
        Lexicon lexicon = new Lexicon();
        lexicon.setLocation(config.getLocation());
        Configuration[] lexemeconfigs = config.getChildren(LEXEME_ELEMENT);
        int i = 0;
        while (i < lexemeconfigs.length) {
            Configuration[] definition;
            Lexeme lexeme = new Lexeme();
            lexeme.setLocation(lexemeconfigs[i].getLocation());
            if (lexemeconfigs[i].getAttribute(SYMBOL_ATTRIBUTE, null) != null) {
                lexeme.setSymbol(new Terminal(lexemeconfigs[i].getAttribute(SYMBOL_ATTRIBUTE)));
            }
            if ((definition = lexemeconfigs[i].getChildren()).length > 1) {
                throw new ConfigurationException("More than one root pattern found[" + lexemeconfigs[i].getLocation() + "]");
            }
            if (definition.length == 1) {
                lexeme.setDefinition(PatternFactory.createPattern(definition[0]));
            }
            lexicon.addLexeme(lexeme);
            ++i;
        }
        return lexicon;
    }
}

