/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.apache.fop.messaging.MessageHandler;

public class LoadableProperties
extends Hashtable {
    public void load(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
        String line = this.getNextLine(in);
        while (line != null) {
            if (this.isValid(line = line.trim())) {
                int index = line.indexOf("=");
                String aKey = line.substring(0, index);
                String aValue = line.substring(index + 1);
                this.put(aKey, aValue);
            }
            line = this.getNextLine(in);
        }
    }

    private boolean isValid(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() > 0) {
            if (str.startsWith("#") || str.startsWith("!")) {
                return false;
            }
        } else {
            return false;
        }
        int index = str.indexOf("=");
        if (index > 0 && str.length() > index) {
            return true;
        }
        MessageHandler.logln(this.getClass().getName() + ": load(): invalid line " + str + "." + " Character '=' missed.");
        return false;
    }

    private String getNextLine(BufferedReader br) {
        try {
            return br.readLine();
        }
        catch (Exception e) {
            return null;
        }
    }
}

