/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.ICULocaleService;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UnicodeSet;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;

public abstract class Collator
implements Comparator,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int QUATERNARY = 3;
    public static final int IDENTICAL = 15;
    public static final int NO_DECOMPOSITION = 16;
    public static final int CANONICAL_DECOMPOSITION = 17;
    private static ICULocaleService service;
    private int m_strength_ = 2;
    private int m_decomposition_ = 17;
    static /* synthetic */ Class class$com$ibm$icu$text$Collator;

    public void setStrength(int newStrength) {
        if (newStrength != 0 && newStrength != 1 && newStrength != 2 && newStrength != 3 && newStrength != 15) {
            throw new IllegalArgumentException("Incorrect comparison level.");
        }
        this.m_strength_ = newStrength;
    }

    public void setDecomposition(int decomposition) {
        if (decomposition != 16 && decomposition != 17) {
            throw new IllegalArgumentException("Wrong decomposition mode.");
        }
        this.m_decomposition_ = decomposition;
    }

    public static final Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static final Collator getInstance(Locale locale) {
        if (service == null) {
            return new RuleBasedCollator(locale);
        }
        try {
            return (Collator)((Collator)service.get(locale)).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static ICULocaleService getService() {
        if (service == null) {
            ICULocaleService newService = new ICULocaleService("Collator");
            class CollatorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                CollatorFactory() {
                }

                protected Object handleCreate(Locale loc, int kind, ICUService service) {
                    return new RuleBasedCollator(loc);
                }
            }
            newService.registerFactory(new CollatorFactory());
            Class clazz = class$com$ibm$icu$text$Collator == null ? (class$com$ibm$icu$text$Collator = Collator.class$("com.ibm.icu.text.Collator")) : class$com$ibm$icu$text$Collator;
            synchronized (clazz) {
                if (service == null) {
                    service = newService;
                }
            }
        }
        return service;
    }

    static final Object register(Collator collator, Locale locale) {
        return Collator.getService().registerObject((Object)collator, locale);
    }

    static final boolean unregister(Object registryKey) {
        if (service != null) {
            return service.unregisterFactory((ICUService.Factory)registryKey);
        }
        return false;
    }

    public static final Locale[] getAvailableLocales() {
        if (service != null) {
            return service.getAvailableLocales();
        }
        return ICULocaleData.getAvailableLocales();
    }

    static final Map getDisplayNames(Locale locale) {
        return Collator.getService().getDisplayNames(locale);
    }

    public int getStrength() {
        return this.m_strength_;
    }

    public int getDecomposition() {
        return this.m_decomposition_;
    }

    public int compare(Object source, Object target) {
        if (!(source instanceof String) || !(target instanceof String)) {
            throw new IllegalArgumentException("Arguments have to be of type String");
        }
        return this.compare((String)source, (String)target);
    }

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    public UnicodeSet getTailoredSet() {
        return new UnicodeSet(0, 0x10FFFF);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract int compare(String var1, String var2);

    public abstract CollationKey getCollationKey(String var1);

    protected Collator() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

