/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.relaxng.util.ErrorHandlerImpl;
import com.thaiopensource.relaxng.util.Jaxp11XMLReaderCreator;
import com.thaiopensource.relaxng.util.ValidationEngine;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.Version;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Driver {
    private static String usageKey = "usage";
    private boolean checkId = true;
    private boolean compactSyntax = false;
    private boolean feasible = false;
    private boolean timing = false;
    private String encoding = null;
    static /* synthetic */ Class class$com$thaiopensource$relaxng$util$Driver;

    Driver() {
    }

    public static void setUsageKey(String string) {
        usageKey = string;
    }

    public static void main(String[] stringArray) {
        System.exit(new Driver().doMain(stringArray));
    }

    public int doMain(String[] stringArray) {
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl(System.out);
        OptionParser optionParser = new OptionParser("itcfe:", stringArray);
        try {
            while (optionParser.moveToNextOption()) {
                switch (optionParser.getOptionChar()) {
                    case 'i': {
                        this.checkId = false;
                        break;
                    }
                    case 'c': {
                        this.compactSyntax = true;
                        break;
                    }
                    case 't': {
                        this.timing = true;
                        break;
                    }
                    case 'e': {
                        this.encoding = optionParser.getOptionArg();
                        break;
                    }
                    case 'f': {
                        this.feasible = true;
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException invalidOptionException) {
            errorHandlerImpl.print(errorHandlerImpl.format("invalid_option", new Object[]{optionParser.getOptionCharString()}));
            return 2;
        }
        catch (OptionParser.MissingArgumentException missingArgumentException) {
            errorHandlerImpl.print(errorHandlerImpl.format("option_missing_argument", new Object[]{optionParser.getOptionCharString()}));
            return 2;
        }
        stringArray = optionParser.getRemainingArgs();
        if (stringArray.length < 1) {
            errorHandlerImpl.print(errorHandlerImpl.format(usageKey, new Object[]{Version.getVersion(class$com$thaiopensource$relaxng$util$Driver == null ? (class$com$thaiopensource$relaxng$util$Driver = Driver.class$("com.thaiopensource.relaxng.util.Driver")) : class$com$thaiopensource$relaxng$util$Driver)}));
            return 2;
        }
        long l = System.currentTimeMillis();
        long l2 = -1L;
        boolean bl = false;
        try {
            ValidationEngine validationEngine = new ValidationEngine(new Jaxp11XMLReaderCreator(), errorHandlerImpl, this.checkId, this.compactSyntax, this.feasible);
            InputSource inputSource = ValidationEngine.uriOrFileInputSource(stringArray[0]);
            if (this.encoding != null) {
                inputSource.setEncoding(this.encoding);
            }
            if (validationEngine.loadSchema(inputSource)) {
                l2 = System.currentTimeMillis();
                int n = 1;
                while (n < stringArray.length) {
                    if (!validationEngine.validate(ValidationEngine.uriOrFileInputSource(stringArray[n]))) {
                        bl = true;
                    }
                    ++n;
                }
            } else {
                bl = true;
            }
        }
        catch (SAXException sAXException) {
            bl = true;
            errorHandlerImpl.printException(sAXException);
        }
        catch (IOException iOException) {
            bl = true;
            errorHandlerImpl.printException(iOException);
        }
        if (this.timing) {
            long l3 = System.currentTimeMillis();
            if (l2 < 0L) {
                l2 = l3;
            }
            errorHandlerImpl.print(errorHandlerImpl.format("elapsed_time", new Object[]{new Long(l2 - l), new Long(l3 - l2), new Long(l3 - l)}));
        }
        if (bl) {
            return 1;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

