/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.AnyUriDatatype;
import com.thaiopensource.datatype.xsd.Base64BinaryDatatype;
import com.thaiopensource.datatype.xsd.BooleanDatatype;
import com.thaiopensource.datatype.xsd.CdataDatatype;
import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.DatatypeBuilderImpl;
import com.thaiopensource.datatype.xsd.DateTimeDatatype;
import com.thaiopensource.datatype.xsd.DecimalDatatype;
import com.thaiopensource.datatype.xsd.DoubleDatatype;
import com.thaiopensource.datatype.xsd.DurationDatatype;
import com.thaiopensource.datatype.xsd.EntityDatatype;
import com.thaiopensource.datatype.xsd.FloatDatatype;
import com.thaiopensource.datatype.xsd.HexBinaryDatatype;
import com.thaiopensource.datatype.xsd.IdDatatype;
import com.thaiopensource.datatype.xsd.IdrefDatatype;
import com.thaiopensource.datatype.xsd.IntegerRestrictDatatype;
import com.thaiopensource.datatype.xsd.ListDatatype;
import com.thaiopensource.datatype.xsd.MaxInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinLengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.NCNameDatatype;
import com.thaiopensource.datatype.xsd.NameDatatype;
import com.thaiopensource.datatype.xsd.NmtokenDatatype;
import com.thaiopensource.datatype.xsd.QNameDatatype;
import com.thaiopensource.datatype.xsd.RegexDatatype;
import com.thaiopensource.datatype.xsd.StringDatatype;
import com.thaiopensource.datatype.xsd.TokenDatatype;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Service;
import java.util.Enumeration;
import java.util.Hashtable;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;

public class DatatypeLibraryImpl
implements DatatypeLibrary {
    private final Hashtable typeTable = new Hashtable();
    private RegexEngine regexEngine = this.findRegexEngine();
    private static final String LONG_MAX = "9223372036854775807";
    private static final String LONG_MIN = "-9223372036854775808";
    private static final String INT_MAX = "2147483647";
    private static final String INT_MIN = "-2147483648";
    private static final String SHORT_MAX = "32767";
    private static final String SHORT_MIN = "-32768";
    private static final String BYTE_MAX = "127";
    private static final String BYTE_MIN = "-128";
    private static final String UNSIGNED_LONG_MAX = "18446744073709551615";
    private static final String UNSIGNED_INT_MAX = "4294967295";
    private static final String UNSIGNED_SHORT_MAX = "65535";
    private static final String UNSIGNED_BYTE_MAX = "255";
    private static final String LANGUAGE_PATTERN = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
    static /* synthetic */ Class class$com$thaiopensource$datatype$xsd$regex$RegexEngine;

    public DatatypeLibraryImpl() {
        this.typeTable.put("string", new StringDatatype());
        this.typeTable.put("normalizedString", new CdataDatatype());
        this.typeTable.put("token", new TokenDatatype());
        this.typeTable.put("boolean", new BooleanDatatype());
        DecimalDatatype decimalDatatype = new DecimalDatatype();
        this.typeTable.put("decimal", decimalDatatype);
        IntegerRestrictDatatype integerRestrictDatatype = new IntegerRestrictDatatype(decimalDatatype);
        this.typeTable.put("integer", integerRestrictDatatype);
        this.typeTable.put("nonPositiveInteger", this.restrictMax(integerRestrictDatatype, "0"));
        this.typeTable.put("negativeInteger", this.restrictMax(integerRestrictDatatype, "-1"));
        this.typeTable.put("long", this.restrictMax(this.restrictMin(integerRestrictDatatype, LONG_MIN), LONG_MAX));
        this.typeTable.put("int", this.restrictMax(this.restrictMin(integerRestrictDatatype, INT_MIN), INT_MAX));
        this.typeTable.put("short", this.restrictMax(this.restrictMin(integerRestrictDatatype, SHORT_MIN), SHORT_MAX));
        this.typeTable.put("byte", this.restrictMax(this.restrictMin(integerRestrictDatatype, BYTE_MIN), BYTE_MAX));
        DatatypeBase datatypeBase = this.restrictMin(integerRestrictDatatype, "0");
        this.typeTable.put("nonNegativeInteger", datatypeBase);
        this.typeTable.put("unsignedLong", this.restrictMax(datatypeBase, UNSIGNED_LONG_MAX));
        this.typeTable.put("unsignedInt", this.restrictMax(datatypeBase, UNSIGNED_INT_MAX));
        this.typeTable.put("unsignedShort", this.restrictMax(datatypeBase, UNSIGNED_SHORT_MAX));
        this.typeTable.put("unsignedByte", this.restrictMax(datatypeBase, UNSIGNED_BYTE_MAX));
        this.typeTable.put("positiveInteger", this.restrictMin(integerRestrictDatatype, "1"));
        this.typeTable.put("double", new DoubleDatatype());
        this.typeTable.put("float", new FloatDatatype());
        this.typeTable.put("Name", new NameDatatype());
        this.typeTable.put("QName", new QNameDatatype());
        NCNameDatatype nCNameDatatype = new NCNameDatatype();
        this.typeTable.put("NCName", nCNameDatatype);
        NmtokenDatatype nmtokenDatatype = new NmtokenDatatype();
        this.typeTable.put("NMTOKEN", nmtokenDatatype);
        this.typeTable.put("NMTOKENS", this.list(nmtokenDatatype));
        this.typeTable.put("ID", new IdDatatype());
        IdrefDatatype idrefDatatype = new IdrefDatatype();
        this.typeTable.put("IDREF", idrefDatatype);
        this.typeTable.put("IDREFS", this.list(idrefDatatype));
        this.typeTable.put("NOTATION", new QNameDatatype());
        this.typeTable.put("base64Binary", new Base64BinaryDatatype());
        this.typeTable.put("hexBinary", new HexBinaryDatatype());
        this.typeTable.put("anyURI", new AnyUriDatatype());
        this.typeTable.put("language", new RegexDatatype(LANGUAGE_PATTERN));
        this.typeTable.put("dateTime", new DateTimeDatatype("Y-M-DTt"));
        this.typeTable.put("time", new DateTimeDatatype("t"));
        this.typeTable.put("date", new DateTimeDatatype("Y-M-D"));
        this.typeTable.put("gYearMonth", new DateTimeDatatype("Y-M"));
        this.typeTable.put("gYear", new DateTimeDatatype("Y"));
        this.typeTable.put("gMonthDay", new DateTimeDatatype("--M-D"));
        this.typeTable.put("gDay", new DateTimeDatatype("---D"));
        this.typeTable.put("gMonth", new DateTimeDatatype("--M"));
        EntityDatatype entityDatatype = new EntityDatatype();
        this.typeTable.put("ENTITY", entityDatatype);
        this.typeTable.put("ENTITIES", this.list(entityDatatype));
        this.typeTable.put("duration", new DurationDatatype());
    }

    public DatatypeBuilder createDatatypeBuilder(String string) throws DatatypeException {
        DatatypeBase datatypeBase = (DatatypeBase)this.typeTable.get(string);
        if (datatypeBase == null) {
            throw new DatatypeException();
        }
        if (datatypeBase instanceof RegexDatatype) {
            try {
                ((RegexDatatype)datatypeBase).compile(this.getRegexEngine());
            }
            catch (RegexSyntaxException regexSyntaxException) {
                throw new DatatypeException(DatatypeBuilderImpl.localizer.message("regex_internal_error", string));
            }
        }
        return new DatatypeBuilderImpl(this, datatypeBase);
    }

    RegexEngine getRegexEngine() throws DatatypeException {
        if (this.regexEngine == null) {
            throw new DatatypeException(DatatypeBuilderImpl.localizer.message("regex_impl_not_found"));
        }
        return this.regexEngine;
    }

    private DatatypeBase restrictMax(DatatypeBase datatypeBase, String string) {
        return new MaxInclusiveRestrictDatatype(datatypeBase, datatypeBase.getValue(string, null));
    }

    private DatatypeBase restrictMin(DatatypeBase datatypeBase, String string) {
        return new MinInclusiveRestrictDatatype(datatypeBase, datatypeBase.getValue(string, null));
    }

    private DatatypeBase list(DatatypeBase datatypeBase) {
        return new MinLengthRestrictDatatype(new ListDatatype(datatypeBase), 1);
    }

    private RegexEngine findRegexEngine() {
        Enumeration enumeration = new Service(class$com$thaiopensource$datatype$xsd$regex$RegexEngine == null ? (class$com$thaiopensource$datatype$xsd$regex$RegexEngine = DatatypeLibraryImpl.class$("com.thaiopensource.datatype.xsd.regex.RegexEngine")) : class$com$thaiopensource$datatype$xsd$regex$RegexEngine).getProviders();
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        return (RegexEngine)enumeration.nextElement();
    }

    public Datatype createDatatype(String string) throws DatatypeException {
        return this.createDatatypeBuilder(string).createDatatype();
    }

    public static void main(String[] stringArray) throws DatatypeException {
        System.err.println(new DatatypeLibraryImpl().createDatatype(stringArray[0]).isValid(stringArray[1], null) ? "valid" : "invalid");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

