/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentField;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlInclude;
import org.openorb.compiler.object.IdlModule;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlRoot;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.parser.CompilationContext;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.parser.IdlGrammar;
import org.openorb.compiler.parser.Symbole;
import org.openorb.compiler.parser.SymboleDef;
import org.openorb.compiler.parser.SymboleJava;

public class IdlParser {
    public IdlObject root = new IdlRoot();
    public static IdlObject container = null;
    public static PrintStream error_output = System.out;
    public String[] file_extension = new String[]{".idl"};
    public static int totalError = 0;
    public CompilationContext ctx;
    public Vector StopList = new Vector();
    public static int include_level = 0;
    public static IdlComment idl_comment = null;
    public Vector compilationList = new Vector();
    public Vector idlIncluded = new Vector();
    public int pass = 0;
    public int stop_else = 0;
    public boolean macros_enabled = true;
    private static final int MAX_MACRO = 512;
    private static final int MAX_ERRORS = 10;

    public IdlParser() {
        IdlModule idlModule2 = new IdlModule(this.root);
        idlModule2.name("CORBA");
        idlModule2._prefix = "omg.org";
        this.root.addIdlObject(idlModule2);
        idlModule2.addIdlObject(IdlSimple.typecode_type);
        IdlSimple.typecode_type.name("TypeCode");
        IdlSimple.typecode_type._upper = idlModule2;
        idlModule2._map = true;
        IdlSimple.typecode_type._map = true;
    }

    public void show_error(String string) {
        ++this.ctx.nberrors;
        ++totalError;
        error_output.println(this.ctx.name + ":" + this.ctx.line + ": " + string);
        if (this.ctx.nberrors > 10) {
            error_output.println("Compilation stopped : too many errors");
            throw new CompilationException();
        }
    }

    public void show_internal_error() {
        error_output.println(this.ctx.name + ":" + this.ctx.line + ": Unexpected error");
        throw new CompilationException();
    }

    public static void show_fatal_error(String string) {
        error_output.println("Fatal error : " + string);
        throw new CompilationException();
    }

    public void warning(String string) {
        error_output.println(this.ctx.name + ":" + this.ctx.line + ": warning: " + string);
    }

    public boolean is_reserved_word() {
        int n = 0;
        while (n < Symbole.liste_mots_reserves.size()) {
            SymboleDef symboleDef = (SymboleDef)Symbole.liste_mots_reserves.elementAt(n);
            if (symboleDef.symbole_name.equals(this.ctx.value)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean is_java_reserved_word() {
        int n = 0;
        while (n < SymboleJava.liste_mots_reserves.size()) {
            SymboleDef symboleDef = (SymboleDef)SymboleJava.liste_mots_reserves.elementAt(n);
            if (symboleDef.symbole_name.equals(this.ctx.value)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void to_reserved_word() {
        int n = 0;
        while (n < Symbole.liste_mots_reserves.size()) {
            SymboleDef symboleDef = (SymboleDef)Symbole.liste_mots_reserves.elementAt(n);
            if (symboleDef.symbole_name.equals(this.ctx.value)) {
                this.ctx.symb = symboleDef.symbole_token;
                return;
            }
            ++n;
        }
    }

    public CompilationContext new_compilation_context() {
        CompilationContext compilationContext = new CompilationContext();
        compilationContext.nberrors = 0;
        compilationContext.nbwarning = 0;
        compilationContext.line = 1;
        compilationContext.symb = 59;
        return compilationContext;
    }

    public void open_idl_file(String string) {
        Reader reader;
        URL uRL;
        block24: {
            if (IdlCompiler.verbose) {
                System.out.println("Trying to open idl file '" + string + "'...");
            }
            boolean bl = false;
            int n = 0;
            while (n < this.file_extension.length) {
                if (string.endsWith(this.file_extension[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                string = string + this.file_extension[0];
            }
            try {
                URL uRL2;
                File file = new File(string);
                if (file.isAbsolute() && file.exists()) {
                    uRL = file.toURL();
                    reader = this.openURL(uRL);
                    break block24;
                }
                if (include_level == 0) {
                    try {
                        uRL2 = new File("").getCanonicalFile().toURL();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        System.exit(0);
                        return;
                    }
                } else {
                    uRL2 = this.ctx.sourceURL;
                }
                uRL = new URL(uRL2, string);
                reader = this.openURL(uRL);
                URL uRL3 = null;
                int n2 = 0;
                while (reader == null && n2 < IdlCompiler.includeList.size()) {
                    block26: {
                        Object e = IdlCompiler.includeList.elementAt(n2);
                        if (e != null) {
                            block25: {
                                if (e instanceof String) {
                                    try {
                                        uRL3 = new URL((String)e);
                                        break block25;
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        try {
                                            uRL3 = new File((String)e).toURL();
                                            break block25;
                                        }
                                        catch (MalformedURLException malformedURLException2) {
                                            IdlCompiler.includeList.removeElementAt(n2--);
                                            break block26;
                                        }
                                    }
                                }
                                uRL3 = (URL)e;
                            }
                            if (!uRL3.equals(uRL2)) {
                                try {
                                    uRL = new URL(uRL3, string);
                                    reader = this.openURL(uRL);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (reader == null && e instanceof String) {
                                reader = this.openResource((String)e + "/" + string);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Failed to open idl file: " + string + " (" + malformedURLException + ")");
                malformedURLException.printStackTrace();
                System.exit(0);
                return;
            }
        }
        if (reader == null) {
            System.out.println("Failed to open idl file: " + string);
            System.exit(0);
        }
        this.ctx = this.new_compilation_context();
        this.ctx.prefix = null;
        this.ctx.is = new PushbackReader(new BufferedReader(reader), 512);
        this.ctx.sourceURL = uRL;
        this.ctx.name = uRL.toString();
        IdlObject.idlPrefix = null;
        if (IdlCompiler.verbose) {
            System.out.println("Successfully opened idl file '" + string + "'.");
        }
    }

    private Reader openURL(URL uRL) {
        if (IdlCompiler.verbose) {
            System.out.println("Trying to open url '" + uRL + "'...");
        }
        try {
            HttpURLConnection httpURLConnection;
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            if (uRLConnection instanceof HttpURLConnection && (httpURLConnection = (HttpURLConnection)uRL.openConnection()).getResponseCode() != 200) {
                return null;
            }
            if (IdlCompiler.verbose) {
                System.out.println("Successfully opened url '" + uRL + "'.");
            }
            return new InputStreamReader(uRLConnection.getInputStream());
        }
        catch (IOException iOException) {
            if (IdlCompiler.verbose) {
                System.out.println("Failed to open url '" + uRL + "'.");
            }
            return null;
        }
    }

    private Reader openResource(String string) {
        ClassLoader classLoader;
        if (IdlCompiler.verbose) {
            System.out.println("Trying to open resource url '" + string + "'...");
        }
        if ((classLoader = this.getClass().getClassLoader()) instanceof URLClassLoader) {
            Object object;
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            if (IdlCompiler.verbose) {
                object = uRLClassLoader.getURLs();
                System.out.println("Searching in " + ((URL[])object).length + " URLs:");
                int n = 0;
                while (n < ((Object)object).length) {
                    System.out.println(" -> " + object[n]);
                    ++n;
                }
            }
            object = null;
            try {
                object = uRLClassLoader.findResource(string);
                if (object != null) {
                    URLConnection uRLConnection = ((URL)object).openConnection();
                    uRLConnection.connect();
                    if (IdlCompiler.verbose) {
                        System.out.println("Successfully opened resource url '" + string + "'.");
                    }
                    return new InputStreamReader(uRLConnection.getInputStream());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (IdlCompiler.verbose) {
            System.out.println("Failed to open resource url '" + string + "'.");
        }
        return null;
    }

    private boolean isAlsoToCompile(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.file_extension.length) {
            if (string.endsWith(this.file_extension[n])) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            string = string + this.file_extension[0];
        }
        int n2 = 0;
        while (n2 < IdlCompiler.idl_file_name.length) {
            if (string.equals(IdlCompiler.idl_file_name[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void include_idl() {
        String string;
        boolean bl = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = bl;
        switch (this.ctx.symb) {
            case 15: {
                string = "";
                this.scan();
                while (this.ctx.car != '>') {
                    string = string + this.ctx.car;
                    if (this.ctx.car == '\u00ff' || this.ctx.car == '\u00fe') {
                        this.show_error("IDL file name expected");
                        this.StopList.removeAllElements();
                        this.StopList.addElement(new Integer(39));
                        this.StopList.addElement(new Integer(37));
                        this.StopList.addElement(new Integer(52));
                        this.StopList.addElement(new Integer(54));
                        this.StopList.addElement(new Integer(49));
                        this.StopList.addElement(new Integer(31));
                        this.StopList.addElement(new Integer(32));
                        this.StopList.addElement(new Integer(27));
                        this.stopAt(this.StopList);
                        return;
                    }
                    this.scan();
                }
                break;
            }
            case 63: {
                string = this.ctx.value;
                break;
            }
            default: {
                this.show_error("IDL file name to include expected");
                this.StopList.removeAllElements();
                this.StopList.addElement(new Integer(39));
                this.StopList.addElement(new Integer(37));
                this.StopList.addElement(new Integer(52));
                this.StopList.addElement(new Integer(54));
                this.StopList.addElement(new Integer(49));
                this.StopList.addElement(new Integer(31));
                this.StopList.addElement(new Integer(32));
                this.StopList.addElement(new Integer(27));
                this.stopAt(this.StopList);
                return;
            }
        }
        this.ctx.prefix = IdlObject.idlPrefix;
        this.compilationList.addElement(this.ctx);
        boolean bl2 = false;
        if (!this.isAlsoToCompile(string) && !IdlCompiler.map_all) {
            bl2 = true;
            ++include_level;
        }
        if (IdlCompiler.verbose) {
            System.out.println("Include IDL: " + string);
        }
        this.compile_idl(string, container);
        this.root.addIdlObject(new IdlInclude(this.root, string));
        if (include_level == 1) {
            this.idlIncluded.addElement(this.ctx.name);
        }
        if (bl2) {
            --include_level;
        }
        int n = this.ctx.nberrors;
        this.ctx = (CompilationContext)this.compilationList.lastElement();
        this.compilationList.setSize(this.compilationList.size() - 1);
        this.ctx.nberrors += n;
        IdlObject.idlPrefix = this.ctx.prefix;
        this.symbole();
    }

    public void include_idl_file(String string) {
        this.ctx.prefix = IdlObject.idlPrefix;
        if (this.ctx.sourceURL == null) {
            try {
                this.ctx.sourceURL = new File("").getCanonicalFile().toURL();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
        }
        this.compilationList.addElement(this.ctx);
        if (!IdlCompiler.map_all) {
            ++include_level;
        }
        if (IdlCompiler.verbose) {
            System.out.println("Include IDL file: " + string);
        }
        this.compile_idl(string, container);
        this.root.addIdlObject(new IdlInclude(this.root, string));
        if (include_level == 1) {
            this.idlIncluded.addElement(this.ctx.name);
        }
        if (!IdlCompiler.map_all) {
            --include_level;
        }
        int n = this.ctx.nberrors;
        this.ctx = (CompilationContext)this.compilationList.lastElement();
        this.compilationList.setSize(this.compilationList.size() - 1);
        this.ctx.nberrors += n;
        IdlObject.idlPrefix = this.ctx.prefix;
    }

    public void precompiler_error() {
        this.scan();
        StringBuffer stringBuffer = new StringBuffer();
        while (this.ctx.car != '\u00ff') {
            if (this.ctx.car == '\\') {
                this.scan();
                if (this.ctx.car == '\u00ff') {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append('\\');
                continue;
            }
            stringBuffer.append(this.ctx.car);
            this.scan();
        }
        this.show_error("#error" + stringBuffer);
        this.symbole();
    }

    public void precompiler_warning() {
        StringBuffer stringBuffer = new StringBuffer();
        this.scan();
        while (this.ctx.car != '\u00ff') {
            if (this.ctx.car == '\\') {
                this.scan();
                if (this.ctx.car == '\u00ff') {
                    stringBuffer.append(' ');
                    continue;
                }
                stringBuffer.append('\\');
                continue;
            }
            stringBuffer.append(this.ctx.car);
            this.scan();
        }
        this.warning("#warning" + stringBuffer);
        this.symbole();
    }

    public void define_symbole() {
        boolean bl = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = bl;
        if (this.ctx.symb != 21) {
            this.show_error("Identifier expected after #define");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            if (IdlCompiler.definedMacros.containsKey(this.ctx.value)) {
                this.warning("'" + this.ctx.value + "' redefined");
            }
            this.scan();
            if (this.ctx.car == '(') {
                this.show_error("Tried to define function macro '" + this.ctx.value + "'. Function macros are not implemented.");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(' ');
            boolean bl2 = true;
            block5: while (this.ctx.car != '\u00ff') {
                switch (this.ctx.car) {
                    case '\t': 
                    case ' ': {
                        if (bl2) break;
                        bl2 = true;
                        stringBuffer.append(' ');
                        break;
                    }
                    case '\\': {
                        this.scan();
                        if (this.ctx.car == '\u00ff') {
                            if (bl2) break;
                            bl2 = true;
                            stringBuffer.append(' ');
                            break;
                        }
                        stringBuffer.append('\\');
                        bl2 = false;
                        continue block5;
                    }
                    case '#': {
                        this.scan();
                        if (this.ctx.car == '#') {
                            if (stringBuffer.charAt(stringBuffer.length() - 1) == ' ') {
                                stringBuffer.setLength(stringBuffer.length() - 1);
                            }
                            bl2 = true;
                            break;
                        }
                        stringBuffer.append('#');
                        bl2 = false;
                        continue block5;
                    }
                    default: {
                        stringBuffer.append(this.ctx.car);
                        bl2 = false;
                    }
                }
                this.scan();
            }
            stringBuffer.append(' ');
            if (stringBuffer.length() > 512) {
                this.show_error("macro length exceeds system limits");
            }
            IdlCompiler.definedMacros.put(this.ctx.value, stringBuffer.toString());
            this.symbole();
        }
    }

    public void undefine_symbole() {
        boolean bl = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = bl;
        if (this.ctx.symb != 21) {
            this.show_error("Identifier expected after #undef");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            if (IdlCompiler.definedMacros.remove(this.ctx.value) != null) {
                this.warning("'" + this.ctx.value + "' was not defined.");
            }
            this.symbole();
        }
    }

    public void ifndef_symbole() {
        boolean bl = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = bl;
        if (this.ctx.symb != 21) {
            this.show_error("Identifier expected after #ifndef");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            if (IdlCompiler.definedMacros.containsKey(this.ctx.value)) {
                int n = 1;
                int n2 = 1;
                this.pass = 2;
                while (n != 0) {
                    this.symbole();
                    switch (this.ctx.symb) {
                        case 80: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    n = 2;
                                    --n2;
                                    break;
                                }
                                case 3: {
                                    n = 2;
                                }
                            }
                            if (n2 != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 79: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    n = 3;
                                    --n2;
                                }
                            }
                            if (n2 != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 78: 
                        case 96: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    n = 1;
                                    ++n2;
                                    break;
                                }
                                case 3: {
                                    n = 1;
                                    n2 += 2;
                                }
                            }
                            if (n2 != 0) break;
                            this.pass = 0;
                        }
                    }
                    if (n2 != 0) continue;
                    n = 0;
                }
            } else {
                this.pass = 0;
                if (this.stop_else == 0) {
                    this.stop_else = 1;
                }
            }
            this.symbole();
        }
    }

    public void ifdef_symbole() {
        boolean bl = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = bl;
        if (this.ctx.symb != 21) {
            this.show_error("Identifier expected after #ifdef");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            if (!IdlCompiler.definedMacros.containsKey(this.ctx.value)) {
                int n = 1;
                int n2 = 1;
                this.pass = 2;
                while (n != 0) {
                    this.symbole();
                    switch (this.ctx.symb) {
                        case 80: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    n = 2;
                                    --n2;
                                    break;
                                }
                                case 3: {
                                    n = 2;
                                }
                            }
                            if (n2 != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 79: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    n = 3;
                                    --n2;
                                }
                            }
                            if (n2 != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 78: 
                        case 96: {
                            switch (n) {
                                case 1: 
                                case 2: {
                                    n = 1;
                                    ++n2;
                                    break;
                                }
                                case 3: {
                                    n = 1;
                                    n2 += 2;
                                }
                            }
                            if (n2 != 0) break;
                            this.pass = 0;
                        }
                    }
                    if (n2 != 0) continue;
                    n = 0;
                }
            } else {
                this.pass = 0;
                if (this.stop_else == 0) {
                    this.stop_else = 1;
                }
            }
            this.symbole();
        }
    }

    public boolean read_description() {
        boolean bl = false;
        boolean bl2 = false;
        Vector<Character> vector = new Vector<Character>();
        while (!bl) {
            this.scan();
            block0 : switch (this.ctx.car) {
                case '@': {
                    bl = true;
                    break;
                }
                case '*': {
                    this.scan();
                    if (this.ctx.car == '/') {
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    while (true) {
                        if (this.ctx.car != ' ') {
                            this.unscan();
                            break block0;
                        }
                        this.scan();
                    }
                }
                default: {
                    if (this.ctx.car == '\u00ff') {
                        do {
                            this.scan();
                            if (this.ctx.car != '\u00fe') continue;
                            this.show_error("IDL comment incorrect.");
                            System.exit(0);
                        } while (this.ctx.car != '*');
                        this.unscan();
                        vector.addElement(new Character('\n'));
                        break;
                    }
                    vector.addElement(new Character(this.ctx.car));
                }
            }
        }
        if (vector.size() != 0) {
            char[] cArray = new char[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                cArray[n] = ((Character)vector.elementAt(n)).charValue();
                ++n;
            }
            this.ctx.value = new String(cArray);
        }
        return bl2;
    }

    public void scan_comment() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<Character> vector = new Vector<Character>();
        IdlCommentSection idlCommentSection = null;
        idl_comment = new IdlComment();
        do {
            this.scan();
        } while (this.ctx.car != '*');
        this.unscan();
        block5: while (!bl) {
            switch (this.ctx.car) {
                case '*': {
                    this.scan();
                    if (this.ctx.car == '/') {
                        bl = true;
                    }
                    while (this.ctx.car == ' ') {
                        this.scan();
                    }
                    continue block5;
                }
                case '@': {
                    this.scan();
                    if (this.macros_enabled) {
                        this.macros_enabled = false;
                        this.read_word();
                        this.macros_enabled = true;
                    } else {
                        this.read_word();
                    }
                    bl3 = true;
                    if (this.ctx.value.equals("exception")) {
                        idlCommentSection = new IdlCommentSection(IdlCommentField.exception_field);
                    } else if (this.ctx.value.equals("author")) {
                        idlCommentSection = new IdlCommentSection(IdlCommentField.author_field);
                    } else if (this.ctx.value.equals("version")) {
                        idlCommentSection = new IdlCommentSection(IdlCommentField.version_field);
                    } else if (this.ctx.value.equals("param")) {
                        idlCommentSection = new IdlCommentSection(IdlCommentField.param_field);
                    } else if (this.ctx.value.equals("return")) {
                        idlCommentSection = new IdlCommentSection(IdlCommentField.return_field);
                    } else if (this.ctx.value.equals("deprecated")) {
                        idlCommentSection = new IdlCommentSection(IdlCommentField.deprecated_field);
                    } else if (this.ctx.value.equals("see")) {
                        idlCommentSection = new IdlCommentSection(IdlCommentField.see_field);
                    } else {
                        idlCommentSection = new IdlCommentSection(IdlCommentField.unknown_field);
                        idlCommentSection.set_title(this.ctx.value);
                    }
                    bl2 = this.read_description();
                    idlCommentSection.add_description(this.ctx.value);
                    idl_comment.add_section(idlCommentSection);
                    if (!bl2) continue block5;
                    bl = true;
                    break;
                }
                default: {
                    if (this.ctx.car == '\u00ff') {
                        do {
                            this.scan();
                        } while (this.ctx.car != '*');
                        this.unscan();
                        if (!bl3) {
                            vector.addElement(new Character('\n'));
                        }
                    } else if (!bl3) {
                        vector.addElement(new Character(this.ctx.car));
                    }
                    this.scan();
                }
            }
        }
        if (vector.size() != 0) {
            char[] cArray = new char[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                cArray[n] = ((Character)vector.elementAt(n)).charValue();
                ++n;
            }
            idl_comment.add_description(new String(cArray));
        } else {
            idl_comment = null;
        }
    }

    public void scan() {
        try {
            int n = this.ctx.is.read();
            if (n < 0) {
                this.ctx.car = (char)254;
            } else if (n == 13) {
                this.scan();
            } else if (n == 10) {
                ++this.ctx.line;
                this.ctx.car = (char)255;
            } else {
                this.ctx.car = (char)n;
            }
        }
        catch (IOException iOException) {
            this.show_error("IOException occoured");
        }
    }

    public void unscan() {
        if (this.ctx.car == '\u00ff') {
            this.ctx.car = (char)10;
            --this.ctx.line;
        }
        try {
            this.ctx.is.unread(this.ctx.car);
        }
        catch (IOException iOException) {
            this.show_error("IOException occoured");
        }
    }

    public void pre_parse() {
        boolean bl = true;
        int n = 1;
        this.scan();
        this.ctx.symb = 59;
        block0 : switch (this.ctx.car) {
            case '\u00fe': {
                this.ctx.symb = 254;
                this.scan();
                break;
            }
            case '\t': 
            case ' ': 
            case '\u00ff': {
                this.pre_parse();
                break;
            }
            case '#': {
                this.scan();
                while (this.ctx.car == ' ' || this.ctx.car == '\t') {
                    this.scan();
                }
                if (this.macros_enabled) {
                    this.macros_enabled = false;
                    this.read_word();
                    this.macros_enabled = true;
                } else {
                    this.read_word();
                }
                if (this.ctx.value.toUpperCase().equals("ERROR")) {
                    if (this.pass != 0) break;
                    this.precompiler_error();
                    break;
                }
                if (this.ctx.value.toUpperCase().equals("WARNING")) {
                    if (this.pass != 0) break;
                    this.precompiler_warning();
                    break;
                }
                this.to_reserved_word();
                switch (this.ctx.symb) {
                    case 77: {
                        if (this.pass != 0) break block0;
                        this.define_symbole();
                        break block0;
                    }
                    case 96: {
                        if (this.pass != 0) break block0;
                        this.ifdef_symbole();
                        break block0;
                    }
                    case 81: {
                        if (this.pass != 0) break block0;
                        this.undefine_symbole();
                        break block0;
                    }
                    case 78: {
                        if (this.pass != 0) break block0;
                        this.ifndef_symbole();
                        break block0;
                    }
                    case 68: {
                        break block0;
                    }
                    case 69: {
                        if (this.pass != 0) break block0;
                        this.include_idl();
                        break block0;
                    }
                    case 79: {
                        if (this.stop_else == 1 && this.pass == 0) {
                            int n2 = 1;
                            int n3 = 1;
                            this.stop_else = -1;
                            this.pass = 2;
                            while (n2 != 0) {
                                this.symbole();
                                switch (this.ctx.symb) {
                                    case 78: {
                                        switch (n2) {
                                            case 1: 
                                            case 2: 
                                            case 3: {
                                                n2 = 3;
                                                ++n3;
                                            }
                                        }
                                        break;
                                    }
                                    case 80: {
                                        switch (n2) {
                                            case 1: 
                                            case 2: 
                                            case 3: {
                                                n2 = 2;
                                                --n3;
                                            }
                                        }
                                        break;
                                    }
                                    case 79: {
                                        switch (n2) {
                                            case 2: 
                                            case 3: {
                                                n2 = 1;
                                            }
                                        }
                                    }
                                }
                                if (n3 != 0) continue;
                                n2 = 0;
                            }
                            this.stop_else = 0;
                            this.pass = 0;
                        }
                        if (this.pass != 0) break block0;
                        this.symbole();
                        this.pass = 0;
                        break block0;
                    }
                    case 80: {
                        if (this.pass != 0) break block0;
                        this.symbole();
                        this.pass = 0;
                        break block0;
                    }
                }
                this.warning("Compilation flag unknown : " + this.ctx.value);
                break;
            }
            case '/': {
                this.scan();
                if (this.ctx.car == '/') {
                    while (this.ctx.car != '\u00ff' && this.ctx.car != '\u00fe') {
                        this.scan();
                    }
                    this.pre_parse();
                    break;
                }
                if (this.ctx.car == '*') {
                    boolean bl2 = true;
                    while (bl2) {
                        this.scan();
                        if (this.ctx.car == '\u00fe') {
                            this.show_error("Comment end missing '*/'");
                            this.StopList.removeAllElements();
                            this.StopList.addElement(new Integer(255));
                            this.stopAt(this.StopList);
                        }
                        if (this.ctx.car == '*') {
                            ++n;
                            this.scan();
                            if (this.ctx.car == '/') {
                                bl2 = false;
                            } else {
                                this.unscan();
                            }
                        }
                        if (n != 2 || this.ctx.car != '\u00ff') continue;
                        this.unscan();
                        this.scan_comment();
                        break;
                    }
                    this.pre_parse();
                    break;
                }
                this.ctx.symb = 3;
            }
        }
    }

    public void read_word() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while (Character.isLetterOrDigit(this.ctx.car) || this.ctx.car == '_') {
            stringBuffer.append(this.ctx.car);
            this.scan();
            if (this.ctx.car == '\u00fe' || this.ctx.car == '\u00ff') break;
        }
        this.ctx.value = stringBuffer.toString();
        this.unscan();
        if (this.macros_enabled && (string = (String)IdlCompiler.definedMacros.get(this.ctx.value)) != null) {
            try {
                this.ctx.is.unread(string.toCharArray());
            }
            catch (IOException iOException) {
                this.show_error("IOException while expanding macro");
            }
            this.ctx.value = null;
        }
    }

    public void read_number() {
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 0;
        char[] cArray = new char[255];
        while (bl2) {
            cArray[n2++] = this.ctx.car;
            this.scan();
            if (this.ctx.car == '.') {
                if (!bl) {
                    bl = true;
                    continue;
                }
                this.show_error("Bad number value");
                continue;
            }
            if (this.ctx.car == 'x' || this.ctx.car == 'X') {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.show_error("Bad number value");
                continue;
            }
            if (this.ctx.car == '-') {
                this.show_error("Token '-' misplaced");
                bl2 = false;
                continue;
            }
            if (Character.isLetter(this.ctx.car)) {
                if (this.ctx.car == ' ' || this.ctx.car == '\u00ff' || this.ctx.car == '\u00fe') {
                    bl2 = false;
                    this.unscan();
                    continue;
                }
                if (n == 1) continue;
                if (this.ctx.car == 'D' || this.ctx.car == 'd') {
                    bl2 = false;
                    continue;
                }
                System.out.println("[" + this.ctx.car + "]");
                this.unscan();
                this.show_error("Bad hexadecimal value");
                bl2 = false;
                continue;
            }
            if (Character.isDigit(this.ctx.car)) continue;
            this.unscan();
            bl2 = false;
        }
        cArray[n2] = '\u0000';
        this.ctx.symb = !bl ? 61 : 62;
        this.ctx.value = new String(cArray, 0, n2);
        this.ctx.base = n;
    }

    public void parse() {
        this.pre_parse();
        if (this.ctx.symb == 59) {
            switch (this.ctx.car) {
                case '&': {
                    this.ctx.symb = 19;
                    break;
                }
                case '|': {
                    this.ctx.symb = 85;
                    break;
                }
                case '+': {
                    this.ctx.symb = 0;
                    break;
                }
                case '-': {
                    this.ctx.symb = 1;
                    break;
                }
                case '=': {
                    this.ctx.symb = 10;
                    break;
                }
                case '*': {
                    this.ctx.symb = 2;
                    break;
                }
                case '{': {
                    this.ctx.symb = 4;
                    break;
                }
                case '}': {
                    this.ctx.symb = 5;
                    break;
                }
                case '[': {
                    this.ctx.symb = 6;
                    break;
                }
                case ']': {
                    this.ctx.symb = 7;
                    break;
                }
                case '.': {
                    this.ctx.symb = 12;
                    break;
                }
                case '~': {
                    this.ctx.symb = 58;
                    break;
                }
                case '<': {
                    this.ctx.symb = 15;
                    break;
                }
                case '>': {
                    this.ctx.symb = 16;
                    break;
                }
                case '%': {
                    this.ctx.symb = 60;
                    break;
                }
                case '(': {
                    this.ctx.symb = 8;
                    break;
                }
                case ')': {
                    this.ctx.symb = 9;
                    break;
                }
                case ';': {
                    this.ctx.symb = 13;
                    break;
                }
                case ',': {
                    this.ctx.symb = 11;
                    break;
                }
                case ':': {
                    this.scan();
                    if (this.ctx.car == ':') {
                        this.ctx.symb = 56;
                        break;
                    }
                    this.ctx.symb = 14;
                    this.unscan();
                    break;
                }
                case '\"': 
                case '\'': {
                    char c = this.ctx.car;
                    StringBuffer stringBuffer = new StringBuffer();
                    this.scan();
                    while (this.ctx.car != c) {
                        if (this.ctx.car == '\u00fe') {
                            this.show_error("End of file reached while scanning string");
                            break;
                        }
                        if (this.ctx.car == '\\') {
                            this.scan();
                            if (this.ctx.car == '\u00ff') continue;
                            stringBuffer.append('\\');
                        }
                        stringBuffer.append(this.ctx.car);
                        this.scan();
                    }
                    this.ctx.value = stringBuffer.toString();
                    if (c == '\"') {
                        this.ctx.symb = 63;
                        break;
                    }
                    this.ctx.symb = 64;
                    break;
                }
                default: {
                    if (Character.isDigit(this.ctx.car)) {
                        this.read_number();
                        break;
                    }
                    if (Character.isLetter(this.ctx.car) || this.ctx.car == '_') {
                        this.read_word();
                        if (this.ctx.value == null) {
                            this.parse();
                            break;
                        }
                        if (this.is_reserved_word()) {
                            this.to_reserved_word();
                            break;
                        }
                        this.ctx.symb = 21;
                        if (!this.is_java_reserved_word()) break;
                        this.ctx.value = "__" + this.ctx.value;
                        break;
                    }
                    char c = this.ctx.car;
                    this.show_error("Undefined character : " + this.ctx.car);
                }
            }
        }
    }

    public void symbole() {
        if (this.ctx.one != 59) {
            this.ctx.symb = this.ctx.one;
            this.ctx.one = 59;
            return;
        }
        this.parse();
        block0 : switch (this.ctx.symb) {
            case 1: {
                this.parse();
                if (this.ctx.symb == 61 || this.ctx.symb == 62) {
                    this.ctx.value = "-" + this.ctx.value;
                    break;
                }
                this.ctx.one = this.ctx.symb;
                this.ctx.symb = 1;
                break;
            }
            case 38: {
                this.parse();
                switch (this.ctx.symb) {
                    case 38: {
                        this.ctx.symb = 73;
                        break block0;
                    }
                    case 30: {
                        this.ctx.symb = 75;
                        break block0;
                    }
                }
                this.ctx.one = this.ctx.symb;
                this.ctx.symb = 38;
                break;
            }
            case 53: {
                this.parse();
                switch (this.ctx.symb) {
                    case 38: {
                        this.parse();
                        if (this.ctx.symb == 38) {
                            this.ctx.symb = 74;
                            break block0;
                        }
                        this.ctx.one = this.ctx.symb;
                        this.ctx.symb = 65;
                        break block0;
                    }
                    case 47: {
                        this.ctx.symb = 66;
                        break block0;
                    }
                }
                this.show_error("Unexpected combinaison type with unsigned");
            }
        }
    }

    public void stopAt(Vector vector) {
        while (this.ctx.symb != 254) {
            int n = 0;
            while (n < vector.size()) {
                Integer n2 = (Integer)vector.elementAt(n);
                if (n2 == this.ctx.symb) {
                    return;
                }
                ++n;
            }
            this.symbole();
        }
    }

    public IdlObject compile_idl(String string, IdlObject idlObject2) {
        IdlGrammar idlGrammar = new IdlGrammar(this);
        this.open_idl_file(string);
        idlGrammar.idl_specification(idlObject2);
        return idlObject2;
    }

    public IdlObject compile_idl(String string) {
        IdlGrammar idlGrammar = new IdlGrammar(this);
        container = this.root;
        this.open_idl_file(string);
        idlGrammar.idl_specification(this.root);
        return this.root;
    }
}

