/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.ir;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.AliasDefHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.ArrayDef;
import org.omg.CORBA.ArrayDefHelper;
import org.omg.CORBA.AttributeDef;
import org.omg.CORBA.AttributeDefHelper;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.ConstantDefHelper;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.Container;
import org.omg.CORBA.ContainerHelper;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.EnumDefHelper;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.ExceptionDefHelper;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.IDLTypeHelper;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.ModuleDefHelper;
import org.omg.CORBA.NativeDef;
import org.omg.CORBA.NativeDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.OperationDefHelper;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.PrimitiveDef;
import org.omg.CORBA.PrimitiveDefHelper;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.SequenceDef;
import org.omg.CORBA.SequenceDefHelper;
import org.omg.CORBA.StringDef;
import org.omg.CORBA.StringDefHelper;
import org.omg.CORBA.StructDef;
import org.omg.CORBA.StructDefHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionDefHelper;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueBoxDef;
import org.omg.CORBA.ValueBoxDefHelper;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.ValueDefHelper;
import org.omg.CORBA.ValueMemberDef;
import org.omg.CORBA.ValueMemberDefHelper;
import org.omg.CORBA.WstringDef;
import org.omg.CORBA.WstringDefHelper;
import org.openorb.CORBA.typecode.TypeCodeBase;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.object.IdlArray;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlContext;
import org.openorb.compiler.object.IdlEnum;
import org.openorb.compiler.object.IdlEnumMember;
import org.openorb.compiler.object.IdlExcept;
import org.openorb.compiler.object.IdlFactory;
import org.openorb.compiler.object.IdlFactoryMember;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlModule;
import org.openorb.compiler.object.IdlNative;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlSequence;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlString;
import org.openorb.compiler.object.IdlStruct;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlTypeDef;
import org.openorb.compiler.object.IdlUnion;
import org.openorb.compiler.object.IdlUnionMember;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;
import org.openorb.compiler.object.IdlWString;
import org.openorb.compiler.parser.IRImport;
import org.openorb.compiler.parser.IdlParser;

public class IdlFromIR
implements IRImport {
    private static Hashtable _imported = new Hashtable();
    private boolean _initialized = false;
    private Repository _ir = null;
    private IdlParser _parser;
    private ORB _orb;

    public IdlFromIR() {
        this._orb = ORB.init((String[])new String[0], null);
    }

    public IdlFromIR(ORB oRB) {
        this._orb = oRB;
    }

    public void set_parser(IdlParser idlParser2) {
        this._parser = idlParser2;
    }

    public void initialize() {
        this.init();
    }

    public void getDescriptionFromIR(String string, IdlObject idlObject2) {
        Contained contained;
        String string2;
        if (this.isAlreadyImported(string)) {
            return;
        }
        if (this.checkFromImportFromFile(string)) {
            return;
        }
        Container container = null;
        this.init();
        if (string.startsWith("::")) {
            container = ContainerHelper.narrow((Object)this._ir);
        } else {
            string2 = idlObject2.getId();
            if (string2.equals("IDL:")) {
                container = ContainerHelper.narrow((Object)this._ir);
            } else {
                contained = this._ir.lookup_id(string2);
                if (contained == null) {
                    this._parser.show_error("Unable to find the IR description for container : " + idlObject2.name());
                    return;
                }
                try {
                    container = ContainerHelper.narrow((Object)contained);
                }
                catch (BAD_PARAM bAD_PARAM) {
                    this._parser.show_error("Bad current scope : " + idlObject2.name());
                    return;
                }
            }
        }
        string2 = container.lookup(string);
        if (string2 == null) {
            this._parser.show_error("Unable to find into IR : " + string);
            return;
        }
        contained = null;
        try {
            contained = ContainerHelper.narrow((Object)string2);
        }
        catch (BAD_PARAM bAD_PARAM) {
            this._parser.show_error("Bad imported scope : " + idlObject2.name());
            return;
        }
        IdlObject idlObject3 = this.createOrFindScope(string, idlObject2, container);
        this.irContainer((Container)contained, idlObject3, true);
        this.addAsImported(string);
    }

    private void init() {
        if (!this._initialized) {
            try {
                if (this._orb == null) {
                    return;
                }
                Object object = this._orb.resolve_initial_references("InterfaceRepository");
                this._ir = RepositoryHelper.narrow((Object)object);
            }
            catch (InvalidName invalidName) {
                IdlParser.show_fatal_error("Unable to get access to the 'Interface Repository'");
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                System.out.println("COMM_FAILURE exception");
                return;
            }
            if (this._ir == null) {
                IdlParser.show_fatal_error("Unable to get access to the 'Interface Repository'");
            }
        }
    }

    public IdlObject irDescription(IRObject iRObject, IdlObject idlObject2, boolean bl) {
        switch (iRObject.def_kind().value()) {
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 12: 
            case 21: 
            case 22: 
            case 23: {
                Contained contained = ContainedHelper.narrow((Object)iRObject);
                return this.irContained(contained, idlObject2, bl);
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 20: {
                Container container = ContainerHelper.narrow((Object)iRObject);
                return this.irContainer(container, idlObject2, bl);
            }
            case 13: {
                return this.irPrimitive(iRObject, idlObject2);
            }
            case 14: {
                return this.irString(iRObject, idlObject2);
            }
            case 15: {
                return this.irSequence(iRObject, idlObject2);
            }
            case 16: {
                return this.irArray(iRObject, idlObject2);
            }
            case 18: {
                return this.irWstring(iRObject, idlObject2);
            }
        }
        return null;
    }

    public IdlObject irContainer(Container container, IdlObject idlObject2, boolean bl) {
        switch (container.def_kind().value()) {
            case 6: {
                return this.irModule(container, idlObject2, bl);
            }
            case 10: {
                return this.irStruct(container, idlObject2, bl);
            }
            case 4: {
                return this.irException(container, idlObject2, bl);
            }
            case 11: {
                return this.irUnion(container, idlObject2, bl);
            }
            case 5: {
                return this.irInterface(container, idlObject2, bl, 0);
            }
            case 25: {
                return this.irInterface(container, idlObject2, bl, 1);
            }
            case 24: {
                return this.irInterface(container, idlObject2, bl, 2);
            }
            case 20: {
                return this.irValue(container, idlObject2, bl);
            }
        }
        return null;
    }

    public IdlObject irContained(Contained contained, IdlObject idlObject2, boolean bl) {
        switch (contained.def_kind().value()) {
            case 12: {
                return this.irEnum(contained, idlObject2, bl);
            }
            case 23: {
                return this.irNative(contained, idlObject2, bl);
            }
            case 9: {
                return this.irAlias(contained, idlObject2, bl);
            }
            case 21: {
                return this.irValueBox(contained, idlObject2, bl);
            }
            case 3: {
                return this.irConstant(contained, idlObject2, bl);
            }
            case 2: {
                return this.irAttribute((IRObject)contained, idlObject2);
            }
            case 7: {
                return this.irOperation((IRObject)contained, idlObject2);
            }
            case 22: {
                return this.irValueMember((IRObject)contained, idlObject2);
            }
        }
        return null;
    }

    public IdlObject irModule(Container container, IdlObject idlObject2, boolean bl) {
        IdlModule idlModule2 = null;
        ModuleDef moduleDef = ModuleDefHelper.narrow((Object)container);
        IdlObject idlObject3 = idlObject2.returnObject(moduleDef.name(), true);
        if (idlObject3 == null) {
            idlModule2 = new IdlModule(idlObject2);
            idlObject2.addIdlObject(idlModule2);
            if (!IdlCompiler.map_all) {
                idlModule2._map = true;
            }
            idlModule2.name(moduleDef.name());
        } else {
            idlModule2 = (IdlModule)idlObject3;
            if (!bl) {
                return idlModule2;
            }
        }
        if (bl) {
            idlModule2._import = true;
            Contained[] containedArray = moduleDef.contents(DefinitionKind.dk_all, true);
            int n = 0;
            while (n < containedArray.length) {
                this.irDescription((IRObject)containedArray[n], idlModule2, bl);
                ++n;
            }
        } else {
            idlModule2._import = false;
        }
        return idlModule2;
    }

    public IdlObject irInterface(Container container, IdlObject idlObject2, boolean bl, int n) {
        InterfaceDef interfaceDef = InterfaceDefHelper.narrow((Object)container);
        IdlInterface idlInterface2 = null;
        IdlObject idlObject3 = idlObject2.returnObject(interfaceDef.name(), true);
        if (idlObject3 == null) {
            idlInterface2 = new IdlInterface(idlObject2);
            if (!IdlCompiler.map_all) {
                idlInterface2._map = true;
            }
        } else {
            idlInterface2 = (IdlInterface)idlObject3;
            if (idlInterface2._import) {
                return idlInterface2;
            }
        }
        idlInterface2.name(interfaceDef.name());
        switch (n) {
            case 1: {
                idlInterface2.local_interface(true);
                break;
            }
            case 2: {
                idlInterface2.abstract_interface(true);
            }
        }
        if (bl) {
            idlInterface2._import = true;
            InterfaceDef[] interfaceDefArray = interfaceDef.base_interfaces();
            int n2 = 0;
            while (n2 < interfaceDefArray.length) {
                idlInterface2.addInheritance(this.getDescription((IRObject)interfaceDefArray[n2]));
                ++n2;
            }
            Contained[] containedArray = interfaceDef.contents(DefinitionKind.dk_all, true);
            int n3 = 0;
            while (n3 < containedArray.length) {
                this.irDescription((IRObject)containedArray[n3], idlInterface2, bl);
                ++n3;
            }
        } else {
            idlInterface2._import = false;
        }
        idlObject2.addIdlObject(idlInterface2);
        if (!IdlCompiler.map_all) {
            idlInterface2._map = true;
        }
        return idlInterface2;
    }

    public IdlObject irValue(Container container, IdlObject idlObject2, boolean bl) {
        ValueDef valueDef = ValueDefHelper.narrow((Object)container);
        IdlValue idlValue2 = null;
        IdlValueInheritance idlValueInheritance = null;
        IdlObject idlObject3 = idlObject2.returnObject(valueDef.name(), true);
        if (idlObject3 == null) {
            idlValue2 = new IdlValue(idlObject2);
            if (!IdlCompiler.map_all) {
                idlValue2._map = true;
            }
        } else {
            idlValue2 = (IdlValue)idlObject3;
            if (idlValue2._import) {
                return idlValue2;
            }
        }
        idlValue2.name(valueDef.name());
        if (bl) {
            idlValue2._import = true;
            idlValue2.abstract_value(valueDef.is_abstract());
            idlValue2.custom_value(valueDef.is_custom());
            ValueDef valueDef2 = valueDef.base_value();
            if (valueDef2 != null) {
                idlValueInheritance = new IdlValueInheritance(idlValue2);
                idlValueInheritance.truncatable_member(valueDef.is_truncatable());
                idlValueInheritance.addIdlObject(this.getDescription((IRObject)valueDef2));
                idlValue2.addInheritance(idlValueInheritance);
            }
            ValueDef[] valueDefArray = valueDef.abstract_base_values();
            int n = 0;
            while (n < valueDefArray.length) {
                idlValueInheritance = new IdlValueInheritance(idlValue2);
                idlValueInheritance.addIdlObject(this.getDescription((IRObject)valueDefArray[n]));
                idlValue2.addInheritance(idlValueInheritance);
                ++n;
            }
            Vector<IdlObject> vector = new Vector<IdlObject>();
            InterfaceDef[] interfaceDefArray = valueDef.supported_interfaces();
            int n2 = 0;
            while (n2 < interfaceDefArray.length) {
                vector.addElement(this.getDescription((IRObject)interfaceDefArray[n2]));
                ++n2;
            }
            idlValue2.supports(vector);
            Initializer[] initializerArray = valueDef.initializers();
            this.irFactory(initializerArray, idlValue2);
            Contained[] containedArray = valueDef.contents(DefinitionKind.dk_all, true);
            int n3 = 0;
            while (n3 < containedArray.length) {
                this.irDescription((IRObject)containedArray[n3], idlValue2, bl);
                ++n3;
            }
        } else {
            idlValue2._import = false;
        }
        idlObject2.addIdlObject(idlValue2);
        if (!IdlCompiler.map_all) {
            idlValue2._map = true;
        }
        return idlValue2;
    }

    public IdlObject irStruct(Container container, IdlObject idlObject2, boolean bl) {
        IdlStructMember idlStructMember2 = null;
        StructDef structDef = StructDefHelper.narrow((Object)container);
        IdlStruct idlStruct2 = null;
        IdlObject idlObject3 = idlObject2.returnObject(structDef.name(), true);
        if (idlObject3 == null) {
            idlStruct2 = new IdlStruct(idlObject2);
            if (!IdlCompiler.map_all) {
                idlStruct2._map = true;
            }
        } else {
            idlStruct2 = (IdlStruct)idlObject3;
            if (idlStruct2._import) {
                return idlStruct2;
            }
        }
        idlStruct2.name(structDef.name());
        if (bl) {
            StructMember[] structMemberArray = structDef.members();
            int n = 0;
            while (n < structMemberArray.length) {
                idlStructMember2 = new IdlStructMember(idlStruct2);
                idlStructMember2.name(structMemberArray[n].name);
                idlStructMember2.type(this.getType((IRObject)structMemberArray[n].type_def, idlStruct2));
                idlStruct2.addIdlObject(idlStructMember2);
                ++n;
            }
        } else {
            idlStruct2._import = false;
        }
        idlObject2.addIdlObject(idlStruct2);
        if (!IdlCompiler.map_all) {
            idlStruct2._map = true;
        }
        return idlStruct2;
    }

    public IdlObject irUnion(Container container, IdlObject idlObject2, boolean bl) {
        IdlUnionMember idlUnionMember2 = null;
        UnionDef unionDef = UnionDefHelper.narrow((Object)container);
        IdlUnion idlUnion2 = null;
        IdlObject idlObject3 = idlObject2.returnObject(unionDef.name(), true);
        if (idlObject3 == null) {
            idlUnion2 = new IdlUnion(idlObject2);
            if (!IdlCompiler.map_all) {
                idlUnion2._map = true;
            }
        } else {
            idlUnion2 = (IdlUnion)idlObject3;
            if (idlUnion2._import) {
                return idlUnion2;
            }
        }
        idlUnion2.name(unionDef.name());
        if (bl) {
            UnionMember[] unionMemberArray = unionDef.members();
            idlUnionMember2 = new IdlUnionMember(idlUnion2);
            idlUnionMember2.name("__d");
            idlUnionMember2.addIdlObject(this.getType((IRObject)unionDef.discriminator_type_def(), idlUnion2));
            idlUnion2.addIdlObject(idlUnionMember2);
            int n = 0;
            while (n < unionMemberArray.length) {
                idlUnionMember2 = new IdlUnionMember(idlUnion2);
                idlUnionMember2.name(unionMemberArray[n].name);
                idlUnionMember2.type(this.getType((IRObject)unionMemberArray[n].type_def, idlUnion2));
                idlUnionMember2.setValue(this.getValue(unionMemberArray[n].label));
                idlUnionMember2.setExpression(this.getExpression(unionMemberArray[n].label, unionDef.discriminator_type()));
                idlUnion2.addIdlObject(idlUnionMember2);
                ++n;
            }
        } else {
            idlUnion2._import = false;
        }
        idlObject2.addIdlObject(idlUnion2);
        if (!IdlCompiler.map_all) {
            idlUnion2._map = true;
        }
        return idlUnion2;
    }

    public IdlObject irException(Container container, IdlObject idlObject2, boolean bl) {
        IdlStructMember idlStructMember2 = null;
        ExceptionDef exceptionDef = ExceptionDefHelper.narrow((Object)container);
        IdlExcept idlExcept = null;
        IdlObject idlObject3 = idlObject2.returnObject(exceptionDef.name(), true);
        if (idlObject3 == null) {
            idlExcept = new IdlExcept(idlObject2);
            if (!IdlCompiler.map_all) {
                idlExcept._map = true;
            }
        } else {
            idlExcept = (IdlExcept)idlObject3;
            if (idlExcept._import) {
                return idlExcept;
            }
        }
        idlExcept.name(exceptionDef.name());
        if (bl) {
            StructMember[] structMemberArray = exceptionDef.members();
            int n = 0;
            while (n < structMemberArray.length) {
                idlStructMember2 = new IdlStructMember(idlExcept);
                idlStructMember2.name(structMemberArray[n].name);
                idlStructMember2.type(this.getType((IRObject)structMemberArray[n].type_def, idlExcept));
                idlExcept.addIdlObject(idlStructMember2);
                ++n;
            }
        } else {
            idlExcept._import = false;
        }
        idlObject2.addIdlObject(idlExcept);
        if (!IdlCompiler.map_all) {
            idlExcept._map = true;
        }
        return idlExcept;
    }

    public IdlObject irEnum(Contained contained, IdlObject idlObject2, boolean bl) {
        EnumDef enumDef = EnumDefHelper.narrow((Object)contained);
        IdlEnum idlEnum2 = null;
        IdlObject idlObject3 = idlObject2.returnObject(enumDef.name(), true);
        if (idlObject3 == null) {
            idlEnum2 = new IdlEnum(idlObject2);
            if (!IdlCompiler.map_all) {
                idlEnum2._map = true;
            }
            idlEnum2._import = bl;
        } else {
            idlEnum2 = (IdlEnum)idlObject3;
            if (idlEnum2._import) {
                return idlEnum2;
            }
        }
        idlEnum2.name(enumDef.name());
        idlEnum2._import = true;
        IdlEnumMember idlEnumMember = null;
        String[] stringArray = enumDef.members();
        int n = 0;
        while (n < stringArray.length) {
            idlEnumMember = new IdlEnumMember(idlEnum2);
            idlEnumMember.name(stringArray[n]);
            idlEnumMember.setValue(n);
            idlEnum2.addIdlObject(idlEnumMember);
            ++n;
        }
        idlObject2.addIdlObject(idlEnum2);
        return idlEnum2;
    }

    public IdlObject irNative(Contained contained, IdlObject idlObject2, boolean bl) {
        NativeDef nativeDef = NativeDefHelper.narrow((Object)contained);
        IdlNative idlNative2 = null;
        IdlObject idlObject3 = idlObject2.returnObject(nativeDef.name(), true);
        if (idlObject3 == null) {
            idlNative2 = new IdlNative(idlObject2);
            if (!IdlCompiler.map_all) {
                idlNative2._map = true;
            }
            idlNative2._import = bl;
        } else {
            idlNative2 = (IdlNative)idlObject3;
            if (idlNative2._import) {
                return idlNative2;
            }
        }
        idlNative2.name(nativeDef.name());
        idlNative2._import = true;
        idlObject2.addIdlObject(idlNative2);
        return idlNative2;
    }

    public IdlObject irAlias(Contained contained, IdlObject idlObject2, boolean bl) {
        AliasDef aliasDef = AliasDefHelper.narrow((Object)contained);
        IdlTypeDef idlTypeDef2 = null;
        IdlObject idlObject3 = idlObject2.returnObject(aliasDef.name(), true);
        if (idlObject3 == null) {
            idlTypeDef2 = new IdlTypeDef(idlObject2);
            if (!IdlCompiler.map_all) {
                idlTypeDef2._map = true;
            }
            idlTypeDef2._import = bl;
        } else {
            idlTypeDef2 = (IdlTypeDef)idlObject3;
            if (idlTypeDef2._import) {
                return idlTypeDef2;
            }
        }
        idlTypeDef2.name(aliasDef.name());
        idlTypeDef2._import = true;
        idlTypeDef2.type(this.getType((IRObject)aliasDef.original_type_def(), idlTypeDef2));
        idlObject2.addIdlObject(idlTypeDef2);
        return idlTypeDef2;
    }

    public IdlObject irValueBox(Contained contained, IdlObject idlObject2, boolean bl) {
        ValueBoxDef valueBoxDef = ValueBoxDefHelper.narrow((Object)contained);
        IdlValueBox idlValueBox2 = null;
        IdlObject idlObject3 = idlObject2.returnObject(valueBoxDef.name(), true);
        if (idlObject3 == null) {
            idlValueBox2 = new IdlValueBox(idlObject2);
            if (!IdlCompiler.map_all) {
                idlValueBox2._map = true;
            }
            idlValueBox2._import = bl;
        } else {
            idlValueBox2 = (IdlValueBox)idlObject3;
            if (idlValueBox2._import) {
                return idlValueBox2;
            }
        }
        idlValueBox2.name(valueBoxDef.name());
        idlValueBox2._import = true;
        idlValueBox2.type(this.getType((IRObject)valueBoxDef.original_type_def(), idlValueBox2));
        idlObject2.addIdlObject(idlValueBox2);
        return idlValueBox2;
    }

    public IdlObject irConstant(Contained contained, IdlObject idlObject2, boolean bl) {
        ConstantDef constantDef = ConstantDefHelper.narrow((Object)contained);
        IdlConst idlConst2 = null;
        IdlObject idlObject3 = idlObject2.returnObject(constantDef.name(), true);
        if (idlObject3 == null) {
            idlConst2 = new IdlConst(idlObject2);
            if (!IdlCompiler.map_all) {
                idlConst2._map = true;
            }
            idlConst2._import = bl;
        } else {
            idlConst2 = (IdlConst)idlObject3;
            if (idlConst2._import) {
                return idlConst2;
            }
        }
        idlConst2.name(constantDef.name());
        idlConst2._import = true;
        idlConst2.type(this.getType((IRObject)constantDef.type_def(), idlConst2));
        idlConst2.expression(this.getConstExpression(constantDef.value(), constantDef.type()));
        this.setConstValue(constantDef.value(), idlConst2);
        idlObject2.addIdlObject(idlConst2);
        return idlConst2;
    }

    private IdlObject irPrimitive(IRObject iRObject, IdlObject idlObject2) {
        PrimitiveDef primitiveDef = PrimitiveDefHelper.narrow((Object)iRObject);
        switch (primitiveDef.kind().value()) {
            case 1: {
                return IdlSimple.void_type;
            }
            case 2: {
                return IdlSimple.short_type;
            }
            case 3: {
                return IdlSimple.long_type;
            }
            case 4: {
                return IdlSimple.ushort_type;
            }
            case 5: {
                return IdlSimple.ulong_type;
            }
            case 6: {
                return IdlSimple.float_type;
            }
            case 7: {
                return IdlSimple.double_type;
            }
            case 8: {
                return IdlSimple.boolean_type;
            }
            case 9: {
                return IdlSimple.char_type;
            }
            case 10: {
                return IdlSimple.octet_type;
            }
            case 11: {
                return IdlSimple.any_type;
            }
            case 12: {
                return IdlSimple.typecode_type;
            }
            case 14: {
                return new IdlString(0, idlObject2);
            }
            case 15: {
                return IdlSimple.object_type;
            }
            case 16: {
                return IdlSimple.longlong_type;
            }
            case 17: {
                return IdlSimple.ulonglong_type;
            }
            case 19: {
                return IdlSimple.wchar_type;
            }
            case 20: {
                return new IdlWString(0, idlObject2);
            }
            case 21: {
                return IdlSimple.valuebase_type;
            }
        }
        return null;
    }

    private IdlObject irString(IRObject iRObject, IdlObject idlObject2) {
        StringDef stringDef = StringDefHelper.narrow((Object)iRObject);
        return new IdlString(stringDef.bound(), idlObject2);
    }

    private IdlObject irWstring(IRObject iRObject, IdlObject idlObject2) {
        WstringDef wstringDef = WstringDefHelper.narrow((Object)iRObject);
        return new IdlWString(wstringDef.bound(), idlObject2);
    }

    private IdlObject irSequence(IRObject iRObject, IdlObject idlObject2) {
        SequenceDef sequenceDef = SequenceDefHelper.narrow((Object)iRObject);
        IdlSequence idlSequence2 = new IdlSequence(idlObject2);
        idlSequence2.addIdlObject(this.getType((IRObject)sequenceDef.element_type_def(), idlSequence2));
        idlSequence2.setSize(sequenceDef.bound());
        return idlSequence2;
    }

    private IdlObject irArray(IRObject iRObject, IdlObject idlObject2) {
        ArrayDef arrayDef = ArrayDefHelper.narrow((Object)iRObject);
        IdlArray idlArray2 = new IdlArray(idlObject2);
        idlArray2.addIdlObject(this.getType((IRObject)arrayDef.element_type_def(), idlArray2));
        idlArray2.setDimension(arrayDef.length());
        return idlArray2;
    }

    private void irFactory(Initializer[] initializerArray, IdlValue idlValue2) {
        IdlFactory idlFactory2 = null;
        IdlFactoryMember idlFactoryMember = null;
        int n = 0;
        while (n < initializerArray.length) {
            idlFactory2 = new IdlFactory(idlValue2);
            idlFactory2.name(initializerArray[n].name);
            int n2 = 0;
            while (n2 < initializerArray[n].members.length) {
                idlFactoryMember = new IdlFactoryMember(idlFactory2);
                idlFactoryMember.name(initializerArray[n].members[n2].name);
                idlFactoryMember.type(this.getType((IRObject)initializerArray[n].members[n2].type_def, idlFactory2));
                idlFactory2.addIdlObject(idlFactoryMember);
                ++n2;
            }
            idlValue2.addIdlObject(idlFactory2);
            ++n;
        }
    }

    private IdlObject irAttribute(IRObject iRObject, IdlObject idlObject2) {
        AttributeDef attributeDef = AttributeDefHelper.narrow((Object)iRObject);
        IdlAttribute idlAttribute2 = new IdlAttribute(idlObject2);
        idlAttribute2.name(attributeDef.name());
        if (attributeDef.mode().value() == 0) {
            idlAttribute2.readOnly(false);
        } else {
            idlAttribute2.readOnly(true);
        }
        idlAttribute2.type(this.getType((IRObject)attributeDef.type_def(), idlAttribute2));
        idlObject2.addIdlObject(idlObject2);
        return idlObject2;
    }

    private IdlObject irOperation(IRObject iRObject, IdlObject idlObject2) {
        String[] stringArray;
        IdlParam idlParam = null;
        IdlRaises idlRaises = null;
        IdlContext idlContext = null;
        OperationDef operationDef = OperationDefHelper.narrow((Object)iRObject);
        IdlOp idlOp = new IdlOp(idlObject2);
        idlOp.name(operationDef.name());
        if (operationDef.mode().value() == 0) {
            idlOp.oneway(false);
        } else {
            idlOp.oneway(true);
        }
        idlOp.addIdlObject(this.getType((IRObject)operationDef.result_def(), idlOp));
        ParameterDescription[] parameterDescriptionArray = operationDef.params();
        int n = 0;
        while (n < parameterDescriptionArray.length) {
            idlParam = new IdlParam(idlOp);
            idlParam.name(parameterDescriptionArray[n].name);
            switch (parameterDescriptionArray[n].mode.value()) {
                case 0: {
                    idlParam.param_attr(0);
                    break;
                }
                case 1: {
                    idlParam.param_attr(1);
                    break;
                }
                case 2: {
                    idlParam.param_attr(2);
                }
            }
            idlParam.type(this.getType((IRObject)parameterDescriptionArray[n].type_def, idlOp));
            idlOp.addIdlObject(idlParam);
            ++n;
        }
        ExceptionDef[] exceptionDefArray = operationDef.exceptions();
        if (exceptionDefArray.length != 0) {
            idlRaises = new IdlRaises(idlOp);
            int n2 = 0;
            while (n2 < exceptionDefArray.length) {
                idlRaises.addIdlObject(this.getType((IRObject)exceptionDefArray[n2], idlOp));
                ++n2;
            }
            idlOp.addIdlObject(idlRaises);
        }
        if ((stringArray = operationDef.contexts()).length != 0) {
            idlContext = new IdlContext(idlOp);
            int n3 = 0;
            while (n3 < stringArray.length) {
                idlContext.addValue(stringArray[n3]);
                ++n3;
            }
            idlOp.addIdlObject(idlContext);
        }
        idlObject2.addIdlObject(idlOp);
        return idlOp;
    }

    private IdlObject irValueMember(IRObject iRObject, IdlObject idlObject2) {
        ValueMemberDef valueMemberDef = ValueMemberDefHelper.narrow((Object)iRObject);
        IdlStateMember idlStateMember = new IdlStateMember(idlObject2);
        idlStateMember.name(valueMemberDef.name());
        if (valueMemberDef.access() == 0) {
            idlStateMember.public_member(false);
        } else {
            idlStateMember.public_member(true);
        }
        idlObject2.type(this.getType((IRObject)valueMemberDef.type_def(), idlStateMember));
        idlObject2.addIdlObject(idlStateMember);
        return idlStateMember;
    }

    public IdlObject createOrFindScope(String string, IdlObject idlObject2, Container container) {
        String string2 = null;
        Contained contained = null;
        Container container2 = null;
        IdlObject idlObject3 = null;
        idlObject3 = string.startsWith("::") ? this._parser.root : idlObject2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "::");
        container2 = container;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) {
                return idlObject3;
            }
            contained = container2.lookup(string2);
            if (contained == null) {
                IdlParser.show_fatal_error("Unable to find information into IR !");
                return null;
            }
            try {
                container2 = ContainerHelper.narrow((Object)contained);
            }
            catch (BAD_PARAM bAD_PARAM) {
                IdlParser.show_fatal_error("Incorrect scope !");
                return null;
            }
            idlObject3 = idlObject3.isDefined(string2, true) ? idlObject3.returnObject(string2, true) : this.createContainer(container2, idlObject3);
        }
        return idlObject3;
    }

    public IdlObject createContainer(Container container, IdlObject idlObject2) {
        switch (container.def_kind().value()) {
            case 6: {
                return this.irModule(container, idlObject2, false);
            }
            case 5: {
                return this.irInterface(container, idlObject2, false, 0);
            }
            case 25: {
                return this.irInterface(container, idlObject2, false, 1);
            }
            case 24: {
                return this.irInterface(container, idlObject2, false, 2);
            }
            case 20: {
                return this.irValue(container, idlObject2, false);
            }
            case 10: {
                return this.irStruct(container, idlObject2, false);
            }
            case 11: {
                return this.irUnion(container, idlObject2, false);
            }
            case 4: {
                return this.irException(container, idlObject2, false);
            }
        }
        IdlParser.show_fatal_error("Incorrect IR Container type");
        return null;
    }

    public IdlObject getType(IRObject iRObject, IdlObject idlObject2) {
        try {
            switch (iRObject.def_kind().value()) {
                case 4: {
                    ExceptionDef exceptionDef = ExceptionDefHelper.narrow((Object)iRObject);
                    return new IdlIdent(exceptionDef.name(), idlObject2, this.getDescription(iRObject));
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 20: 
                case 21: 
                case 23: {
                    IDLType iDLType = IDLTypeHelper.narrow((Object)iRObject);
                    return new IdlIdent(iDLType.type().name(), idlObject2, this.getDescription(iRObject));
                }
                case 13: {
                    return this.irPrimitive(iRObject, idlObject2);
                }
                case 14: {
                    return this.irString(iRObject, idlObject2);
                }
                case 15: {
                    return this.irSequence(iRObject, idlObject2);
                }
                case 16: {
                    return this.irArray(iRObject, idlObject2);
                }
                case 18: {
                    return this.irWstring(iRObject, idlObject2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IdlParser.show_fatal_error("Unexpected error during type import");
        }
        return null;
    }

    private IdlObject getDescription(IRObject iRObject) {
        String string = this.irScopeName(iRObject);
        IdlObject idlObject2 = this.createOrFindScope(string, null, (Container)this._ir);
        return this.irDescription(iRObject, idlObject2, false);
    }

    private String irScopeName(IRObject iRObject) {
        Contained contained = null;
        switch (iRObject.def_kind().value()) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                this._parser.warning("Unexpected state during import...");
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 23: {
                contained = ContainedHelper.narrow((Object)iRObject);
                return "::" + contained.absolute_name();
            }
        }
        return null;
    }

    private long getValue(Any any) {
        switch (any.type().kind().value()) {
            case 8: {
                boolean bl = any.extract_boolean();
                if (bl) {
                    return 1L;
                }
                return 0L;
            }
            case 2: {
                short s = any.extract_short();
                return s;
            }
            case 4: {
                short s = any.extract_ushort();
                return s;
            }
            case 3: {
                int n = any.extract_long();
                return n;
            }
            case 5: {
                int n = any.extract_ulong();
                return n;
            }
            case 23: {
                long l = any.extract_longlong();
                return l;
            }
            case 24: {
                long l = any.extract_ulonglong();
                return l;
            }
            case 9: {
                char c = any.extract_char();
                return c;
            }
        }
        return 0L;
    }

    private String getExpression(Any any, TypeCode typeCode) {
        try {
            switch (any.type().kind().value()) {
                case 8: {
                    boolean bl = any.extract_boolean();
                    if (bl) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                case 2: {
                    short s = any.extract_short();
                    return "" + s;
                }
                case 4: {
                    short s = any.extract_ushort();
                    return "" + s;
                }
                case 3: {
                    int n = any.extract_long();
                    return "" + n;
                }
                case 5: {
                    int n = any.extract_ulong();
                    if (((TypeCodeBase)typeCode)._base_type().kind().value() == 17) {
                        return ((TypeCodeBase)typeCode)._base_type().member_name(n);
                    }
                    return "" + n;
                }
                case 23: {
                    long l = any.extract_longlong();
                    return "" + l;
                }
                case 24: {
                    long l = any.extract_ulonglong();
                    return "" + l;
                }
                case 9: {
                    char c = any.extract_char();
                    return "" + c;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getConstExpression(Any any, TypeCode typeCode) {
        try {
            switch (any.type().kind().value()) {
                case 8: {
                    boolean bl = any.extract_boolean();
                    if (bl) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                case 2: {
                    short s = any.extract_short();
                    return "" + s;
                }
                case 4: {
                    short s = any.extract_ushort();
                    return "" + s;
                }
                case 3: {
                    int n = any.extract_long();
                    return "" + n;
                }
                case 5: {
                    int n = any.extract_ulong();
                    if (((TypeCodeBase)typeCode)._base_type().kind().value() == 17) {
                        return ((TypeCodeBase)typeCode)._base_type().member_name(n);
                    }
                    return "" + n;
                }
                case 23: {
                    long l = any.extract_longlong();
                    return "" + l;
                }
                case 24: {
                    long l = any.extract_ulonglong();
                    return "" + l;
                }
                case 9: {
                    char c = any.extract_char();
                    return "" + c;
                }
                case 10: {
                    byte by = any.extract_octet();
                    return "" + by;
                }
                case 6: {
                    float f = any.extract_float();
                    return "" + f;
                }
                case 7: {
                    double d = any.extract_double();
                    return "" + d;
                }
                case 26: {
                    char c = any.extract_wchar();
                    return "" + c;
                }
                case 18: {
                    return any.extract_string();
                }
                case 27: {
                    return any.extract_wstring();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void setConstValue(Any any, IdlConst idlConst2) {
        switch (any.type().kind().value()) {
            case 8: {
                boolean bl = any.extract_boolean();
                if (bl) {
                    idlConst2.intValue(1L);
                    idlConst2.floatValue(1.0);
                    break;
                }
                idlConst2.intValue(0L);
                idlConst2.floatValue(0.0);
                break;
            }
            case 2: {
                short s = any.extract_short();
                idlConst2.intValue(s);
                idlConst2.floatValue(s);
                break;
            }
            case 4: {
                short s = any.extract_ushort();
                idlConst2.intValue(s);
                idlConst2.floatValue(s);
                break;
            }
            case 3: {
                int n = any.extract_long();
                idlConst2.intValue(n);
                idlConst2.floatValue(n);
                break;
            }
            case 5: {
                int n = any.extract_ulong();
                idlConst2.intValue(n);
                idlConst2.floatValue(n);
                break;
            }
            case 23: {
                long l = any.extract_longlong();
                idlConst2.intValue(l);
                idlConst2.floatValue(l);
                break;
            }
            case 24: {
                long l = any.extract_ulonglong();
                idlConst2.intValue(l);
                idlConst2.floatValue(l);
                break;
            }
            case 9: {
                char c = any.extract_char();
                idlConst2.intValue(c);
                idlConst2.floatValue(c);
                break;
            }
            case 10: {
                byte by = any.extract_octet();
                idlConst2.intValue(by);
                idlConst2.floatValue(by);
                break;
            }
            case 6: {
                float f = any.extract_float();
                idlConst2.intValue(0L);
                idlConst2.floatValue(f);
                break;
            }
            case 7: {
                double d = any.extract_double();
                idlConst2.intValue(0L);
                idlConst2.floatValue(d);
                break;
            }
            case 26: {
                char c = any.extract_wchar();
                idlConst2.intValue(c);
                idlConst2.floatValue(0.0);
                break;
            }
            case 18: {
                idlConst2.intValue(0L);
                idlConst2.floatValue(0.0);
                break;
            }
            case 27: {
                idlConst2.intValue(0L);
                idlConst2.floatValue(0.0);
            }
        }
    }

    public boolean checkFromImportFromFile(String string) {
        if (!string.startsWith("::")) {
            return false;
        }
        if ((string = string.substring(2)).indexOf("::") != -1) {
            return false;
        }
        if (this.importFromIDLFile(string)) {
            this.addAsImported(string);
            return true;
        }
        return false;
    }

    private boolean importFromIDLFile(String string) {
        String string2 = this.getIDLFileName(string);
        if (string2 != null) {
            this._parser.include_idl_file(string2);
            return true;
        }
        return false;
    }

    private String getIDLFileName(String string) {
        int n = 0;
        while (n < IdlCompiler.importLink.size()) {
            if (this.getLinkContainerName((String)IdlCompiler.importLink.elementAt(n)).equalsIgnoreCase(string)) {
                return this.getLinkFileName((String)IdlCompiler.importLink.elementAt(n));
            }
            ++n;
        }
        return null;
    }

    private String getLinkContainerName(String string) {
        return string.substring(0, string.indexOf(":"));
    }

    private String getLinkFileName(String string) {
        return string.substring(string.indexOf(":") + 1, string.length());
    }

    private boolean isAlreadyImported(String string) {
        if (!string.startsWith("::")) {
            string = "::" + string;
        }
        return _imported.get(string) != null;
    }

    private void addAsImported(String string) {
        if (!string.startsWith("::")) {
            string = "::" + string;
        }
        _imported.put(string, string);
    }
}

