/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.idl.util;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.generator.IdlToJava;
import org.openorb.compiler.idl.reflect.idlIdentifier;
import org.openorb.compiler.idl.reflect.idlObject;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlObject;

public class tools {
    public static final String tab = "    ";
    protected static IdlToJava generator = new IdlToJava();

    public static PrintWriter createNewFile(File file, String string) {
        PrintWriter printWriter = null;
        String string2 = new String(file.getPath() + File.separator + string + ".java");
        File file2 = new File(string2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            printWriter = new PrintWriter(dataOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return printWriter;
    }

    public static void writePackageName(PrintWriter printWriter, idlObject idlObject2) {
        if (idlObject2.idlDefinedIn() != null) {
            printWriter.println("package " + tools.fullname(idlObject2.idlDefinedIn()) + ";");
        }
    }

    public static String javaName(idlObject idlObject2) {
        if (idlObject2.idlType() == 12) {
            return tools.fullname(((idlIdentifier)idlObject2).original());
        }
        return tools.fullname(idlObject2);
    }

    private static String fullname(idlObject idlObject2) {
        Vector<String> vector = new Vector<String>();
        IdlObject idlObject3 = (IdlObject)idlObject2;
        String string = new String("");
        boolean bl = false;
        while (idlObject3 != null) {
            if (bl) {
                if (idlObject3.kind() == 15 || idlObject3.kind() == 28 || idlObject3.kind() == 3 || idlObject3.kind() == 4 || idlObject3.kind() == 14) {
                    vector.addElement(idlObject3.name() + "Package");
                } else {
                    vector.addElement(idlObject3.name());
                }
            } else {
                vector.addElement(idlObject3.name());
            }
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
            bl = true;
        }
        if (!(IdlCompiler.packageName == null || idlObject2.included() || IdlCompiler.packageName.equals("") || IdlCompiler.packageName.equals("generated") && !IdlCompiler.use_package)) {
            string = tools.adaptToDot(IdlCompiler.packageName);
        }
        if (IdlCompiler.usePrefix && ((IdlObject)idlObject2).getPrefix() != null) {
            if (!string.equals("")) {
                string = string + ".";
            }
            string = string + tools.inversedPrefix(((IdlObject)idlObject2).getPrefix());
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            String string2 = (String)vector.elementAt(n);
            if (string2 != null) {
                if (!string.equals("")) {
                    string = string + ".";
                }
                string = string + string2;
            }
            --n;
        }
        return string;
    }

    public static String adaptToDot(String string) {
        char[] cArray = new char[string.length()];
        int n = 0;
        while (n < string.length()) {
            cArray[n] = string.charAt(n) == '/' || string.charAt(n) == '\\' ? 46 : string.charAt(n);
            ++n;
        }
        return new String(cArray);
    }

    public static String inversedPrefix(String string) {
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        String string2 = new String("");
        try {
            while (n != -1) {
                n = string.indexOf(46, n2);
                if (n == -1) continue;
                vector.addElement(new String(string.substring(n2, n)));
                n2 = n + 1;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        vector.addElement(new String(string.substring(n2, string.length())));
        int n3 = vector.size() - 1;
        while (n3 >= 0) {
            if (!string2.equals("")) {
                string2 = string2 + ".";
            }
            string2 = string2 + (String)vector.elementAt(n3);
            --n3;
        }
        return string2;
    }

    public static void javaType(idlObject idlObject2, PrintWriter printWriter) {
        if (idlObject2.idlType() == 12) {
            generator.translate_type((IdlObject)((idlIdentifier)idlObject2).original(), printWriter);
            return;
        }
        generator.translate_type((IdlObject)idlObject2, printWriter);
    }

    public static void marshal(idlObject idlObject2, PrintWriter printWriter, String string, String string2) {
        generator.translate_marshalling_member((IdlObject)idlObject2, printWriter, string, string2, "        ");
    }

    public static void unmarshal(idlObject idlObject2, PrintWriter printWriter, String string, String string2) {
        generator.translate_unmarshalling_member((IdlObject)idlObject2, printWriter, string, string2, "        ");
    }

    public static void translate_comment_section(PrintWriter printWriter, String string, IdlObject idlObject2) {
        tools.translate_comment_section_base(printWriter, string, idlObject2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void translate_comment_section_base(PrintWriter printWriter, String string, IdlObject idlObject2) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '\n') {
                if (n == string.length() - 1) {
                    printWriter.println("");
                    return;
                }
                printWriter.println("");
                if (idlObject2.kind() == 17 || idlObject2.kind() == 16 || idlObject2.kind() == 29) {
                    printWriter.print(tab);
                }
                printWriter.print(" * ");
            } else {
                printWriter.print(string.charAt(n));
            }
            ++n;
        }
    }

    public static void javadoc(PrintWriter printWriter, IdlObject idlObject2) {
        tools.javadoc_base(printWriter, idlObject2);
    }

    public static void javadoc_base(PrintWriter printWriter, IdlObject idlObject2) {
        IdlComment idlComment = idlObject2.getComment();
        String string = null;
        if (idlComment != null) {
            string = idlComment.get_description();
            if (idlObject2.kind() == 17 || idlObject2.kind() == 16 || idlObject2.kind() == 29) {
                printWriter.print(tab);
            }
            printWriter.println("/**");
            if (idlObject2.kind() == 17 || idlObject2.kind() == 16 || idlObject2.kind() == 29) {
                printWriter.print(tab);
            }
            printWriter.print(" * ");
            tools.translate_comment_section(printWriter, string, idlObject2);
            IdlCommentSection[] idlCommentSectionArray = idlComment.get_sections();
            int n = 0;
            while (n < idlCommentSectionArray.length) {
                switch (idlCommentSectionArray[n].kind().value()) {
                    case 0: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print(tab);
                        }
                        printWriter.print(" * @author ");
                        break;
                    }
                    case 6: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print(tab);
                        }
                        printWriter.print(" * @deprecated ");
                        break;
                    }
                    case 1: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print(tab);
                        }
                        printWriter.print(" * @exception ");
                        break;
                    }
                    case 4: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print(tab);
                        }
                        printWriter.print(" * @return ");
                        break;
                    }
                    case 3: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print(tab);
                        }
                        printWriter.print(" * @param ");
                        break;
                    }
                    case 5: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print(tab);
                        }
                        printWriter.print(" * @see ");
                        break;
                    }
                    case 2: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print(tab);
                        }
                        printWriter.print(" * @version ");
                        break;
                    }
                    case 7: {
                        if (idlObject2.kind() == 17 || idlObject2.kind() == 16) {
                            printWriter.print(tab);
                        }
                        printWriter.print(" * @" + idlCommentSectionArray[n].get_title() + " ");
                    }
                }
                string = idlCommentSectionArray[n].get_description();
                tools.translate_comment_section(printWriter, string, idlObject2);
                ++n;
            }
            if (idlObject2.kind() == 17 || idlObject2.kind() == 16 || idlObject2.kind() == 29) {
                printWriter.print(tab);
            }
            printWriter.println(" */");
        }
    }
}

