/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.doc.rtf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openorb.compiler.doc.IdlDoc;
import org.openorb.compiler.doc.html.content;
import org.openorb.compiler.doc.rtf.model;
import org.openorb.compiler.object.IdlArray;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlContext;
import org.openorb.compiler.object.IdlEnumMember;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlUnion;
import org.openorb.compiler.object.IdlUnionMember;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;

public class IdlToRTF {
    private IdlObject _root;
    private int nb_color_entry = 1;
    private model title_model;
    private model header_model;
    private model footer_model;
    private model section_title_model;
    private model section_id_model;
    private model section_hierarchy_model;
    private model section_desc_model;
    private model summary_title_model;
    private model summary_entry_name_model;
    private model summary_entry_desc_model;
    private model summary_inher_title_model;
    private model summary_inher_desc_model;
    private model summary_inher_list_model;
    private model detail_title_model;
    private model detail_id_model;
    private model detail_java_model;
    private model detail_desc_model;
    private model detail_comment_model;
    private model detail_highlight_model;

    private String convertTextAttribute(String string) {
        String string2 = "";
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase("italic")) {
                string2 = string2 + "\\i";
                continue;
            }
            if (string3.equalsIgnoreCase("bold")) {
                string2 = string2 + "\\b";
                continue;
            }
            if (string3.equalsIgnoreCase("underline")) {
                string2 = string2 + "\\ul";
                continue;
            }
            if (string3.equalsIgnoreCase("uppercase")) {
                string2 = string2 + "\\caps";
                continue;
            }
            if (string3.equalsIgnoreCase("left")) {
                string2 = string2 + "\\ql";
                continue;
            }
            if (string3.equalsIgnoreCase("right")) {
                string2 = string2 + "\\qr";
                continue;
            }
            if (string3.equalsIgnoreCase("center")) {
                string2 = string2 + "\\qc";
                continue;
            }
            if (!string3.equalsIgnoreCase("justified")) continue;
            string2 = string2 + "\\qj";
        }
        return string2;
    }

    private String convertBorderAttribute(String string, boolean bl) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string5 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
            if (string5.equalsIgnoreCase("box")) {
                bl2 = true;
                bl3 = true;
                bl4 = true;
                bl5 = true;
                continue;
            }
            if (string5.equalsIgnoreCase("bottom")) {
                bl2 = true;
                continue;
            }
            if (string5.equalsIgnoreCase("top")) {
                bl3 = true;
                continue;
            }
            if (string5.equalsIgnoreCase("left")) {
                bl4 = true;
                continue;
            }
            if (string5.equalsIgnoreCase("right")) {
                bl5 = true;
                continue;
            }
            if (string5.equalsIgnoreCase("double")) {
                string3 = "\\brdrdb";
                continue;
            }
            if (string5.equalsIgnoreCase("simple")) {
                string3 = "\\brdrs";
                continue;
            }
            if (string5.equalsIgnoreCase("dotted")) {
                string3 = "\\brdrdot";
                continue;
            }
            if (!string5.equalsIgnoreCase("shadowed")) continue;
            string4 = "\\brdrsh";
        }
        if (bl2) {
            string2 = bl ? string2 + "\\clbrdrb" + string3 + string4 + "\\brsp10" + " " : string2 + "\\brdrb" + string3 + string4 + "\\brsp10" + " ";
        }
        if (bl3) {
            string2 = bl ? string2 + "\\clbrdrt" + string3 + string4 + "\\brsp10" + " " : string2 + "\\brdrt" + string3 + string4 + "\\brsp10" + " ";
        }
        if (bl4) {
            string2 = bl ? string2 + "\\clbrdrl" + string3 + string4 + "\\brsp10" + " " : string2 + "\\brdrl" + string3 + string4 + "\\brsp10" + " ";
        }
        if (bl5) {
            string2 = bl ? string2 + "\\clbrdrr" + string3 + string4 + "\\brsp10" + " " : string2 + "\\brdrr" + string3 + string4 + "\\brsp10" + " ";
        }
        return string2;
    }

    private void loadModel(Properties properties, model model2, String string, boolean bl) {
        String string2 = null;
        model2.fontName = properties.getProperty(string + ".font");
        model2.fontFamily = properties.getProperty(string + ".family");
        model2.color = properties.getProperty(string + ".color");
        model2.backcolor = properties.getProperty(string + ".background");
        string2 = properties.getProperty(string + ".size");
        model2.fontSize = "" + new Integer(string2) * 2;
        string2 = properties.getProperty(string + ".attributes");
        if (string2 != null) {
            model2.attribute = this.convertTextAttribute(string2);
        }
        if ((string2 = properties.getProperty(string + ".border")) != null) {
            model2.border = this.convertBorderAttribute(string2, bl);
        }
    }

    private void loadStyleSheet() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {}
        } else {
            System.out.println("IDL to RTF fatal error : Unable to open style sheet model ( rtf.cs )");
            System.exit(0);
        }
        this.title_model = new model();
        this.header_model = new model();
        this.footer_model = new model();
        this.section_title_model = new model();
        this.section_id_model = new model();
        this.section_hierarchy_model = new model();
        this.section_desc_model = new model();
        this.summary_title_model = new model();
        this.summary_entry_name_model = new model();
        this.summary_entry_desc_model = new model();
        this.summary_inher_title_model = new model();
        this.summary_inher_list_model = new model();
        this.summary_inher_desc_model = new model();
        this.detail_title_model = new model();
        this.detail_id_model = new model();
        this.detail_java_model = new model();
        this.detail_desc_model = new model();
        this.detail_comment_model = new model();
        this.detail_highlight_model = new model();
        this.loadModel(properties, this.title_model, "title", false);
        this.loadModel(properties, this.header_model, "header", false);
        this.loadModel(properties, this.footer_model, "footer", false);
        this.loadModel(properties, this.section_title_model, "section.title", false);
        this.loadModel(properties, this.section_id_model, "section.id", false);
        this.loadModel(properties, this.section_hierarchy_model, "section.hierarchy", false);
        this.loadModel(properties, this.section_desc_model, "section.description", false);
        this.loadModel(properties, this.summary_title_model, "summary.title", true);
        this.loadModel(properties, this.summary_entry_name_model, "summary.entry_name", true);
        this.loadModel(properties, this.summary_entry_desc_model, "summary.entry_description", true);
        this.loadModel(properties, this.summary_inher_title_model, "summary.inheritance_title", true);
        this.loadModel(properties, this.summary_inher_desc_model, "summary.inheritance_description", true);
        this.loadModel(properties, this.summary_inher_list_model, "summary.inheritance_list", true);
        this.loadModel(properties, this.detail_title_model, "detail.title", true);
        this.loadModel(properties, this.detail_id_model, "detail.id", true);
        this.loadModel(properties, this.detail_java_model, "detail.java", true);
        this.loadModel(properties, this.detail_desc_model, "detail.description", true);
        this.loadModel(properties, this.detail_comment_model, "detail.comment", true);
        this.loadModel(properties, this.detail_highlight_model, "detail.highlight", true);
    }

    private String getModel(model model2) {
        String string = "";
        string = string + "\\plain ";
        string = string + "\\f" + model2.fontNumber;
        string = string + "\\fs" + model2.fontSize;
        string = string + "\\cf" + model2.colorNumber;
        if (model2.backcolor != null) {
            string = string + "\\cbpat" + model2.backgroundNumber;
        }
        if (model2.border != null) {
            string = string + model2.border;
        }
        if (model2.attribute != null) {
            string = string + model2.attribute;
        }
        string = string + " ";
        return string;
    }

    private void write_model(model model2, PrintWriter printWriter) {
        printWriter.print("\\plain ");
        printWriter.print("\\f" + model2.fontNumber);
        printWriter.print("\\fs" + model2.fontSize);
        printWriter.print("\\cf" + model2.colorNumber);
        if (model2.backcolor != null) {
            printWriter.print("\\cbpat" + model2.backgroundNumber);
        }
        if (model2.border != null) {
            printWriter.print(model2.border);
        }
        if (model2.attribute != null) {
            printWriter.print(model2.attribute + " ");
        }
    }

    private void write_cell_model(model model2, PrintWriter printWriter) {
        printWriter.print("\\f" + model2.fontNumber);
        printWriter.print("\\fs" + model2.fontSize);
        printWriter.print("\\cf" + model2.colorNumber);
        if (model2.attribute != null) {
            printWriter.print(model2.attribute);
        }
        printWriter.print(" ");
    }

    private void write_cell_border(model model2, PrintWriter printWriter) {
        if (model2.border != null) {
            printWriter.print(model2.border);
        }
    }

    private void write_cell_color(model model2, PrintWriter printWriter) {
        if (model2.backcolor != null) {
            printWriter.print("\\clcbpat" + model2.backgroundNumber);
        }
    }

    private void createFontEntry(model model2, PrintWriter printWriter) {
        printWriter.print("{\\f" + model2.fontNumber + "\\f");
        printWriter.print(model2.fontFamily + " ");
        printWriter.print(model2.fontName + "}");
    }

    private void createColorEntry(model model2, PrintWriter printWriter) {
        ++this.nb_color_entry;
        if (model2.color.equalsIgnoreCase("black")) {
            printWriter.print("\\red0\\green0\\blue0;");
        } else if (model2.color.equalsIgnoreCase("green")) {
            printWriter.print("\\red0\\green128\\blue0;");
        } else if (model2.color.equalsIgnoreCase("red")) {
            printWriter.print("\\red128\\green0\\blue0;");
        } else if (model2.color.equalsIgnoreCase("blue")) {
            printWriter.print("\\red0\\green0\\blue128;");
        } else if (model2.color.equalsIgnoreCase("yellow")) {
            printWriter.print("\\red128\\green128\\blue0;");
        } else if (model2.color.equalsIgnoreCase("lightyellow")) {
            printWriter.print("\\red255\\green255\\blue0;");
        } else if (model2.color.equalsIgnoreCase("cyan")) {
            printWriter.print("\\red0\\green255\\blue255;");
        } else if (model2.color.equalsIgnoreCase("brown")) {
            printWriter.print("\\red128\\green128\\blue0;");
        } else if (model2.color.equalsIgnoreCase("grey")) {
            printWriter.print("\\red128\\green128\\blue128;");
        } else if (model2.color.equalsIgnoreCase("purple")) {
            printWriter.print("\\red128\\green0\\blue128;");
        } else if (model2.color.equalsIgnoreCase("lightgrey")) {
            printWriter.print("\\red192\\green192\\blue192;");
        } else if (model2.color.equalsIgnoreCase("lightpurple")) {
            printWriter.print("\\red255\\green0\\blue255;");
        } else if (model2.color.equalsIgnoreCase("lightblue")) {
            printWriter.print("\\red0\\green0\\blue255;");
        } else if (model2.color.equalsIgnoreCase("lightred")) {
            printWriter.print("\\red255\\green0\\blue0;");
        } else if (model2.color.equalsIgnoreCase("lightgreen")) {
            printWriter.print("\\red0\\green255\\blue0;");
        } else if (model2.color.equalsIgnoreCase("white")) {
            printWriter.print("\\red255\\green255\\blue255;");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(model2.color, ",");
            while (stringTokenizer.hasMoreTokens()) {
                printWriter.print("\\" + stringTokenizer.nextToken());
            }
            printWriter.print(";");
        }
    }

    private void createBackColorEntry(model model2, PrintWriter printWriter) {
        if (model2.backcolor == null) {
            return;
        }
        ++this.nb_color_entry;
        if (model2.backcolor.equalsIgnoreCase("black")) {
            printWriter.print("\\red0\\green0\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("green")) {
            printWriter.print("\\red0\\green128\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("red")) {
            printWriter.print("\\red128\\green0\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("blue")) {
            printWriter.print("\\red0\\green0\\blue128;");
        } else if (model2.backcolor.equalsIgnoreCase("yellow")) {
            printWriter.print("\\red128\\green128\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("lightyellow")) {
            printWriter.print("\\red255\\green255\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("cyan")) {
            printWriter.print("\\red0\\green255\\blue255;");
        } else if (model2.backcolor.equalsIgnoreCase("brown")) {
            printWriter.print("\\red128\\green128\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("grey")) {
            printWriter.print("\\red128\\green128\\blue128;");
        } else if (model2.backcolor.equalsIgnoreCase("purple")) {
            printWriter.print("\\red128\\green0\\blue128;");
        } else if (model2.backcolor.equalsIgnoreCase("lightgrey")) {
            printWriter.print("\\red192\\green192\\blue192;");
        } else if (model2.backcolor.equalsIgnoreCase("lightpurple")) {
            printWriter.print("\\red255\\green0\\blue255;");
        } else if (model2.backcolor.equalsIgnoreCase("lightblue")) {
            printWriter.print("\\red0\\green0\\blue255;");
        } else if (model2.backcolor.equalsIgnoreCase("lightred")) {
            printWriter.print("\\red255\\green0\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("lightgreen")) {
            printWriter.print("\\red0\\green255\\blue0;");
        } else if (model2.backcolor.equalsIgnoreCase("white")) {
            printWriter.print("\\red255\\green255\\blue255;");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(model2.backcolor, ",");
            while (stringTokenizer.hasMoreTokens()) {
                printWriter.print("\\" + stringTokenizer.nextToken());
            }
            printWriter.print(";");
        }
    }

    private void createRTFHeader(PrintWriter printWriter) {
        printWriter.print("{");
        printWriter.print("\\rtf1");
        printWriter.print("\\ainsi");
        printWriter.print("\\deff0");
        printWriter.print("{");
        printWriter.print("\\fonttbl");
        this.section_title_model.fontNumber = "0";
        this.createFontEntry(this.section_title_model, printWriter);
        this.section_id_model.fontNumber = "1";
        this.createFontEntry(this.section_id_model, printWriter);
        this.summary_title_model.fontNumber = "2";
        this.createFontEntry(this.summary_title_model, printWriter);
        this.summary_entry_name_model.fontNumber = "3";
        this.createFontEntry(this.summary_entry_name_model, printWriter);
        this.summary_entry_desc_model.fontNumber = "4";
        this.createFontEntry(this.summary_entry_desc_model, printWriter);
        this.section_hierarchy_model.fontNumber = "5";
        this.createFontEntry(this.section_hierarchy_model, printWriter);
        this.section_desc_model.fontNumber = "6";
        this.createFontEntry(this.section_desc_model, printWriter);
        this.detail_title_model.fontNumber = "7";
        this.createFontEntry(this.detail_title_model, printWriter);
        this.detail_desc_model.fontNumber = "8";
        this.createFontEntry(this.detail_desc_model, printWriter);
        this.detail_comment_model.fontNumber = "9";
        this.createFontEntry(this.detail_comment_model, printWriter);
        this.detail_id_model.fontNumber = "10";
        this.createFontEntry(this.detail_id_model, printWriter);
        this.detail_java_model.fontNumber = "11";
        this.createFontEntry(this.detail_java_model, printWriter);
        this.detail_highlight_model.fontNumber = "12";
        this.createFontEntry(this.detail_highlight_model, printWriter);
        this.summary_inher_title_model.fontNumber = "13";
        this.createFontEntry(this.summary_inher_title_model, printWriter);
        this.summary_inher_desc_model.fontNumber = "14";
        this.createFontEntry(this.summary_inher_desc_model, printWriter);
        this.summary_inher_list_model.fontNumber = "15";
        this.createFontEntry(this.summary_inher_list_model, printWriter);
        this.header_model.fontNumber = "16";
        this.createFontEntry(this.header_model, printWriter);
        this.footer_model.fontNumber = "17";
        this.createFontEntry(this.footer_model, printWriter);
        this.footer_model.fontNumber = "18";
        this.createFontEntry(this.title_model, printWriter);
        printWriter.print("}");
        printWriter.print("{");
        printWriter.print("\\colortbl;");
        this.section_title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.section_title_model, printWriter);
        this.section_title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.section_title_model, printWriter);
        this.section_id_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.section_id_model, printWriter);
        this.section_id_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.section_id_model, printWriter);
        this.section_hierarchy_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.section_hierarchy_model, printWriter);
        this.section_hierarchy_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.section_hierarchy_model, printWriter);
        this.section_desc_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.section_desc_model, printWriter);
        this.section_desc_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.section_desc_model, printWriter);
        this.summary_title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_title_model, printWriter);
        this.summary_title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_title_model, printWriter);
        this.summary_entry_name_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_entry_name_model, printWriter);
        this.summary_entry_name_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_entry_name_model, printWriter);
        this.summary_entry_desc_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_entry_desc_model, printWriter);
        this.summary_entry_desc_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_entry_desc_model, printWriter);
        this.summary_inher_title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_inher_title_model, printWriter);
        this.summary_inher_title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_inher_title_model, printWriter);
        this.summary_inher_desc_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_inher_desc_model, printWriter);
        this.summary_inher_desc_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_inher_desc_model, printWriter);
        this.summary_inher_list_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.summary_inher_list_model, printWriter);
        this.summary_inher_list_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.summary_inher_list_model, printWriter);
        this.detail_title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_title_model, printWriter);
        this.detail_title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_title_model, printWriter);
        this.detail_desc_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_desc_model, printWriter);
        this.detail_desc_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_desc_model, printWriter);
        this.detail_comment_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_comment_model, printWriter);
        this.detail_comment_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_comment_model, printWriter);
        this.detail_id_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_id_model, printWriter);
        this.detail_id_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_id_model, printWriter);
        this.detail_java_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_java_model, printWriter);
        this.detail_java_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_java_model, printWriter);
        this.detail_highlight_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.detail_highlight_model, printWriter);
        this.detail_highlight_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.detail_highlight_model, printWriter);
        this.header_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.header_model, printWriter);
        this.header_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.header_model, printWriter);
        this.footer_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.footer_model, printWriter);
        this.footer_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.footer_model, printWriter);
        this.title_model.colorNumber = "" + this.nb_color_entry;
        this.createColorEntry(this.title_model, printWriter);
        this.title_model.backgroundNumber = "" + this.nb_color_entry;
        this.createBackColorEntry(this.title_model, printWriter);
        printWriter.print("}");
    }

    private String inversedPrefix(String string) {
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        String string2 = new String("");
        try {
            while (n != -1) {
                n = string.indexOf(46, n2);
                if (n == -1) continue;
                vector.addElement(new String(string.substring(n2, n)));
                n2 = n + 1;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        vector.addElement(new String(string.substring(n2, string.length())));
        int n3 = vector.size() - 1;
        while (n3 >= 0) {
            if (!string2.equals("")) {
                string2 = string2 + ".";
            }
            string2 = string2 + (String)vector.elementAt(n3);
            --n3;
        }
        return string2;
    }

    private String fullname(IdlObject idlObject2) {
        Vector<String> vector = new Vector<String>();
        IdlObject idlObject3 = idlObject2;
        String string = new String("");
        boolean bl = false;
        while (idlObject3 != null) {
            vector.addElement(idlObject3.name());
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
            bl = true;
        }
        if (IdlDoc.usePrefix && idlObject2.getPrefix() != null) {
            if (!string.equals("")) {
                string = string + ".";
            }
            string = string + this.inversedPrefix(idlObject2.getPrefix());
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            String string2 = (String)vector.elementAt(n);
            if (string2 != null) {
                if (!string.equals("")) {
                    string = string + ".";
                }
                string = string + string2;
            }
            --n;
        }
        return string;
    }

    public String translateType(IdlObject idlObject2, String string, String string2, boolean bl, IdlObject idlObject3) {
        IdlSimple idlSimple = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                switch (idlSimple.internal()) {
                    case 55: {
                        string = string + "void";
                        break;
                    }
                    case 34: {
                        string = string + "float";
                        break;
                    }
                    case 30: {
                        string = string + "double";
                        break;
                    }
                    case 47: {
                        string = string + "short";
                        break;
                    }
                    case 66: {
                        string = string + "unsigned short";
                        break;
                    }
                    case 38: {
                        string = string + "long";
                        break;
                    }
                    case 65: {
                        string = string + "unsigned long";
                        break;
                    }
                    case 73: {
                        string = string + "long long";
                        break;
                    }
                    case 74: {
                        string = string + "unsigned long long";
                        break;
                    }
                    case 26: {
                        string = string + "char";
                        break;
                    }
                    case 71: {
                        string = string + "wchar";
                        break;
                    }
                    case 24: {
                        string = string + "boolean";
                        break;
                    }
                    case 41: {
                        string = string + "octet";
                        break;
                    }
                    case 22: {
                        string = string + "any";
                        break;
                    }
                    case 70: {
                        string = string + "CORBA::TypeCode";
                        break;
                    }
                    case 40: {
                        string = string + "Object";
                        break;
                    }
                    case 88: {
                        string = string + "valuebase";
                    }
                }
                break;
            }
            case 26: {
                string = string + "fixed";
                break;
            }
            case 5: {
                string = string + "string";
                break;
            }
            case 6: {
                string = string + "wstring";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: 
            case 25: 
            case 28: 
            case 33: {
                string = string + "{" + this.getModel(this.detail_highlight_model) + this.fullname(idlObject2) + "}";
                break;
            }
            case 13: {
                idlObject2.reset();
                this.translateType(idlObject2.current(), string, string2, bl, idlObject3);
                break;
            }
            case 9: {
                string = string + "sequence<";
                string = this.translateType(idlObject2.current(), string, string2, false, idlObject3);
                string = string + ">";
                break;
            }
            case 24: {
                string = this.translateType(idlObject2.current(), string, string2 + "[" + ((IdlArray)idlObject2).getDimension() + "]", false, idlObject3);
                if (idlObject2.current().kind() != 24) {
                    string = string + " " + string2;
                    string = string + "[" + ((IdlArray)idlObject2).getDimension() + "]";
                }
                return string;
            }
            case 10: {
                if (((IdlIdent)idlObject2).internalObject().name().equals("TypeCode")) {
                    string = string + "CORBA::TypeCode";
                    break;
                }
                string = string + "{" + this.getModel(this.detail_highlight_model) + this.fullname(((IdlIdent)idlObject2).internalObject()) + "}";
                break;
            }
            case 27: {
                if (((IdlValueBox)idlObject2).simple()) {
                    string = string + this.fullname(idlObject2);
                    break;
                }
                idlObject2.reset();
                string = this.translateType(idlObject2.current(), string, string2, bl, idlObject3);
            }
        }
        if (bl) {
            string = string + " " + string2;
        }
        return string;
    }

    private String translateParameter(IdlObject idlObject2, String string) {
        IdlParam idlParam = (IdlParam)idlObject2;
        idlParam.reset();
        switch (idlParam.param_attr()) {
            case 0: {
                string = string + "in ";
                break;
            }
            case 1: {
                string = string + "out ";
                break;
            }
            case 2: {
                string = string + "inout ";
            }
        }
        return this.translateType(idlParam.current(), string, idlParam.name(), true, idlObject2);
    }

    private String getJavaName(IdlObject idlObject2) {
        String string = "";
        IdlSimple idlSimple = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                switch (idlSimple.internal()) {
                    case 55: {
                        string = "void";
                        break;
                    }
                    case 34: {
                        string = "float";
                        break;
                    }
                    case 30: {
                        string = "double";
                        break;
                    }
                    case 47: {
                        string = "short";
                        break;
                    }
                    case 66: {
                        string = "short";
                        break;
                    }
                    case 38: {
                        string = "int";
                        break;
                    }
                    case 65: {
                        string = "int";
                        break;
                    }
                    case 73: {
                        string = "long";
                        break;
                    }
                    case 74: {
                        string = "long";
                        break;
                    }
                    case 26: {
                        string = "char";
                        break;
                    }
                    case 71: {
                        string = "char";
                        break;
                    }
                    case 24: {
                        string = "boolean";
                        break;
                    }
                    case 41: {
                        string = "byte";
                        break;
                    }
                    case 22: {
                        string = "org.omg.CORBA.Any";
                        break;
                    }
                    case 70: {
                        string = "org.omg.CORBA.TypeCode";
                        break;
                    }
                    case 40: {
                        string = "org.omg.CORBA.Object";
                        break;
                    }
                    case 88: {
                        string = "org.omg.CORBA.ValueBase";
                    }
                }
                break;
            }
            case 26: {
                string = "java.lang.BidDecimal";
                break;
            }
            case 5: {
                string = "java.lang.String";
                break;
            }
            case 6: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 28: 
            case 29: {
                string = this.fullname(idlObject2);
                break;
            }
            case 13: {
                idlObject2.reset();
                string = this.getJavaName(idlObject2.current());
                break;
            }
            case 9: 
            case 24: {
                string = this.getJavaName(idlObject2.current());
                string = string + "[]";
                break;
            }
            case 7: {
                string = this.fullname(idlObject2) + ".value";
                break;
            }
            case 10: {
                if (((IdlIdent)idlObject2).internalObject().name().equals("TypeCode")) {
                    string = "org.omg.CORBA.TypeCode";
                    break;
                }
                string = this.getJavaName(((IdlIdent)idlObject2).internalObject());
                break;
            }
            case 27: {
                if (((IdlValueBox)idlObject2).simple()) {
                    string = this.fullname(idlObject2);
                    break;
                }
                idlObject2.reset();
                string = this.getJavaName(idlObject2.current());
            }
        }
        return string;
    }

    private void createRTFFooter(PrintWriter printWriter) {
        printWriter.print("}");
    }

    private void write_index_entry(String string, String string2, String string3, PrintWriter printWriter) {
        printWriter.print("{\\xe {\\v " + string + "}");
        if (string2 != null) {
            printWriter.print("{\\rxe " + string2 + "}");
        }
        if (string3 != null) {
            printWriter.print("{\\txe see " + string3 + "}");
        }
        printWriter.print("}");
    }

    private void write_section_title(String string, IdlObject idlObject2, PrintWriter printWriter) {
        printWriter.print("{");
        this.write_model(this.section_title_model, printWriter);
        printWriter.println(string);
        printWriter.println("\\par }");
        this.write_index_entry(this.fullname(idlObject2), null, null, printWriter);
        printWriter.println("{\\pard}");
        printWriter.print("{");
        this.write_model(this.section_id_model, printWriter);
        printWriter.println("\\par");
        printWriter.println("CORBA ID = " + idlObject2.getId());
        printWriter.println("\\par }");
        printWriter.println("{\\par\\pard}");
    }

    private boolean is_deprecated(IdlObject idlObject2) {
        IdlComment idlComment = idlObject2.getComment();
        if (idlComment != null) {
            IdlCommentSection[] idlCommentSectionArray = idlComment.get_sections();
            int n = 0;
            while (n < idlCommentSectionArray.length) {
                if (idlCommentSectionArray[n].kind().value() == 6) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private void write_detail_title(String string, IdlObject idlObject2, PrintWriter printWriter) {
        printWriter.print("{\\li567");
        this.write_model(this.detail_title_model, printWriter);
        printWriter.println(string);
        printWriter.println("\\par }");
        this.write_index_entry(idlObject2.name(), null, this.fullname(idlObject2.upper()), printWriter);
        printWriter.println("{\\pard}");
        printWriter.print("{");
        this.write_model(this.detail_id_model, printWriter);
        printWriter.println("CORBA ID = " + idlObject2.getId());
        printWriter.println("\\par }");
        printWriter.println("{\\pard}");
        printWriter.print("{");
        this.write_model(this.detail_java_model, printWriter);
        printWriter.println("JAVA NAME = " + this.getJavaName(idlObject2));
        printWriter.println("\\par }");
        printWriter.println("{\\par}\\pard");
    }

    private void write_smalldetail_title(String string, IdlObject idlObject2, PrintWriter printWriter) {
        printWriter.print("{\\li567");
        this.write_model(this.detail_title_model, printWriter);
        printWriter.println(string);
        printWriter.println("\\par }");
        if (idlObject2.upper().upper() != null) {
            this.write_index_entry(idlObject2.name(), null, this.fullname(idlObject2.upper()), printWriter);
        }
        printWriter.println("{\\pard}");
        printWriter.print("{");
        this.write_model(this.detail_id_model, printWriter);
        printWriter.println("DETAILS AT = " + this.fullname(idlObject2));
        printWriter.println("\\par }");
        printWriter.println("{\\par}\\pard");
    }

    private IdlObject[] sort_description_by_name(Vector vector) {
        int n;
        IdlObject[] idlObjectArray;
        Vector<IdlObject[]> vector2 = new Vector<IdlObject[]>();
        int n2 = 0;
        while (n2 < vector.size()) {
            idlObjectArray = (IdlObject)vector.elementAt(n2);
            n = 0;
            int n3 = 0;
            while (n3 < vector2.size()) {
                if (this.fullname((IdlObject)idlObjectArray).toLowerCase().compareTo(this.fullname((IdlObject)vector2.elementAt(n3)).toLowerCase()) < 0) {
                    vector2.insertElementAt(idlObjectArray, n3);
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                vector2.addElement(idlObjectArray);
            }
            ++n2;
        }
        idlObjectArray = new IdlObject[vector2.size()];
        n = 0;
        while (n < vector2.size()) {
            idlObjectArray[n] = (IdlObject)vector2.elementAt(n);
            ++n;
        }
        return idlObjectArray;
    }

    private void sort_type_content(IdlObject idlObject2, content content2, boolean bl) {
        if (content2 == null) {
            content2 = new content();
        }
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (!idlObject2.current().included()) {
                switch (idlObject2.current().kind()) {
                    case 1: {
                        content2._module.addElement(idlObject2.current());
                        if (bl) break;
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 15: {
                        content2._interface.addElement(idlObject2.current());
                        if (bl) break;
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 28: {
                        content2._valuetype.addElement(idlObject2.current());
                        if (bl) break;
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 27: {
                        content2._valuebox.addElement(idlObject2.current());
                        break;
                    }
                    case 14: {
                        content2._exception.addElement(idlObject2.current());
                        break;
                    }
                    case 3: {
                        content2._struct.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 4: {
                        content2._union.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 2: {
                        content2._enum.addElement(idlObject2.current());
                        break;
                    }
                    case 13: {
                        content2._typedef.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 7: {
                        content2._const.addElement(idlObject2.current());
                        break;
                    }
                    case 25: {
                        content2._native.addElement(idlObject2.current());
                        break;
                    }
                    case 16: {
                        content2._operation.addElement(idlObject2.current());
                        break;
                    }
                    case 17: {
                        content2._attribute.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 29: {
                        content2._member.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 30: {
                        content2._factory.addElement(idlObject2.current());
                    }
                }
            }
            idlObject2.next();
        }
    }

    private content get_sorted_content(IdlObject idlObject2, boolean bl) {
        content content2 = new content();
        this.sort_type_content(idlObject2, content2, bl);
        content2._sorted_module = content2._module.size() != 0 ? this.sort_description_by_name(content2._module) : new IdlObject[0];
        content2._sorted_interface = content2._interface.size() != 0 ? this.sort_description_by_name(content2._interface) : new IdlObject[0];
        content2._sorted_valuetype = content2._valuetype.size() != 0 ? this.sort_description_by_name(content2._valuetype) : new IdlObject[0];
        content2._sorted_valuebox = content2._valuebox.size() != 0 ? this.sort_description_by_name(content2._valuebox) : new IdlObject[0];
        content2._sorted_exception = content2._exception.size() != 0 ? this.sort_description_by_name(content2._exception) : new IdlObject[0];
        content2._sorted_struct = content2._struct.size() != 0 ? this.sort_description_by_name(content2._struct) : new IdlObject[0];
        content2._sorted_union = content2._union.size() != 0 ? this.sort_description_by_name(content2._union) : new IdlObject[0];
        content2._sorted_enum = content2._enum.size() != 0 ? this.sort_description_by_name(content2._enum) : new IdlObject[0];
        content2._sorted_typedef = content2._typedef.size() != 0 ? this.sort_description_by_name(content2._typedef) : new IdlObject[0];
        content2._sorted_const = content2._const.size() != 0 ? this.sort_description_by_name(content2._const) : new IdlObject[0];
        content2._sorted_native = content2._native.size() != 0 ? this.sort_description_by_name(content2._native) : new IdlObject[0];
        content2._sorted_operation = content2._operation.size() != 0 ? this.sort_description_by_name(content2._operation) : new IdlObject[0];
        content2._sorted_attribute = content2._attribute.size() != 0 ? this.sort_description_by_name(content2._attribute) : new IdlObject[0];
        content2._sorted_member = content2._member.size() != 0 ? this.sort_description_by_name(content2._member) : new IdlObject[0];
        content2._sorted_factory = content2._factory.size() != 0 ? this.sort_description_by_name(content2._factory) : new IdlObject[0];
        return content2;
    }

    private String get_summary_description(IdlObject idlObject2) {
        IdlComment idlComment = idlObject2.getComment();
        String string = null;
        if (idlComment != null && (string = idlComment.get_description()) != null) {
            if (string.indexOf(".") != -1) {
                return string.substring(0, string.indexOf(".") + 1);
            }
            if (string.indexOf("\n\n") != -1) {
                return string.substring(0, string.indexOf("\n\n") + 1);
            }
            return string;
        }
        return "";
    }

    private void write_begin_table(String string, PrintWriter printWriter) {
        printWriter.print("\\li709 ");
        printWriter.print("\\trowd ");
        printWriter.print("\\trgaph70\\trrh296\\trleft567\\trkeep ");
        this.write_cell_border(this.summary_title_model, printWriter);
        this.write_cell_color(this.summary_title_model, printWriter);
        printWriter.print("\\cellx9498\\pard \\intbl");
        printWriter.print("{");
        this.write_cell_model(this.summary_title_model, printWriter);
        printWriter.print(string);
        printWriter.print("\\cell}");
        printWriter.print("{\\row}");
    }

    private void write_begin_table_inheritance(String string, PrintWriter printWriter) {
        printWriter.print("\\li709 ");
        printWriter.print("\\trowd ");
        printWriter.print("\\trgaph70\\trrh296\\trleft567\\trkeep ");
        this.write_cell_border(this.summary_inher_title_model, printWriter);
        this.write_cell_color(this.summary_inher_title_model, printWriter);
        printWriter.print("\\cellx9498\\pard \\intbl");
        printWriter.print("{");
        this.write_cell_model(this.summary_inher_title_model, printWriter);
        printWriter.print(string);
        printWriter.print("\\cell}");
        printWriter.print("{\\row}");
    }

    private void write_table_entry(String string, String string2, PrintWriter printWriter) {
        printWriter.print("\\li709 ");
        printWriter.print("\\trowd ");
        printWriter.print("\\trgaph70\\trrh286\\trleft567\\trkeep ");
        this.write_cell_border(this.summary_entry_name_model, printWriter);
        this.write_cell_color(this.summary_entry_name_model, printWriter);
        printWriter.print(" \\cellx2693\\clvertalt ");
        this.write_cell_border(this.summary_entry_desc_model, printWriter);
        this.write_cell_color(this.summary_entry_desc_model, printWriter);
        printWriter.print("\\cellx9498\\pard \\fi-72\\li72\\intbl");
        printWriter.print("{");
        this.write_cell_model(this.summary_entry_name_model, printWriter);
        printWriter.print(string);
        printWriter.print("\\cell} ");
        printWriter.print("\\fi-72\\li72\\intbl {");
        this.write_cell_model(this.summary_entry_desc_model, printWriter);
        printWriter.print(string2);
        printWriter.print("\\cell}");
        printWriter.print("{\\row}");
    }

    private void write_one_cell(String string, PrintWriter printWriter) {
        printWriter.print("\\li709 ");
        printWriter.print("\\trowd ");
        printWriter.print("\\trgaph70\\trrh286\\trleft567\\trkeep ");
        this.write_cell_border(this.summary_inher_list_model, printWriter);
        this.write_cell_color(this.summary_inher_list_model, printWriter);
        printWriter.print("\\cellx9498\\pard \\intbl");
        printWriter.print("{");
        this.write_cell_model(this.summary_inher_list_model, printWriter);
        printWriter.print(string);
        printWriter.print("\\cell}");
        printWriter.print("{\\row}");
    }

    private void write_end_table(PrintWriter printWriter) {
        printWriter.println("\\pard \\plain { \\par \\pard }");
    }

    private void translateSubTypeDetails(IdlObject idlObject2, IdlObject[] idlObjectArray, PrintWriter printWriter, String string) {
        this.write_begin_table(string, printWriter);
        this.write_end_table(printWriter);
        int n = 0;
        while (n < idlObjectArray.length) {
            switch (idlObjectArray[n].kind()) {
                case 27: {
                    this.translateValueBox(idlObjectArray[n], printWriter);
                    break;
                }
                case 14: {
                    this.translateException(idlObjectArray[n], printWriter);
                    break;
                }
                case 3: {
                    this.translateStruct(idlObjectArray[n], printWriter);
                    break;
                }
                case 4: {
                    this.translateUnion(idlObjectArray[n], printWriter);
                    break;
                }
                case 2: {
                    this.translateEnum(idlObjectArray[n], printWriter);
                    break;
                }
                case 13: {
                    this.translateTypeDef(idlObjectArray[n], printWriter);
                    break;
                }
                case 7: {
                    this.translateConstant(idlObjectArray[n], printWriter);
                    break;
                }
                case 25: {
                    this.translateNative(idlObjectArray[n], printWriter);
                    break;
                }
                case 16: {
                    this.translateOperation(idlObjectArray[n], printWriter);
                    break;
                }
                case 17: {
                    this.translateAttribute(idlObjectArray[n], printWriter);
                    break;
                }
                case 29: {
                    this.translateStateMember(idlObjectArray[n], printWriter);
                    break;
                }
                case 30: {
                    this.translateFactory(idlObjectArray[n], printWriter);
                    break;
                }
                case 15: {
                    this.translateInterfaceDetail(idlObjectArray[n], printWriter);
                    break;
                }
                case 1: {
                    this.translateModuleDetail(idlObjectArray[n], printWriter);
                    break;
                }
                case 28: {
                    this.translateValueDetail(idlObjectArray[n], printWriter);
                }
            }
            ++n;
        }
    }

    private void translateSubTypeSummary(IdlObject idlObject2, IdlObject[] idlObjectArray, PrintWriter printWriter, String string) {
        this.write_begin_table(string, printWriter);
        int n = 0;
        while (n < idlObjectArray.length) {
            String string2 = this.get_summary_description(idlObjectArray[n]);
            if (this.is_deprecated(idlObjectArray[n])) {
                string2 = "{\b deprecated} - " + string2;
            }
            this.write_table_entry(idlObjectArray[n].name(), string2, printWriter);
            ++n;
        }
        this.write_end_table(printWriter);
    }

    public void translateContentTable(IdlObject idlObject2, PrintWriter printWriter, int n) {
        content content2 = this.get_sorted_content(idlObject2, true);
        if (n == 1 || n == 3) {
            if (content2._sorted_module.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_module, printWriter, "Module Summary");
            }
            if (content2._sorted_interface.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_interface, printWriter, "Interface Summary");
            }
            if (content2._sorted_valuetype.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_valuetype, printWriter, "ValueType Summary");
            }
            if (content2._sorted_valuebox.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_valuebox, printWriter, "ValueBox Summary");
            }
            if (content2._sorted_exception.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_exception, printWriter, "Exception Summary");
            }
            if (content2._sorted_struct.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_struct, printWriter, "Struct Summary");
            }
            if (content2._sorted_union.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_union, printWriter, "Union Summary");
            }
            if (content2._sorted_enum.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_enum, printWriter, "Enum Summary");
            }
            if (content2._sorted_typedef.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_typedef, printWriter, "TypeDef Summary");
            }
            if (content2._sorted_const.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_const, printWriter, "Const Summary");
            }
            if (content2._sorted_native.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_native, printWriter, "Native Summary");
            }
            if (content2._sorted_operation.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_operation, printWriter, "Operation Summary");
            }
            if (content2._sorted_attribute.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_attribute, printWriter, "Attribute Summary");
            }
            if (content2._sorted_member.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_member, printWriter, "Member Summary");
            }
            if (content2._sorted_factory.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_factory, printWriter, "Factory Summary");
            }
        }
        if (n == 2 || n == 3) {
            if (content2._sorted_module.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_module, printWriter, "Module Details");
            }
            if (content2._sorted_interface.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_interface, printWriter, "Interface Details");
            }
            if (content2._sorted_valuetype.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_valuetype, printWriter, "ValueType Details");
            }
            if (content2._sorted_valuebox.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_valuebox, printWriter, "ValueBox Details");
            }
            if (content2._sorted_exception.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_exception, printWriter, "Exception Details");
            }
            if (content2._sorted_struct.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_struct, printWriter, "Struct Details");
            }
            if (content2._sorted_union.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_union, printWriter, "Union Details");
            }
            if (content2._sorted_enum.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_enum, printWriter, "Enum Details");
            }
            if (content2._sorted_typedef.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_typedef, printWriter, "TypeDef Details");
            }
            if (content2._sorted_const.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_const, printWriter, "Const Details");
            }
            if (content2._sorted_native.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_native, printWriter, "Native Details");
            }
            if (content2._sorted_operation.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_operation, printWriter, "Operation Details");
            }
            if (content2._sorted_attribute.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_attribute, printWriter, "Attribute Details");
            }
            if (content2._sorted_member.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_member, printWriter, "Member Details");
            }
            if (content2._sorted_factory.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_factory, printWriter, "Factory Details");
            }
        }
    }

    private String get_description(IdlObject idlObject2) {
        IdlComment idlComment = idlObject2.getComment();
        if (idlComment != null && idlComment.get_description() != null) {
            return idlComment.get_description();
        }
        return "";
    }

    private IdlCommentSection[] get_sections(IdlCommentSection[] idlCommentSectionArray, int n) {
        Vector<IdlCommentSection> vector = new Vector<IdlCommentSection>();
        int n2 = 0;
        while (n2 < idlCommentSectionArray.length) {
            if (idlCommentSectionArray[n2].kind().value() == n) {
                vector.addElement(idlCommentSectionArray[n2]);
            }
            ++n2;
        }
        IdlCommentSection[] idlCommentSectionArray2 = new IdlCommentSection[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            idlCommentSectionArray2[n3] = (IdlCommentSection)vector.elementAt(n3);
            ++n3;
        }
        return idlCommentSectionArray2;
    }

    private void translateHierarchy(IdlObject idlObject2, PrintWriter printWriter) {
        Vector<IdlObject> vector = new Vector<IdlObject>();
        IdlObject idlObject3 = idlObject2;
        while (idlObject3 != null) {
            switch (idlObject3.kind()) {
                case 1: 
                case 15: 
                case 18: 
                case 28: 
                case 33: {
                    vector.addElement(idlObject3);
                }
            }
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
        }
        printWriter.print("{\\li709 ");
        this.write_model(this.section_hierarchy_model, printWriter);
        if (vector.size() > 1) {
            String string = "";
            int n = vector.size() - 1;
            while (n >= 0) {
                string = string + "   ";
                if (n == 0) {
                    printWriter.println("{\\b " + this.fullname((IdlObject)vector.elementAt(n)) + "}\\par");
                } else {
                    printWriter.println(this.fullname((IdlObject)vector.elementAt(n)) + "\\par");
                }
                if (n != 0) {
                    printWriter.println(string + "|\\par");
                    printWriter.print(string + "+--");
                }
                --n;
            }
            printWriter.print("\\par");
        }
        printWriter.println("} \\pard\\plain ");
    }

    private String removeTab(String string) {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (string.charAt(n2) != '\t') {
                byArray[n++] = (byte)string.charAt(n2);
            }
            ++n2;
        }
        return new String(byArray, 0, n);
    }

    private void write_section(IdlCommentSection[] idlCommentSectionArray, int n, String string, PrintWriter printWriter, boolean bl) {
        IdlCommentSection[] idlCommentSectionArray2 = this.get_sections(idlCommentSectionArray, n);
        String string2 = "";
        String string3 = "";
        if (idlCommentSectionArray2.length != 0) {
            printWriter.println("\\li800 {\\b " + string + "\\par}");
            printWriter.println("\\li1000 {");
            int n2 = 0;
            while (n2 < idlCommentSectionArray2.length) {
                string2 = idlCommentSectionArray2[n2].get_description().trim();
                if (bl) {
                    printWriter.print("{");
                    this.write_model(this.detail_highlight_model, printWriter);
                    int n3 = string2.indexOf(" ");
                    int n4 = string2.indexOf("\t");
                    if (n3 == -1 && n4 != -1) {
                        n3 = n4;
                    } else if (n4 != -1 && n4 < n3) {
                        n3 = n4;
                    }
                    if (n3 != -1) {
                        string3 = string2.substring(0, n3);
                        string2 = string2.substring(n3 + 1);
                        printWriter.print(string3);
                    }
                    printWriter.print("} - ");
                }
                printWriter.println(this.removeTab(string2) + "\\par");
                ++n2;
            }
            printWriter.println("}{\\par}\\pard");
        }
    }

    private void write_description(IdlObject idlObject2, PrintWriter printWriter, model model2) {
        IdlComment idlComment = idlObject2.getComment();
        printWriter.print("{\\li567");
        this.write_model(model2, printWriter);
        printWriter.println(this.get_description(idlObject2).trim() + "\\par\\par");
        if (idlComment != null) {
            IdlCommentSection[] idlCommentSectionArray = idlComment.get_sections();
            this.write_section(idlCommentSectionArray, 3, "Parameter", printWriter, true);
            this.write_section(idlCommentSectionArray, 4, "Return", printWriter, false);
            this.write_section(idlCommentSectionArray, 1, "Exception", printWriter, true);
            this.write_section(idlCommentSectionArray, 5, "See", printWriter, true);
            this.write_section(idlCommentSectionArray, 6, "Deprecated", printWriter, false);
        }
        printWriter.println("\\par} \\pard\\plain");
    }

    private void translateEnum(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        IdlEnumMember idlEnumMember = null;
        printWriter.print("enum " + idlObject2.name() + "\\par");
        printWriter.print("\\{\\par");
        printWriter.println("{\\li800");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlEnumMember = (IdlEnumMember)idlObject2.current();
            printWriter.print(idlEnumMember.name());
            idlObject2.next();
            if (!idlObject2.end()) {
                printWriter.print(",");
            }
            printWriter.println("\\par");
        }
        printWriter.print("}");
        printWriter.print("\\}\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateStruct(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        IdlStructMember idlStructMember2 = null;
        printWriter.print("struct " + idlObject2.name() + "\\par");
        printWriter.print("\\{\\par");
        printWriter.println("{\\li800");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            idlStructMember2.reset();
            printWriter.print(this.translateType(idlStructMember2.current(), "", idlStructMember2.name(), true, idlObject2));
            idlObject2.next();
            printWriter.print(";");
            printWriter.println("\\par");
        }
        printWriter.print("}");
        printWriter.print("\\}\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateException(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        IdlStructMember idlStructMember2 = null;
        printWriter.print("exception " + idlObject2.name() + "\\par");
        printWriter.print("\\{\\par");
        printWriter.println("{\\li800");
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            idlStructMember2.reset();
            printWriter.print(this.translateType(idlStructMember2.current(), "", idlStructMember2.name(), true, idlObject2));
            idlObject2.next();
            printWriter.print(";");
            printWriter.println("\\par");
        }
        printWriter.print("}");
        printWriter.print("\\}\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateUnion(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        IdlUnionMember idlUnionMember2 = null;
        idlObject2.reset();
        idlUnionMember2 = (IdlUnionMember)idlObject2.current();
        idlUnionMember2.reset();
        printWriter.print("union " + idlObject2.name() + " switch ( " + this.translateType(idlUnionMember2.current(), "", idlUnionMember2.name(), false, idlObject2) + " )" + "\\par");
        printWriter.print("\\{\\par");
        int n = ((IdlUnion)idlObject2).index();
        int n2 = 0;
        idlObject2.next();
        while (!idlObject2.end()) {
            idlUnionMember2 = (IdlUnionMember)idlObject2.current();
            printWriter.print("\\li800");
            printWriter.print("{");
            idlUnionMember2.reset();
            if (n2 == n) {
                printWriter.print("default : \\par }");
            } else {
                printWriter.print("case " + this.adaptExpression(idlUnionMember2.getExpression()) + ": \\par }");
            }
            printWriter.println("\\li1200 {");
            printWriter.print(this.translateType(idlUnionMember2.current(), "", idlUnionMember2.name(), true, idlObject2));
            idlObject2.next();
            printWriter.print(";");
            printWriter.print("\\par }");
            ++n2;
        }
        printWriter.print("\\li567 \\}\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private String correctIdentifier(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        String string3 = null;
        while ((n = string.indexOf(".", n2)) != n2) {
            if (n == -1) {
                string3 = string.substring(n2, string.length());
                vector.addElement(string3);
                break;
            }
            string3 = string.substring(n2, n);
            vector.addElement(string3);
            n2 = n + 1;
        }
        n3 = 0;
        while (n3 < vector.size()) {
            string3 = (String)vector.elementAt(n3);
            if (this._root.isDefined(string3, false)) break;
            ++n3;
        }
        int n4 = n3;
        while (n4 < vector.size()) {
            string2 = string2 + (String)vector.elementAt(n4);
            if (n4 + 1 < vector.size()) {
                string2 = string2 + "::";
            }
            ++n4;
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    private String adaptExpression(String var1_1) {
        var2_2 = new char[500];
        var3_3 = "";
        var4_4 = 0;
        var5_5 = 0;
        while (var4_4 != var1_1.length()) {
            block7: {
                block8: {
                    if (!Character.isDigit(var1_1.charAt(var4_4))) break block7;
                    if (var1_1.charAt(var4_4) != '0' || var4_4 + 1 >= var1_1.length() || var1_1.charAt(var4_4 + 1) != 'X' && var1_1.charAt(var4_4 + 1) != 'x') ** GOTO lbl15
                    var2_2[var5_5++] = var1_1.charAt(var4_4++);
                    var2_2[var5_5++] = var1_1.charAt(var4_4++);
                    while (var4_4 < var1_1.length() && (Character.isDigit(var1_1.charAt(var4_4)) || var1_1.charAt(var4_4) >= 'A' && var1_1.charAt(var4_4) <= 'F' || var1_1.charAt(var4_4) >= 'a' && var1_1.charAt(var4_4) <= 'f')) {
                        var2_2[var5_5++] = var1_1.charAt(var4_4++);
                    }
                    break block8;
lbl-1000:
                    // 1 sources

                    {
                        var2_2[var5_5++] = var1_1.charAt(var4_4++);
lbl15:
                        // 2 sources

                        ** while (var4_4 < var1_1.length() && (Character.isDigit((char)var1_1.charAt((int)var4_4)) || var1_1.charAt((int)var4_4) == '.'))
                    }
                }
                var2_2[var5_5] = '\u0000';
                var3_3 = var3_3 + new String(var2_2, 0, var5_5);
                var5_5 = 0;
                continue;
            }
            if (Character.isLetter(var1_1.charAt(var4_4))) {
                while (var4_4 < var1_1.length() && (Character.isLetterOrDigit(var1_1.charAt(var4_4)) || var1_1.charAt(var4_4) == '.' || var1_1.charAt(var4_4) == '_')) {
                    var2_2[var5_5++] = var1_1.charAt(var4_4++);
                }
                var2_2[var5_5] = '\u0000';
                var3_3 = var3_3 + this.correctIdentifier(new String(var2_2, 0, var5_5));
                var5_5 = 0;
                continue;
            }
            if (var1_1.charAt(var4_4) == '\"') {
                ++var4_4;
                while (var1_1.charAt(var4_4) != '\"') {
                    var2_2[var5_5++] = var1_1.charAt(var4_4++);
                }
                var2_2[var5_5] = '\u0000';
                var3_3 = var3_3 + "\"" + new String(var2_2, 0, var5_5) + "\"";
                var5_5 = 0;
                ++var4_4;
                continue;
            }
            var2_2[0] = var1_1.charAt(var4_4++);
            var2_2[1] = '\u0000';
            var3_3 = var3_3 + new String(var2_2, 0, 1);
        }
        return var3_3;
    }

    public void translateFactory(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        printWriter.print("factory " + idlObject2.name() + "(");
        idlObject2.reset();
        while (!idlObject2.end()) {
            printWriter.print("in ");
            idlObject2.current().reset();
            printWriter.print(this.translateType(idlObject2.current().current(), "", idlObject2.current().name(), true, idlObject2));
            idlObject2.next();
            if (idlObject2.end()) continue;
            printWriter.print(", ");
        }
        printWriter.print(");");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    public void translateStateMember(IdlObject idlObject2, PrintWriter printWriter) {
        IdlStateMember idlStateMember = null;
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        idlStateMember = (IdlStateMember)idlObject2;
        idlStateMember.reset();
        if (idlStateMember.public_member()) {
            printWriter.print("public ");
        } else {
            printWriter.print("private ");
        }
        printWriter.print(this.translateType(idlStateMember.current(), "", idlStateMember.name(), true, idlObject2));
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateConstant(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        printWriter.print("Const ");
        idlObject2.reset();
        String string = this.translateType(idlObject2.current(), "", idlObject2.name(), false, idlObject2);
        printWriter.print(string + " " + idlObject2.name() + " = " + this.adaptExpression(((IdlConst)idlObject2).expression()) + ";\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateTypeDef(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        printWriter.print("typedef ");
        idlObject2.reset();
        String string = this.translateType(idlObject2.current(), "", idlObject2.name(), true, idlObject2);
        printWriter.print(string + ";\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateValueBox(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        printWriter.print("valuetype " + idlObject2.name());
        idlObject2.reset();
        String string = this.translateType(idlObject2.current(), "", idlObject2.name(), false, idlObject2);
        printWriter.print(" " + string + ";\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateNative(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        printWriter.print("native " + idlObject2.name() + "\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateInterfaceDetail(IdlObject idlObject2, PrintWriter printWriter) {
        IdlInterface idlInterface2 = (IdlInterface)idlObject2;
        this.write_smalldetail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        if (idlInterface2.abstract_interface()) {
            printWriter.print("abstract ");
        }
        printWriter.println("interface " + idlObject2.name());
        Vector vector = idlInterface2.getInheritance();
        if (vector.size() != 0) {
            printWriter.print(" :\\par");
            int n = 0;
            while (n < vector.size()) {
                printWriter.print("\\li800 { " + this.fullname((IdlInterface)vector.elementAt(n)));
                if (n + 1 < vector.size()) {
                    printWriter.print(",");
                }
                printWriter.println("\\par}");
                ++n;
            }
        } else {
            printWriter.print("\\par");
        }
        printWriter.println("}{\\par} \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateModuleDetail(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_smalldetail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        printWriter.print("module " + idlObject2.name() + "\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateValueDetail(IdlObject idlObject2, PrintWriter printWriter) {
        IdlValue idlValue2 = (IdlValue)idlObject2;
        this.write_smalldetail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        if (idlValue2.abstract_value()) {
            printWriter.print("abstract ");
        }
        if (idlValue2.custom_value()) {
            printWriter.print("abstract ");
        }
        printWriter.println("valuetype " + idlObject2.name());
        Vector vector = idlValue2.getInheritanceList();
        if (vector.size() != 0) {
            printWriter.print(" :\\par");
            int n = 0;
            while (n < vector.size()) {
                printWriter.print("\\li800 { ");
                if (((IdlValueInheritance)vector.elementAt(n)).truncatable_member()) {
                    printWriter.print("truncatable ");
                }
                printWriter.print(this.fullname((IdlInterface)vector.elementAt(n)));
                if (n + 1 < vector.size()) {
                    printWriter.print(",");
                }
                printWriter.println("\\par}");
                ++n;
            }
        } else {
            printWriter.print("\\par");
        }
        printWriter.println("}{\\par} \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    public void translateAttribute(IdlObject idlObject2, PrintWriter printWriter) {
        IdlAttribute idlAttribute2 = (IdlAttribute)idlObject2;
        idlAttribute2.reset();
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        if (idlAttribute2.readOnly()) {
            printWriter.print("readonly ");
        }
        printWriter.print("attribute ");
        printWriter.println(this.translateType(idlAttribute2.current(), "", idlAttribute2.name(), true, idlObject2) + "\\par");
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    public void translateOperation(IdlObject idlObject2, PrintWriter printWriter) {
        IdlObject idlObject3;
        IdlOp idlOp = (IdlOp)idlObject2;
        this.write_detail_title(idlObject2.name(), idlObject2, printWriter);
        printWriter.print("{\\li567");
        this.write_model(this.detail_desc_model, printWriter);
        if (idlOp.oneway()) {
            printWriter.print("oneway ");
        }
        idlOp.reset();
        printWriter.print(this.translateType(idlOp.current(), "", idlOp.name(), false, idlObject2));
        idlOp.next();
        printWriter.print(" " + idlOp.name() + "(");
        while (!idlOp.end()) {
            if (idlOp.current().kind() != 19) break;
            printWriter.print("\\par");
            printWriter.print("\\li1000" + this.translateParameter(idlOp.current(), ""));
            idlOp.next();
            if (idlOp.end() || idlOp.current().kind() != 19) continue;
            printWriter.print(", ");
        }
        printWriter.print(")\\par");
        if (!idlOp.end() && idlOp.current().kind() == 20) {
            printWriter.print("\\li800{raises (\\par}");
            idlObject3 = (IdlRaises)idlOp.current();
            idlObject3.reset();
            while (!idlObject3.end()) {
                printWriter.print("\\li1000 {" + this.fullname(idlObject3.current()));
                idlObject3.next();
                if (!idlObject3.end()) {
                    printWriter.print(", \\par}");
                    continue;
                }
                printWriter.print(")\\par}");
            }
            idlOp.next();
        }
        if (!idlOp.end() && idlOp.current().kind() == 21) {
            printWriter.print("\\li800{");
            printWriter.print("context (");
            idlObject3 = (IdlContext)idlOp.current();
            Vector vector = ((IdlContext)idlObject3).getValues();
            int n = 0;
            while (n < vector.size()) {
                printWriter.print("\"" + (String)vector.elementAt(n) + "\"");
                if (n + 1 < vector.size()) {
                    printWriter.print(", ");
                }
                ++n;
            }
            printWriter.print(")\\par}");
        }
        printWriter.print("\\par } \\pard");
        this.write_description(idlObject2, printWriter, this.detail_comment_model);
    }

    private void translateModule(IdlObject idlObject2, PrintWriter printWriter) {
        this.write_section_title("Module " + this.fullname(idlObject2), idlObject2, printWriter);
        this.translateHierarchy(idlObject2, printWriter);
        this.write_description(idlObject2, printWriter, this.section_desc_model);
        this.translateContentTable(idlObject2, printWriter, 3);
        printWriter.println("{\\par} \\pard");
        this.translateDescription(idlObject2, printWriter);
    }

    public void translateSummary(String string, PrintWriter printWriter) {
        printWriter.print("{");
        this.write_model(this.title_model, printWriter);
        printWriter.print(string);
        printWriter.print("\\par}{\\par\\par\\par}\\pard");
        this.translateContentTable(this._root, printWriter, 3);
        printWriter.print("{\\par\\par}\\pard");
    }

    private void translateInfo(PrintWriter printWriter) {
        printWriter.print("{");
        printWriter.print("\\author IDL to RTF");
        printWriter.println("}");
    }

    private void translateHeader(String string, PrintWriter printWriter) {
        printWriter.print("{\\header ");
        this.write_model(this.header_model, printWriter);
        printWriter.println("{" + string + "}{\\par } }");
    }

    private void translateFooter(String string, PrintWriter printWriter) {
        printWriter.print("{\\footer");
        this.write_model(this.footer_model, printWriter);
        printWriter.println("{" + string + "}{\\par } }");
    }

    private void translateInterface(IdlObject idlObject2, PrintWriter printWriter) {
        String string = null;
        IdlInterface idlInterface2 = (IdlInterface)idlObject2;
        this.write_section_title("Interface " + this.fullname(idlObject2), idlObject2, printWriter);
        this.translateHierarchy(idlObject2, printWriter);
        this.write_description(idlObject2, printWriter, this.section_desc_model);
        printWriter.print("{\\li567");
        this.write_model(this.summary_inher_desc_model, printWriter);
        if (idlInterface2.abstract_interface()) {
            printWriter.print("abstract ");
        }
        printWriter.println("interface " + idlObject2.name());
        Vector vector = idlInterface2.getInheritance();
        if (vector.size() != 0) {
            printWriter.print(" :\\par");
            int n = 0;
            while (n < vector.size()) {
                printWriter.print("\\li800 { " + this.fullname((IdlInterface)vector.elementAt(n)));
                if (n + 1 < vector.size()) {
                    printWriter.print(",");
                }
                printWriter.println("\\par}");
                ++n;
            }
        } else {
            printWriter.print("\\par");
        }
        printWriter.println("}{\\par} \\pard");
        this.translateContentTable(idlObject2, printWriter, 1);
        IdlInterface idlInterface3 = null;
        if (vector.size() != 0) {
            int n = 0;
            while (n < vector.size()) {
                idlInterface3 = (IdlInterface)vector.elementAt(n);
                if (!idlInterface3.included()) {
                    this.write_begin_table_inheritance("Attributes and operations inherited from " + this.fullname(idlInterface3), printWriter);
                    string = "";
                    idlInterface3.reset();
                    while (!idlInterface3.end()) {
                        switch (idlInterface3.current().kind()) {
                            case 16: 
                            case 17: {
                                if (!string.equals("")) {
                                    string = string + ", ";
                                }
                                string = string + idlInterface3.current().name();
                            }
                        }
                        idlInterface3.next();
                    }
                    this.write_one_cell(string, printWriter);
                    this.write_end_table(printWriter);
                }
                ++n;
            }
        }
        this.translateContentTable(idlObject2, printWriter, 2);
        printWriter.println("{\\par} \\pard");
        this.translateDescription(idlObject2, printWriter);
    }

    private void translateValueType(IdlObject idlObject2, PrintWriter printWriter) {
        String string = null;
        IdlValue idlValue2 = (IdlValue)idlObject2;
        this.write_section_title("Valuetype " + this.fullname(idlObject2), idlObject2, printWriter);
        this.translateHierarchy(idlObject2, printWriter);
        this.write_description(idlObject2, printWriter, this.section_desc_model);
        printWriter.print("{\\li567");
        this.write_model(this.summary_inher_desc_model, printWriter);
        if (idlValue2.abstract_value()) {
            printWriter.print("abstract ");
        }
        if (idlValue2.custom_value()) {
            printWriter.print("abstract ");
        }
        printWriter.println("valuetype " + idlObject2.name());
        Vector vector = idlValue2.getInheritanceList();
        if (vector.size() != 0) {
            printWriter.print(" :\\par");
            int n = 0;
            while (n < vector.size()) {
                printWriter.print("\\li800 { ");
                if (((IdlValueInheritance)vector.elementAt(n)).truncatable_member()) {
                    printWriter.print("truncatable ");
                }
                printWriter.print(this.fullname((IdlInterface)vector.elementAt(n)));
                if (n + 1 < vector.size()) {
                    printWriter.print(",");
                }
                printWriter.println("\\par}");
                ++n;
            }
        } else {
            printWriter.print("\\par");
        }
        printWriter.println("}{\\par} \\pard");
        this.translateContentTable(idlObject2, printWriter, 1);
        IdlValue idlValue3 = null;
        if (vector.size() != 0) {
            int n = 0;
            while (n < vector.size()) {
                idlValue3 = ((IdlValueInheritance)vector.elementAt(n)).getValue();
                if (!idlValue3.included()) {
                    this.write_begin_table_inheritance("Members, attributes and operations inherited from " + this.fullname(idlValue3), printWriter);
                    string = "";
                    idlValue3.reset();
                    while (!idlValue3.end()) {
                        switch (idlValue3.current().kind()) {
                            case 16: 
                            case 17: 
                            case 29: {
                                if (!string.equals("")) {
                                    string = string + ", ";
                                }
                                string = string + idlValue3.current().name();
                            }
                        }
                        idlValue3.next();
                    }
                    this.write_one_cell(string, printWriter);
                    this.write_end_table(printWriter);
                }
                ++n;
            }
        }
        this.translateContentTable(idlObject2, printWriter, 2);
        printWriter.println("{\\par} \\pard");
        this.translateDescription(idlObject2, printWriter);
    }

    private void translateDescription(IdlObject idlObject2, PrintWriter printWriter) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (!idlObject2.current().included()) {
                switch (idlObject2.current().kind()) {
                    case 1: {
                        this.translateModule(idlObject2.current(), printWriter);
                        break;
                    }
                    case 28: {
                        this.translateValueType(idlObject2.current(), printWriter);
                        break;
                    }
                    case 15: {
                        this.translateInterface(idlObject2.current(), printWriter);
                    }
                }
            }
            idlObject2.next();
        }
    }

    public void translateToRTF(IdlObject idlObject2, String string, String string2, String string3, String string4) {
        File file = null;
        this._root = idlObject2;
        file = IdlDoc.outdir != null ? new File(IdlDoc.outdir + File.separatorChar + string) : new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            System.out.println("Error : Unable to create " + file.getAbsolutePath());
            System.exit(0);
        }
        PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
        this.loadStyleSheet();
        this.createRTFHeader(printWriter);
        this.translateInfo(printWriter);
        this.translateHeader(string3, printWriter);
        this.translateFooter(string4, printWriter);
        this.translateSummary(string2, printWriter);
        this.translateDescription(idlObject2, printWriter);
        this.createRTFFooter(printWriter);
        try {
            printWriter.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

