/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.doc.html;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.doc.IdlDoc;
import org.openorb.compiler.doc.html.content;
import org.openorb.compiler.object.IdlArray;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlContext;
import org.openorb.compiler.object.IdlEnumMember;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlUnion;
import org.openorb.compiler.object.IdlUnionMember;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;

public class IdlToHTML {
    private int level = 0;
    private String prefix = "";
    private IdlObject _root;

    public String inversedPrefix(String string) {
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        String string2 = new String("");
        try {
            while (n != -1) {
                n = string.indexOf(46, n2);
                if (n == -1) continue;
                vector.addElement(new String(string.substring(n2, n)));
                n2 = n + 1;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        vector.addElement(new String(string.substring(n2, string.length())));
        int n3 = vector.size() - 1;
        while (n3 >= 0) {
            if (!string2.equals("")) {
                string2 = string2 + ".";
            }
            string2 = string2 + (String)vector.elementAt(n3);
            --n3;
        }
        return string2;
    }

    public File createDirectory(String string, File file) {
        boolean bl = false;
        char[] cArray = new char[string.length() + 20];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '.') {
                cArray[n++] = File.separator.charAt(0);
                bl = true;
            } else {
                cArray[n++] = string.charAt(n2);
            }
            ++n2;
        }
        String string2 = new String(cArray, 0, n);
        String string3 = file != null ? new String(file.getPath() + File.separator + string2) : string2;
        File file2 = new File(string3);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (bl) {
            IdlCompiler.packageName = string2;
        }
        return file2;
    }

    public void write_index_file(String string, File file) {
        PrintWriter printWriter = this.create_file("index", file);
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<!-- org.openorb, IDL to HTML generator  -->");
        printWriter.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        printWriter.println("<TITLE>");
        printWriter.println(string);
        printWriter.println("</TITLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<FRAMESET cols=\"20%,80%\">");
        printWriter.println("<FRAMESET rows=\"30%,70%\">");
        printWriter.println("<FRAME src=\"overview-frame.html\" name=\"moduleListFrame\">");
        printWriter.println("<FRAME src=\"alldescriptions-frame.html\" name=\"moduleFrame\">");
        printWriter.println("</FRAMESET>");
        printWriter.println("<FRAME src=\"overview-summary.html\" name=\"descriptionFrame\">");
        printWriter.println("</FRAMESET>");
        printWriter.println("<NOFRAMES>");
        printWriter.println("<H2>");
        printWriter.println("Frame Alert</H2>");
        printWriter.println("<P>");
        printWriter.println("This document is designed to be viewed using the frames feature. If you see this message, you are using a non-frame-capable web client.");
        printWriter.println("<BR> Link to <A HREF=\"overview-summary.html\">Non-frame version.</A></NOFRAMES>");
        printWriter.println("</HTML>");
        printWriter.close();
    }

    public void write_overview_file(IdlObject idlObject2, String string, File file) {
        PrintWriter printWriter = this.create_file("overview-frame", file);
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<!-- org.openorb, IDL to HTML generator  -->");
        printWriter.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        printWriter.println("<TITLE>");
        printWriter.println(string + " : Overview");
        printWriter.println("</TITLE>");
        printWriter.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet.css\" TITLE=\"Style\">");
        printWriter.println("<SCRIPT LANGUAGE=\"JavaScript\">");
        printWriter.println("<!-- ");
        printWriter.println("function goTo(file1,file2)");
        printWriter.println("{");
        printWriter.println("window.parent.frames['moduleFrame'].location=file1;");
        printWriter.println("window.parent.frames['descriptionFrame'].location=file2;");
        printWriter.println("return");
        printWriter.println("}");
        printWriter.println("//-->");
        printWriter.println("</SCRIPT>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY BGCOLOR=\"white\">");
        printWriter.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        printWriter.println("<TR>");
        printWriter.println("<TD NOWRAP><FONT size=\"+1\" ID=\"FrameTitleFont\">");
        printWriter.println("<B><b>" + string + "</b><br><font size=\"-1\"></font></B></FONT></TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        printWriter.println("<TR>");
        printWriter.println("<TD NOWRAP><FONT ID=\"FrameItemFont\"><A HREF=\"JavaScript:goTo('alldescriptions-frame.html', 'overview-summary.html')\">All Descriptions</A></FONT>");
        printWriter.println("<P>");
        printWriter.println("<FONT size=\"+1\" ID=\"FrameHeadingFont\">");
        printWriter.println("Modules</FONT>");
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (!idlObject2.current().included() && idlObject2.current().kind() == 1) {
                printWriter.println("<BR>");
                printWriter.println("<FONT ID=\"FrameItemFont\"><A HREF=\"JavaScript:goTo('" + idlObject2.current().name() + "/alldescriptions-frame.html', '" + idlObject2.current().name() + "/" + idlObject2.current().name() + ".html')\">" + idlObject2.current().name() + "</A></FONT>");
            }
            idlObject2.next();
        }
        printWriter.println("</TABLE>");
        printWriter.close();
    }

    public void write_description_entry(String string, String string2, PrintWriter printWriter) {
        printWriter.println("<A HREF=\"" + string2 + "\" TARGET=\"descriptionFrame\"><I>" + string + "</I></A>");
        printWriter.println("<BR>");
    }

    public void write_description_entries(IdlObject idlObject2, IdlObject[] idlObjectArray, PrintWriter printWriter, String string) {
        printWriter.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        printWriter.println("<TR>");
        printWriter.println("<TD NOWRAP><FONT size=\"+1\" ID=\"FrameHeadingFont\">");
        printWriter.println(string + "</FONT>&nbsp;");
        printWriter.println("<FONT ID=\"FrameItemFont\">");
        printWriter.println("<BR>");
        int n = 0;
        while (n < idlObjectArray.length) {
            this.write_description_entry(idlObjectArray[n].name(), this.get_link(idlObjectArray[n], idlObject2), printWriter);
            ++n;
        }
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
    }

    public void write_description_content(IdlObject idlObject2, PrintWriter printWriter) {
        content content2 = this.get_sorted_content(idlObject2, true);
        if (content2._sorted_module.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_module, printWriter, "Module");
        }
        if (content2._sorted_interface.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_interface, printWriter, "Interface");
        }
        if (content2._sorted_valuetype.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_valuetype, printWriter, "ValueType");
        }
        if (content2._sorted_valuebox.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_valuebox, printWriter, "ValueBox");
        }
        if (content2._sorted_exception.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_exception, printWriter, "Exception");
        }
        if (content2._sorted_struct.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_struct, printWriter, "Struct");
        }
        if (content2._sorted_union.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_union, printWriter, "Union");
        }
        if (content2._sorted_enum.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_enum, printWriter, "Enum");
        }
        if (content2._sorted_typedef.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_typedef, printWriter, "TypeDef");
        }
        if (content2._sorted_const.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_const, printWriter, "Const");
        }
        if (content2._sorted_native.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_native, printWriter, "Native");
        }
        if (content2._sorted_operation.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_operation, printWriter, "Operation");
        }
        if (content2._sorted_attribute.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_attribute, printWriter, "Attribute");
        }
        if (content2._sorted_member.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_member, printWriter, "Member");
        }
        if (content2._sorted_factory.length != 0) {
            this.write_description_entries(idlObject2, content2._sorted_factory, printWriter, "Factory");
        }
    }

    public void write_alldescriptions_file(String string, File file, IdlObject idlObject2) {
        PrintWriter printWriter = this.create_file("alldescriptions-frame", file);
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<!-- org.openorb, IDL to HTML generator  -->");
        printWriter.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        printWriter.println("<TITLE>");
        printWriter.println("All Descriptions");
        printWriter.println("</TITLE>");
        printWriter.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet.css\" TITLE=\"Style\">");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY BGCOLOR=\"white\">");
        printWriter.println("<FONT size=\"+1\" ID=\"FrameHeadingFont\">");
        printWriter.println("<A HREF=\"" + idlObject2.name() + ".html\" TARGET=\"descriptionFrame\"><I>" + this.fullname(idlObject2) + "</I></A>");
        printWriter.println("<BR>");
        this.write_description_content(idlObject2, printWriter);
        printWriter.close();
    }

    public void get_all_description_content(IdlObject idlObject2, Vector vector) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (!idlObject2.current().included()) {
                switch (idlObject2.current().kind()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 13: 
                    case 14: 
                    case 25: 
                    case 27: {
                        vector.addElement(idlObject2.current());
                        break;
                    }
                    case 1: 
                    case 15: 
                    case 28: {
                        vector.addElement(idlObject2.current());
                        this.get_all_description_content(idlObject2.current(), vector);
                    }
                }
            }
            idlObject2.next();
        }
    }

    public IdlObject[] sort_description_by_name(Vector vector) {
        int n;
        IdlObject[] idlObjectArray;
        Vector<IdlObject[]> vector2 = new Vector<IdlObject[]>();
        int n2 = 0;
        while (n2 < vector.size()) {
            idlObjectArray = (IdlObject)vector.elementAt(n2);
            n = 0;
            int n3 = 0;
            while (n3 < vector2.size()) {
                if (this.fullname((IdlObject)idlObjectArray).toLowerCase().compareTo(this.fullname((IdlObject)vector2.elementAt(n3)).toLowerCase()) < 0) {
                    vector2.insertElementAt(idlObjectArray, n3);
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                vector2.addElement(idlObjectArray);
            }
            ++n2;
        }
        idlObjectArray = new IdlObject[vector2.size()];
        n = 0;
        while (n < vector2.size()) {
            idlObjectArray[n] = (IdlObject)vector2.elementAt(n);
            ++n;
        }
        return idlObjectArray;
    }

    public IdlObject[] sort_by_name(Vector vector) {
        int n;
        IdlObject[] idlObjectArray;
        Vector<IdlObject[]> vector2 = new Vector<IdlObject[]>();
        int n2 = 0;
        while (n2 < vector.size()) {
            idlObjectArray = (IdlObject)vector.elementAt(n2);
            n = 0;
            int n3 = 0;
            while (n3 < vector2.size()) {
                if (idlObjectArray.name().toLowerCase().compareTo(((IdlObject)vector2.elementAt(n3)).name().toLowerCase()) < 0) {
                    vector2.insertElementAt(idlObjectArray, n3);
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                vector2.addElement(idlObjectArray);
            }
            ++n2;
        }
        idlObjectArray = new IdlObject[vector2.size()];
        n = 0;
        while (n < vector2.size()) {
            idlObjectArray[n] = (IdlObject)vector2.elementAt(n);
            ++n;
        }
        return idlObjectArray;
    }

    public void write_alldescriptions_file_index(String string, File file, IdlObject idlObject2) {
        PrintWriter printWriter = this.create_file("alldescriptions-frame", file);
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<!-- org.openorb, IDL to HTML generator  -->");
        printWriter.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        printWriter.println("<TITLE>");
        printWriter.println("All Descriptions");
        printWriter.println("</TITLE>");
        printWriter.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet.css\" TITLE=\"Style\">");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY BGCOLOR=\"white\">");
        printWriter.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        printWriter.println("<TR>");
        printWriter.println("<TD NOWRAP><FONT size=\"+1\" ID=\"FrameHeadingFont\">");
        printWriter.println("All Descriptions</FONT>&nbsp;");
        printWriter.println("<FONT ID=\"FrameItemFont\">");
        printWriter.println("<BR>");
        Vector vector = new Vector();
        this.get_all_description_content(idlObject2, vector);
        IdlObject[] idlObjectArray = this.sort_description_by_name(vector);
        int n = 0;
        while (n < idlObjectArray.length) {
            this.write_description_entry(this.fullname(idlObjectArray[n]), this.get_full_link(idlObjectArray[n]), printWriter);
            ++n;
        }
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.close();
    }

    public void write_title(String string, PrintWriter printWriter) {
        printWriter.println("<HR>");
        printWriter.println("<H2>");
        printWriter.println(string + "</H2>");
        printWriter.println("<body>");
    }

    public void write_title_center(String string, PrintWriter printWriter) {
        printWriter.println("<HR>");
        printWriter.println("<CENTER>");
        printWriter.println("<H2>");
        printWriter.println(string + "</H2>");
        printWriter.println("</CENTER>");
        printWriter.println("<body>");
    }

    public void write_page_title(String string, PrintWriter printWriter) {
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<!-- org.openorb, IDL to HTML generator  -->");
        printWriter.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        printWriter.println("<TITLE>");
        printWriter.println(string);
        printWriter.println("</TITLE>");
        printWriter.print("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"");
        if (this.level > 0) {
            int n = 0;
            while (n < this.level) {
                printWriter.print("../");
                ++n;
            }
        }
        printWriter.println("stylesheet.css\" TITLE=\"Style\">");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY BGCOLOR=\"white\">");
    }

    public void write_navigation_bar(PrintWriter printWriter) {
        int n;
        printWriter.println("<A NAME=\"navbar_top\"><!-- --></A>");
        printWriter.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" CELLPADDING=\"1\" CELLSPACING=\"0\">");
        printWriter.println("<TR>");
        printWriter.println("<TD COLSPAN=2 BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">");
        printWriter.println("<A NAME=\"navbar_top_firstrow\"><!-- --></A>");
        printWriter.println("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"3\">");
        printWriter.println("<TR ALIGN=\"center\" VALIGN=\"top\">");
        printWriter.println("<TD BGCOLOR=\"#FFFFFF\" ID=\"NavBarCell1Rev\"> &nbsp;<FONT ID=\"NavBarFont1Rev\"><B>Overview</B></FONT>&nbsp;</TD>");
        printWriter.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Module</FONT>&nbsp;</TD>");
        printWriter.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Interface</FONT>&nbsp;</TD>");
        printWriter.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Type</FONT>&nbsp;</TD>");
        printWriter.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
        if (this.level > 0) {
            n = 0;
            while (n < this.level) {
                printWriter.print("../");
                ++n;
            }
        }
        printWriter.println("overview-tree.html\"><FONT ID=\"NavBarFont1\"><B>Tree</B></FONT></A>&nbsp;</TD>");
        printWriter.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
        if (this.level > 0) {
            n = 0;
            while (n < this.level) {
                printWriter.print("../");
                ++n;
            }
        }
        printWriter.println("deprecated-list.html\"><FONT ID=\"NavBarFont1\"><B>Deprecated</B></FONT></A>&nbsp;</TD>");
        printWriter.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
        if (this.level > 0) {
            n = 0;
            while (n < this.level) {
                printWriter.print("../");
                ++n;
            }
        }
        printWriter.println("overview-index.html\"><FONT ID=\"NavBarFont1\"><B>Index</B></FONT></A>&nbsp;</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("<TD ALIGN=\"right\" VALIGN=\"top\" ROWSPAN=3><EM>");
        printWriter.println("&nbsp;</EM>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD BGCOLOR=\"white\" ID=\"NavBarCell2\"><FONT SIZE=\"-2\">");
        printWriter.println("&nbsp;PREV&nbsp;");
        printWriter.println("&nbsp;NEXT</FONT></TD>");
        printWriter.println("<TD BGCOLOR=\"white\" ID=\"NavBarCell2\"><FONT SIZE=\"-2\">");
        printWriter.println("<A HREF=\"index.html\" TARGET=\"_top\"><B>FRAMES</B></A>  &nbsp;");
        printWriter.println("&nbsp;<A HREF=\"overview-summary.html\" TARGET=\"_top\"><B>NO FRAMES</B></A></FONT></TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
    }

    public void write_navigation_bar_index(PrintWriter printWriter, int n) {
        int n2;
        printWriter.println("<A NAME=\"navbar_top\"><!-- --></A>");
        printWriter.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" CELLPADDING=\"1\" CELLSPACING=\"0\">");
        printWriter.println("<TR>");
        printWriter.println("<TD COLSPAN=2 BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">");
        printWriter.println("<A NAME=\"navbar_top_firstrow\"><!-- --></A>");
        printWriter.println("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"3\">");
        printWriter.println("<TR ALIGN=\"center\" VALIGN=\"top\">");
        printWriter.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
        if (this.level > 0) {
            n2 = 0;
            while (n2 < this.level) {
                printWriter.print("../");
                ++n2;
            }
        }
        printWriter.println("overview-summary.html\"><FONT ID=\"NavBarFont1\"><B>Overview</B></FONT></A>&nbsp;</TD>");
        printWriter.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Module</FONT>&nbsp;</TD>");
        printWriter.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Interface</FONT>&nbsp;</TD>");
        printWriter.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Type</FONT>&nbsp;</TD>");
        if (n == 1) {
            printWriter.println("<TD BGCOLOR=\"#FFFFFF\" ID=\"NavBarCell1Rev\"> &nbsp;<FONT ID=\"NavBarFont1Rev\"><B>Tree</B></FONT>&nbsp;</TD>");
        } else {
            printWriter.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
            if (this.level > 0) {
                n2 = 0;
                while (n2 < this.level) {
                    printWriter.print("../");
                    ++n2;
                }
            }
            printWriter.println("overview-tree.html\"><FONT ID=\"NavBarFont1\"><B>Tree</B></FONT></A>&nbsp;</TD>");
        }
        if (n == 2) {
            printWriter.println("<TD BGCOLOR=\"#FFFFFF\" ID=\"NavBarCell1Rev\"> &nbsp;<FONT ID=\"NavBarFont1Rev\"><B>Deprecated</B></FONT>&nbsp;</TD>");
        } else {
            printWriter.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
            if (this.level > 0) {
                n2 = 0;
                while (n2 < this.level) {
                    printWriter.print("../");
                    ++n2;
                }
            }
            printWriter.println("deprecated-list.html\"><FONT ID=\"NavBarFont1\"><B>Deprecated</B></FONT></A>&nbsp;</TD>");
        }
        if (n == 3) {
            printWriter.println("<TD BGCOLOR=\"#FFFFFF\" ID=\"NavBarCell1Rev\"> &nbsp;<FONT ID=\"NavBarFont1Rev\"><B>Index</B></FONT>&nbsp;</TD>");
        } else {
            printWriter.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
            if (this.level > 0) {
                n2 = 0;
                while (n2 < this.level) {
                    printWriter.print("../");
                    ++n2;
                }
            }
            printWriter.println("overview-index.html\"><FONT ID=\"NavBarFont1\"><B>Index</B></FONT></A>&nbsp;</TD>");
        }
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("<TD ALIGN=\"right\" VALIGN=\"top\" ROWSPAN=3><EM>");
        printWriter.println("&nbsp;</EM>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD BGCOLOR=\"white\" ID=\"NavBarCell2\"><FONT SIZE=\"-2\">");
        printWriter.println("&nbsp;PREV&nbsp;");
        printWriter.println("&nbsp;NEXT</FONT></TD>");
        printWriter.println("<TD BGCOLOR=\"white\" ID=\"NavBarCell2\"><FONT SIZE=\"-2\">");
        printWriter.println("<A HREF=\"index.html\" TARGET=\"_top\"><B>FRAMES</B></A>  &nbsp;");
        printWriter.println("&nbsp;<A HREF=\"overview-summary.html\" TARGET=\"_top\"><B>NO FRAMES</B></A></FONT></TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
    }

    public void write_begin_table(String string, PrintWriter printWriter) {
        printWriter.println("<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
        printWriter.println("<TR BGCOLOR=\"#CCCCFF\" ID=\"TableHeadingColor\">");
        printWriter.println("<TD COLSPAN=2><FONT SIZE=\"+2\">");
        printWriter.println("<B>" + string + "</B></FONT></TD>");
        printWriter.println("</TR>");
    }

    public void write_table_entry(String string, String string2, String string3, PrintWriter printWriter) {
        printWriter.println("<TR BGCOLOR=\"white\" ID=\"TableRowColor\">");
        printWriter.println("<TD WIDTH=\"20%\"><B><A HREF=\"" + string2 + "\">" + string + "</A></B></TD>");
        printWriter.println("<TD>" + string3);
        printWriter.println("</TD>");
        printWriter.println("</TR>");
    }

    public void write_summary_file(String string, File file) {
        PrintWriter printWriter = this.create_file("overview-summary", file);
        this.write_page_title(string + " : overview", printWriter);
        this.write_navigation_bar(printWriter);
        this.write_title_center(string, printWriter);
        this.translateContentTable(this._root, printWriter, 3);
        printWriter.println("</TABLE>");
        printWriter.close();
    }

    public void write_style_sheet(File file) {
        PrintWriter printWriter = this.create_file("stylesheet.css", file);
        printWriter.println("/***************************************************************************");
        printWriter.println(" org.openorb, IDL to HTML Style Sheet");
        printWriter.println(" ***************************************************************************/");
        printWriter.println("");
        printWriter.println("/* Page background color */");
        printWriter.println("body { background-color: #FFFFFF }");
        printWriter.println("");
        printWriter.println("/* Table colors */");
        printWriter.println("#TableHeadingColor     { background: #CCCCFF } /* Dark mauve */");
        printWriter.println("#TableSubHeadingColor  { background: #EEEEFF } /* Light mauve */");
        printWriter.println("#TableRowColor         { background: #FFFFFF } /* White */");
        printWriter.println("");
        printWriter.println("/* Font used in left-hand frame lists */");
        printWriter.println("#FrameTitleFont   { font-size: normal; font-family: normal }");
        printWriter.println("#FrameHeadingFont { font-size: normal; font-family: normal }");
        printWriter.println("#FrameItemFont    { font-size: normal; font-family: normal }");
        printWriter.println("");
        printWriter.println("/* Navigation bar fonts and colors */");
        printWriter.println("#NavBarCell1    { background-color:#EEEEFF;}/* Light mauve */");
        printWriter.println("#NavBarCell1Rev { background-color:#00008B;}/* Dark Blue */");
        printWriter.println("#NavBarFont1    { font-family: Arial, Helvetica, sans-serif; color:#000000;}");
        printWriter.println("#NavBarFont1Rev { font-family: Arial, Helvetica, sans-serif; color:#FFFFFF;}");
        printWriter.println("");
        printWriter.println("#NavBarCell2    { font-family: Arial, Helvetica, sans-serif; background-color:#FFFFFF;}");
        printWriter.println("#NavBarCell3    { font-family: Arial, Helvetica, sans-serif; background-color:#FFFFFF;}");
        printWriter.close();
    }

    public void get_all_content(IdlObject idlObject2, Vector vector, boolean bl) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (!idlObject2.current().included()) {
                switch (idlObject2.current().kind()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 27: 
                    case 29: 
                    case 30: {
                        vector.addElement(idlObject2.current());
                        break;
                    }
                    case 1: 
                    case 15: 
                    case 28: {
                        vector.addElement(idlObject2.current());
                        if (bl) break;
                        this.get_all_content(idlObject2.current(), vector, bl);
                    }
                }
            }
            idlObject2.next();
        }
    }

    public void write_index(File file) {
        PrintWriter printWriter = this.create_file("overview-index", file);
        IdlComment idlComment = null;
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<!-- org.openorb, IDL to HTML generator  -->");
        printWriter.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        printWriter.println("<TITLE>");
        printWriter.println("Index");
        printWriter.println("</TITLE>");
        printWriter.print("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"");
        if (this.level > 0) {
            int n = 0;
            while (n < this.level) {
                printWriter.print("../");
                ++n;
            }
        }
        printWriter.println("stylesheet.css\" TITLE=\"Style\">");
        printWriter.println("</HEAD>");
        this.write_navigation_bar_index(printWriter, 3);
        Vector vector = new Vector();
        this.get_all_content(this._root, vector, false);
        IdlObject[] idlObjectArray = this.sort_by_name(vector);
        char c = idlObjectArray[0].name().toUpperCase().charAt(0);
        boolean bl = true;
        printWriter.println("<DL>");
        int n = 0;
        while (n < idlObjectArray.length) {
            if (c != idlObjectArray[n].name().toUpperCase().charAt(0)) {
                c = idlObjectArray[n].name().toUpperCase().charAt(0);
                bl = true;
            }
            if (bl) {
                printWriter.println("<H1>" + c + "</H1>");
                bl = false;
            }
            printWriter.println("<DT>");
            printWriter.print("<A HREF=\"" + this.get_link(idlObjectArray[n], this._root) + "\" TARGET=\"descriptionFrame\">" + idlObjectArray[n].name() + "</A>");
            printWriter.print(" - ");
            switch (idlObjectArray[n].kind()) {
                case 15: {
                    printWriter.print("Interface " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 1: {
                    printWriter.print("Module " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 28: {
                    printWriter.print("ValueType " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 27: {
                    printWriter.print("ValueBox " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 14: {
                    printWriter.print("Exception " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 3: {
                    printWriter.print("Struct " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 4: {
                    printWriter.print("Union " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 2: {
                    printWriter.print("Enum " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 13: {
                    printWriter.print("TypeDef " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 7: {
                    printWriter.print("Const " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 25: {
                    printWriter.print("Native " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 16: {
                    printWriter.print("Operation " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 17: {
                    printWriter.print("Attribute " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 29: {
                    printWriter.print("Member " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 30: {
                    printWriter.print("Factory " + this.fullname_idl(idlObjectArray[n]));
                }
            }
            idlComment = idlObjectArray[n].getComment();
            if (idlComment != null) {
                printWriter.print(" - ");
                printWriter.println(this.get_summary_description(idlObjectArray[n]));
            }
            ++n;
        }
        printWriter.println("</DL>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }

    public void write_branch(IdlObject idlObject2, PrintWriter printWriter) {
        Vector vector = new Vector();
        this.get_all_content(idlObject2, vector, true);
        IdlObject[] idlObjectArray = this.sort_by_name(vector);
        printWriter.println("<UL>");
        int n = 0;
        while (n < idlObjectArray.length) {
            printWriter.print("<LI>");
            printWriter.print("<A HREF=\"" + this.get_full_link(idlObjectArray[n]) + "\" TARGET=\"descriptionFrame\">" + idlObjectArray[n].name() + "</A> - ");
            switch (idlObjectArray[n].kind()) {
                case 15: {
                    printWriter.print("Interface " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 1: {
                    printWriter.print("Module " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 28: {
                    printWriter.print("ValueType " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 27: {
                    printWriter.print("ValueBox " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 14: {
                    printWriter.print("Exception " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 3: {
                    printWriter.print("Struct " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 4: {
                    printWriter.print("Union " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 2: {
                    printWriter.print("Enum " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 13: {
                    printWriter.print("TypeDef " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 7: {
                    printWriter.print("Const " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 25: {
                    printWriter.print("Native " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 16: {
                    printWriter.print("Operation " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 17: {
                    printWriter.print("Attribute " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 29: {
                    printWriter.print("Member " + this.fullname_idl(idlObjectArray[n]));
                    break;
                }
                case 30: {
                    printWriter.print("Factory " + this.fullname_idl(idlObjectArray[n]));
                }
            }
            printWriter.println("");
            switch (idlObjectArray[n].kind()) {
                case 1: 
                case 15: 
                case 28: {
                    this.write_branch(idlObjectArray[n], printWriter);
                }
            }
            ++n;
        }
        printWriter.println("</UL>");
    }

    public void write_tree(File file) {
        PrintWriter printWriter = this.create_file("overview-tree", file);
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<!-- org.openorb, IDL to HTML generator  -->");
        printWriter.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        printWriter.println("<TITLE>");
        printWriter.println("Index");
        printWriter.println("</TITLE>");
        printWriter.print("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"");
        if (this.level > 0) {
            int n = 0;
            while (n < this.level) {
                printWriter.print("../");
                ++n;
            }
        }
        printWriter.println("stylesheet.css\" TITLE=\"Style\">");
        printWriter.println("</HEAD>");
        this.write_navigation_bar_index(printWriter, 1);
        this.write_title_center("Hierarchy for all IDL descriptions", printWriter);
        this.write_branch(this._root, printWriter);
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }

    public void write_deprecated_section(IdlObject[] idlObjectArray, String string, PrintWriter printWriter) {
        if (this.is_any_deprecated(idlObjectArray)) {
            this.write_begin_table(string, printWriter);
            int n = 0;
            while (n < idlObjectArray.length) {
                if (this.is_deprecated(idlObjectArray[n])) {
                    this.write_table_entry(idlObjectArray[n].name(), this.get_full_link(idlObjectArray[n]), this.get_deprecation(idlObjectArray[n]), printWriter);
                }
                ++n;
            }
            printWriter.println("</TABLE><BR>");
        }
    }

    public void write_deprecated(File file) {
        PrintWriter printWriter = this.create_file("deprecated-list", file);
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.println("<!-- org.openorb, IDL to HTML generator  -->");
        printWriter.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        printWriter.println("<TITLE>");
        printWriter.println("Index");
        printWriter.println("</TITLE>");
        printWriter.print("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"");
        if (this.level > 0) {
            int n = 0;
            while (n < this.level) {
                printWriter.print("../");
                ++n;
            }
        }
        printWriter.println("stylesheet.css\" TITLE=\"Style\">");
        printWriter.println("</HEAD>");
        this.write_navigation_bar_index(printWriter, 2);
        this.write_title_center("Deprecated IDL descriptions", printWriter);
        content content2 = this.get_sorted_content(this._root, false);
        this.write_deprecated_section(content2._sorted_module, "Deprecated Modules", printWriter);
        this.write_deprecated_section(content2._sorted_interface, "Deprecated Interfaces", printWriter);
        this.write_deprecated_section(content2._sorted_valuetype, "Deprecated ValueTypes", printWriter);
        this.write_deprecated_section(content2._sorted_valuebox, "Deprecated ValueBox", printWriter);
        this.write_deprecated_section(content2._sorted_exception, "Deprecated Exceptions", printWriter);
        this.write_deprecated_section(content2._sorted_struct, "Deprecated Structs", printWriter);
        this.write_deprecated_section(content2._sorted_union, "Deprecated Unions", printWriter);
        this.write_deprecated_section(content2._sorted_enum, "Deprecated Enums", printWriter);
        this.write_deprecated_section(content2._sorted_typedef, "Deprecated TypeDefs", printWriter);
        this.write_deprecated_section(content2._sorted_const, "Deprecated Consts", printWriter);
        this.write_deprecated_section(content2._sorted_native, "Deprecated Natives", printWriter);
        this.write_deprecated_section(content2._sorted_operation, "Deprecated Operations", printWriter);
        this.write_deprecated_section(content2._sorted_attribute, "Deprecated Attributes", printWriter);
        this.write_deprecated_section(content2._sorted_member, "Deprecated Members", printWriter);
        this.write_deprecated_section(content2._sorted_factory, "Deprecated Factories", printWriter);
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }

    public String adapt_string(String string) {
        return string;
    }

    public String get_link(IdlObject idlObject2, IdlObject idlObject3) {
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = 0;
        IdlObject idlObject4 = idlObject2;
        IdlObject idlObject5 = idlObject3;
        String string4 = this.get_path(idlObject4);
        String string5 = this.get_path(idlObject5);
        int n2 = 0;
        int n3 = 0;
        n3 = string4.length() > string5.length() ? string5.length() : string4.length();
        while (n2 < n3) {
            if (string5.charAt(n2) != string4.charAt(n2)) break;
            ++n2;
        }
        if (n2 != 0) {
            --n2;
        }
        int n4 = n2;
        while (n4 > 0) {
            if (string5.charAt(n4) == '/') {
                ++n4;
                break;
            }
            --n4;
        }
        string3 = string5.substring(n4);
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        if (!string3.equals("")) {
            ++n;
        }
        n4 = n2;
        while (n4 > 0) {
            if (string4.charAt(n4) == '/') {
                ++n4;
                break;
            }
            --n4;
        }
        string2 = string4.substring(n4);
        n2 = 0;
        while (n2 < string3.length()) {
            if (string3.charAt(n2) == '/') {
                ++n;
            }
            ++n2;
        }
        n4 = 0;
        while (n4 < n) {
            string = string + "../";
            ++n4;
        }
        if (!string2.equals("")) {
            string = string + string2;
        }
        if (!string.equals("") && !string.endsWith("/")) {
            string = string + "/";
        }
        switch (idlObject4.kind()) {
            case 1: 
            case 15: 
            case 18: 
            case 28: 
            case 33: {
                string = string + idlObject2.name() + ".html";
                break;
            }
            default: {
                string = idlObject4.upper() == this._root ? string + "overview-summary" : string + idlObject2.upper().name();
                string = string + ".html#" + idlObject2.name();
            }
        }
        if (string.startsWith("/")) {
            string = "." + string;
        }
        return string;
    }

    public String get_full_link(IdlObject idlObject2) {
        if (idlObject2.kind() == 15) {
            return this.fullname_link(idlObject2) + "/" + idlObject2.name() + ".html";
        }
        if (idlObject2.kind() == 1) {
            return this.fullname_link(idlObject2) + "/" + idlObject2.name() + ".html";
        }
        if (idlObject2.kind() == 28) {
            return this.fullname_link(idlObject2) + "/" + idlObject2.name() + ".html";
        }
        if (idlObject2.upper() == this._root) {
            return "overview-summary.html#" + idlObject2.name();
        }
        return this.fullname_link(idlObject2.upper()) + "/" + idlObject2.upper().name() + ".html#" + idlObject2.name();
    }

    public String get_description(IdlObject idlObject2) {
        IdlComment idlComment = idlObject2.getComment();
        if (idlComment != null && idlComment.get_description() != null) {
            return this.adapt_string(idlComment.get_description());
        }
        return "";
    }

    public boolean is_deprecated(IdlObject idlObject2) {
        IdlComment idlComment = idlObject2.getComment();
        if (idlComment != null) {
            IdlCommentSection[] idlCommentSectionArray = idlComment.get_sections();
            int n = 0;
            while (n < idlCommentSectionArray.length) {
                if (idlCommentSectionArray[n].kind().value() == 6) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean is_any_deprecated(IdlObject[] idlObjectArray) {
        int n = 0;
        while (n < idlObjectArray.length) {
            if (this.is_deprecated(idlObjectArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String get_deprecation(IdlObject idlObject2) {
        IdlComment idlComment = idlObject2.getComment();
        if (idlComment != null) {
            IdlCommentSection[] idlCommentSectionArray = idlComment.get_sections();
            int n = 0;
            while (n < idlCommentSectionArray.length) {
                if (idlCommentSectionArray[n].kind().value() == 6) {
                    return idlCommentSectionArray[n].get_description();
                }
                ++n;
            }
        }
        return "";
    }

    public String get_summary_description(IdlObject idlObject2) {
        IdlComment idlComment = idlObject2.getComment();
        String string = null;
        if (idlComment != null && (string = idlComment.get_description()) != null) {
            if ((string = this.adapt_string(string)).indexOf(".") != -1) {
                return string.substring(0, string.indexOf(".") + 1);
            }
            if (string.indexOf("\n\n") != -1) {
                return string.substring(0, string.indexOf("\n\n") + 1);
            }
            return string;
        }
        return "";
    }

    public IdlCommentSection[] get_sections(IdlCommentSection[] idlCommentSectionArray, int n) {
        Vector<IdlCommentSection> vector = new Vector<IdlCommentSection>();
        int n2 = 0;
        while (n2 < idlCommentSectionArray.length) {
            if (idlCommentSectionArray[n2].kind().value() == n) {
                vector.addElement(idlCommentSectionArray[n2]);
            }
            ++n2;
        }
        IdlCommentSection[] idlCommentSectionArray2 = new IdlCommentSection[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            idlCommentSectionArray2[n3] = (IdlCommentSection)vector.elementAt(n3);
            ++n3;
        }
        return idlCommentSectionArray2;
    }

    public void write_section(IdlCommentSection[] idlCommentSectionArray, int n, String string, PrintWriter printWriter, boolean bl) {
        String string2 = "";
        String string3 = "";
        IdlCommentSection[] idlCommentSectionArray2 = this.get_sections(idlCommentSectionArray, n);
        if (idlCommentSectionArray2.length != 0) {
            printWriter.println("<H4>" + string + "</H4><UL>");
            int n2 = 0;
            while (n2 < idlCommentSectionArray2.length) {
                string2 = this.adapt_string(idlCommentSectionArray2[n2].get_description().trim());
                if (bl) {
                    int n3 = string2.indexOf(" ");
                    int n4 = string2.indexOf("\t");
                    if (n3 == -1 && n4 != -1) {
                        n3 = n4;
                    } else if (n4 != -1 && n4 < n3) {
                        n3 = n4;
                    }
                    if (n3 != -1) {
                        string3 = string2.substring(0, n3);
                        string2 = string2.substring(n3 + 1);
                        printWriter.print("<B><I> " + string3 + " </I></B> - ");
                    }
                }
                printWriter.println(string2);
                printWriter.println("<BR>");
                ++n2;
            }
            printWriter.println("</UL><BR>");
        }
    }

    public void write_description(IdlObject idlObject2, PrintWriter printWriter) {
        IdlComment idlComment = idlObject2.getComment();
        printWriter.println(this.get_description(idlObject2));
        printWriter.println("<BR>");
        if (idlComment != null) {
            IdlCommentSection[] idlCommentSectionArray = idlComment.get_sections();
            this.write_section(idlCommentSectionArray, 3, "Parameter", printWriter, true);
            this.write_section(idlCommentSectionArray, 4, "Return", printWriter, false);
            this.write_section(idlCommentSectionArray, 1, "Exception", printWriter, true);
            this.write_section(idlCommentSectionArray, 5, "See", printWriter, true);
            this.write_section(idlCommentSectionArray, 6, "Deprecated", printWriter, false);
        }
    }

    public void translateSubTypeSummary(IdlObject idlObject2, IdlObject[] idlObjectArray, PrintWriter printWriter, String string) {
        this.write_begin_table(string, printWriter);
        int n = 0;
        while (n < idlObjectArray.length) {
            String string2 = this.get_summary_description(idlObjectArray[n]);
            if (this.is_deprecated(idlObjectArray[n])) {
                string2 = "<B>deprecated</B> - " + string2;
            }
            this.write_table_entry(idlObjectArray[n].name(), this.get_link(idlObjectArray[n], idlObject2), string2, printWriter);
            ++n;
        }
        printWriter.println("</TABLE>");
        printWriter.println("<BR>");
    }

    public void translateSubTypeDetails(IdlObject idlObject2, IdlObject[] idlObjectArray, PrintWriter printWriter, String string) {
        this.write_begin_table(string, printWriter);
        printWriter.println("</TABLE>");
        int n = 0;
        while (n < idlObjectArray.length) {
            switch (idlObjectArray[n].kind()) {
                case 27: {
                    this.translateValueBox(idlObjectArray[n], printWriter);
                    break;
                }
                case 14: {
                    this.translateException(idlObjectArray[n], printWriter);
                    break;
                }
                case 3: {
                    this.translateStruct(idlObjectArray[n], printWriter);
                    break;
                }
                case 4: {
                    this.translateUnion(idlObjectArray[n], printWriter);
                    break;
                }
                case 2: {
                    this.translateEnum(idlObjectArray[n], printWriter);
                    break;
                }
                case 13: {
                    this.translateTypedef(idlObjectArray[n], printWriter);
                    break;
                }
                case 7: {
                    this.translateConstant(idlObjectArray[n], printWriter);
                    break;
                }
                case 25: {
                    this.translateNative(idlObjectArray[n], printWriter);
                    break;
                }
                case 16: {
                    this.translateOperation(idlObjectArray[n], printWriter);
                    break;
                }
                case 17: {
                    this.translateAttribute(idlObjectArray[n], printWriter);
                    break;
                }
                case 29: {
                    this.translateStateMember(idlObjectArray[n], printWriter);
                    break;
                }
                case 30: {
                    this.translateFactory(idlObjectArray[n], printWriter);
                }
            }
            ++n;
        }
        printWriter.println("<BR>");
    }

    public void translateContentTable(IdlObject idlObject2, PrintWriter printWriter, int n) {
        content content2 = this.get_sorted_content(idlObject2, true);
        if (n == 1 || n == 3) {
            if (content2._sorted_module.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_module, printWriter, "Module Summary");
            }
            if (content2._sorted_interface.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_interface, printWriter, "Interface Summary");
            }
            if (content2._sorted_valuetype.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_valuetype, printWriter, "ValueType Summary");
            }
            if (content2._sorted_valuebox.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_valuebox, printWriter, "ValueBox Summary");
            }
            if (content2._sorted_exception.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_exception, printWriter, "Exception Summary");
            }
            if (content2._sorted_struct.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_struct, printWriter, "Struct Summary");
            }
            if (content2._sorted_union.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_union, printWriter, "Union Summary");
            }
            if (content2._sorted_enum.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_enum, printWriter, "Enum Summary");
            }
            if (content2._sorted_typedef.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_typedef, printWriter, "TypeDef Summary");
            }
            if (content2._sorted_const.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_const, printWriter, "Const Summary");
            }
            if (content2._sorted_native.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_native, printWriter, "Native Summary");
            }
            if (content2._sorted_operation.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_operation, printWriter, "Operation Summary");
            }
            if (content2._sorted_attribute.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_attribute, printWriter, "Attribute Summary");
            }
            if (content2._sorted_member.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_member, printWriter, "Member Summary");
            }
            if (content2._sorted_factory.length != 0) {
                this.translateSubTypeSummary(idlObject2, content2._sorted_factory, printWriter, "Factory Summary");
            }
        }
        if (n == 2 || n == 3) {
            if (content2._sorted_valuebox.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_valuebox, printWriter, "ValueBox Details");
            }
            if (content2._sorted_exception.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_exception, printWriter, "Exception Details");
            }
            if (content2._sorted_struct.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_struct, printWriter, "Struct Details");
            }
            if (content2._sorted_union.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_union, printWriter, "Union Details");
            }
            if (content2._sorted_enum.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_enum, printWriter, "Enum Details");
            }
            if (content2._sorted_typedef.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_typedef, printWriter, "TypeDef Details");
            }
            if (content2._sorted_const.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_const, printWriter, "Const Details");
            }
            if (content2._sorted_native.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_native, printWriter, "Native Details");
            }
            if (content2._sorted_operation.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_operation, printWriter, "Operation Details");
            }
            if (content2._sorted_attribute.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_attribute, printWriter, "Attribute Details");
            }
            if (content2._sorted_member.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_member, printWriter, "Member Details");
            }
            if (content2._sorted_factory.length != 0) {
                this.translateSubTypeDetails(idlObject2, content2._sorted_factory, printWriter, "Factory Details");
            }
        }
    }

    public PrintWriter create_file(String string, File file) {
        String string2 = null;
        string2 = string.endsWith(".css") ? new String(file.getPath() + File.separator + string) : new String(file.getPath() + File.separator + string + ".html");
        File file2 = new File(string2);
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            printWriter = new PrintWriter(dataOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return printWriter;
    }

    public String fullname(IdlObject idlObject2) {
        Vector<String> vector = new Vector<String>();
        IdlObject idlObject3 = idlObject2;
        String string = new String("");
        boolean bl = false;
        while (idlObject3 != null) {
            vector.addElement(idlObject3.name());
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
            bl = true;
        }
        if (IdlDoc.usePrefix && idlObject2.getPrefix() != null) {
            if (!string.equals("")) {
                string = string + ".";
            }
            string = string + this.inversedPrefix(idlObject2.getPrefix());
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            String string2 = (String)vector.elementAt(n);
            if (string2 != null) {
                if (!string.equals("")) {
                    string = string + ".";
                }
                string = string + string2;
            }
            --n;
        }
        return string;
    }

    public String fullname_idl(IdlObject idlObject2) {
        Vector<String> vector = new Vector<String>();
        IdlObject idlObject3 = idlObject2;
        String string = new String("");
        boolean bl = false;
        while (idlObject3 != null) {
            vector.addElement(idlObject3.name());
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
            bl = true;
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            String string2 = (String)vector.elementAt(n);
            if (string2 != null) {
                if (!string.equals("")) {
                    string = string + "::";
                }
                string = string + string2;
            }
            --n;
        }
        return string;
    }

    public String fullname_link(IdlObject idlObject2) {
        Vector<String> vector = new Vector<String>();
        IdlObject idlObject3 = idlObject2;
        String string = new String("");
        boolean bl = false;
        while (idlObject3 != null) {
            switch (idlObject3.kind()) {
                case 19: {
                    break;
                }
                default: {
                    vector.addElement(idlObject3.name());
                }
            }
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
            bl = true;
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            String string2 = (String)vector.elementAt(n);
            if (string2 != null) {
                if (!string.equals("")) {
                    string = string + "/";
                }
                string = string + string2;
            }
            --n;
        }
        return string;
    }

    public String get_path(IdlObject idlObject2) {
        Vector<String> vector = new Vector<String>();
        IdlObject idlObject3 = idlObject2;
        String string = new String("");
        while (idlObject3 != null) {
            switch (idlObject3.kind()) {
                case 1: 
                case 15: 
                case 18: 
                case 28: 
                case 33: {
                    vector.addElement(idlObject3.name());
                }
            }
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            String string2 = (String)vector.elementAt(n);
            if (string2 != null) {
                if (!string.equals("")) {
                    string = string + "/";
                }
                string = string + string2;
            }
            --n;
        }
        return string;
    }

    public void sort_type_content(IdlObject idlObject2, content content2, boolean bl) {
        if (content2 == null) {
            content2 = new content();
        }
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (!idlObject2.current().included()) {
                switch (idlObject2.current().kind()) {
                    case 1: {
                        content2._module.addElement(idlObject2.current());
                        if (bl) break;
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 15: {
                        content2._interface.addElement(idlObject2.current());
                        if (bl) break;
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 28: {
                        content2._valuetype.addElement(idlObject2.current());
                        if (bl) break;
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 27: {
                        content2._valuebox.addElement(idlObject2.current());
                        break;
                    }
                    case 14: {
                        content2._exception.addElement(idlObject2.current());
                        break;
                    }
                    case 3: {
                        content2._struct.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 4: {
                        content2._union.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 2: {
                        content2._enum.addElement(idlObject2.current());
                        break;
                    }
                    case 13: {
                        content2._typedef.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 7: {
                        content2._const.addElement(idlObject2.current());
                        break;
                    }
                    case 25: {
                        content2._native.addElement(idlObject2.current());
                        break;
                    }
                    case 16: {
                        content2._operation.addElement(idlObject2.current());
                        break;
                    }
                    case 17: {
                        content2._attribute.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 29: {
                        content2._member.addElement(idlObject2.current());
                        this.sort_type_content(idlObject2.current(), content2, bl);
                        break;
                    }
                    case 30: {
                        content2._factory.addElement(idlObject2.current());
                    }
                }
            }
            idlObject2.next();
        }
    }

    public content get_sorted_content(IdlObject idlObject2, boolean bl) {
        content content2 = new content();
        this.sort_type_content(idlObject2, content2, bl);
        content2._sorted_module = content2._module.size() != 0 ? this.sort_description_by_name(content2._module) : new IdlObject[0];
        content2._sorted_interface = content2._interface.size() != 0 ? this.sort_description_by_name(content2._interface) : new IdlObject[0];
        content2._sorted_valuetype = content2._valuetype.size() != 0 ? this.sort_description_by_name(content2._valuetype) : new IdlObject[0];
        content2._sorted_valuebox = content2._valuebox.size() != 0 ? this.sort_description_by_name(content2._valuebox) : new IdlObject[0];
        content2._sorted_exception = content2._exception.size() != 0 ? this.sort_description_by_name(content2._exception) : new IdlObject[0];
        content2._sorted_struct = content2._struct.size() != 0 ? this.sort_description_by_name(content2._struct) : new IdlObject[0];
        content2._sorted_union = content2._union.size() != 0 ? this.sort_description_by_name(content2._union) : new IdlObject[0];
        content2._sorted_enum = content2._enum.size() != 0 ? this.sort_description_by_name(content2._enum) : new IdlObject[0];
        content2._sorted_typedef = content2._typedef.size() != 0 ? this.sort_description_by_name(content2._typedef) : new IdlObject[0];
        content2._sorted_const = content2._const.size() != 0 ? this.sort_description_by_name(content2._const) : new IdlObject[0];
        content2._sorted_native = content2._native.size() != 0 ? this.sort_description_by_name(content2._native) : new IdlObject[0];
        content2._sorted_operation = content2._operation.size() != 0 ? this.sort_description_by_name(content2._operation) : new IdlObject[0];
        content2._sorted_attribute = content2._attribute.size() != 0 ? this.sort_description_by_name(content2._attribute) : new IdlObject[0];
        content2._sorted_member = content2._member.size() != 0 ? this.sort_description_by_name(content2._member) : new IdlObject[0];
        content2._sorted_factory = content2._factory.size() != 0 ? this.sort_description_by_name(content2._factory) : new IdlObject[0];
        return content2;
    }

    public void translateHierarchy(IdlObject idlObject2, PrintWriter printWriter) {
        Vector<IdlObject> vector = new Vector<IdlObject>();
        IdlObject idlObject3 = idlObject2;
        while (idlObject3 != null) {
            switch (idlObject3.kind()) {
                case 1: 
                case 15: 
                case 18: 
                case 28: 
                case 33: {
                    vector.addElement(idlObject3);
                }
            }
            if (idlObject3.upper() != null && idlObject3.upper().kind() == 0) break;
            idlObject3 = idlObject3.upper();
        }
        if (vector.size() > 1) {
            String string = "";
            printWriter.println("<PRE>");
            int n = vector.size() - 1;
            while (n >= 0) {
                string = string + "   ";
                if (n == 0) {
                    printWriter.println("<B>" + this.fullname((IdlObject)vector.elementAt(n)) + "</B>");
                } else {
                    printWriter.println("<A HREF=\"" + this.get_link((IdlObject)vector.elementAt(n), idlObject2) + "\" TARGET=\"descriptionFrame\">" + this.fullname((IdlObject)vector.elementAt(n)) + "</A>");
                }
                if (n != 0) {
                    printWriter.println(string + "|");
                    printWriter.print(string + "+--");
                }
                --n;
            }
            printWriter.println("</PRE>");
        }
    }

    public String translateType(IdlObject idlObject2, String string, String string2, boolean bl, IdlObject idlObject3) {
        IdlSimple idlSimple = null;
        switch (idlObject2.kind()) {
            case 8: {
                idlSimple = (IdlSimple)idlObject2;
                switch (idlSimple.internal()) {
                    case 55: {
                        string = string + "void";
                        break;
                    }
                    case 34: {
                        string = string + "float";
                        break;
                    }
                    case 30: {
                        string = string + "double";
                        break;
                    }
                    case 47: {
                        string = string + "short";
                        break;
                    }
                    case 66: {
                        string = string + "unsigned short";
                        break;
                    }
                    case 38: {
                        string = string + "long";
                        break;
                    }
                    case 65: {
                        string = string + "unsigned long";
                        break;
                    }
                    case 73: {
                        string = string + "long long";
                        break;
                    }
                    case 74: {
                        string = string + "unsigned long long";
                        break;
                    }
                    case 26: {
                        string = string + "char";
                        break;
                    }
                    case 71: {
                        string = string + "wchar";
                        break;
                    }
                    case 24: {
                        string = string + "boolean";
                        break;
                    }
                    case 41: {
                        string = string + "octet";
                        break;
                    }
                    case 22: {
                        string = string + "any";
                        break;
                    }
                    case 70: {
                        string = string + "CORBA::TypeCode";
                        break;
                    }
                    case 40: {
                        string = string + "Object";
                        break;
                    }
                    case 88: {
                        string = string + "valuebase";
                    }
                }
                break;
            }
            case 26: {
                string = string + "fixed";
                break;
            }
            case 5: {
                string = string + "string";
                break;
            }
            case 6: {
                string = string + "wstring";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: 
            case 25: 
            case 28: 
            case 33: {
                string = string + "<A HREF=\"" + this.get_link(idlObject2, idlObject3) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl(idlObject2) + "</A>";
                break;
            }
            case 13: {
                idlObject2.reset();
                this.translateType(idlObject2.current(), string, string2, bl, idlObject3);
                break;
            }
            case 9: {
                string = string + "sequence&lt;";
                string = this.translateType(idlObject2.current(), string, string2, false, idlObject3);
                string = string + "&gt;";
                break;
            }
            case 24: {
                string = this.translateType(idlObject2.current(), string, string2 + "[" + ((IdlArray)idlObject2).getDimension() + "]", false, idlObject3);
                if (idlObject2.current().kind() != 24) {
                    string = string + " " + string2;
                    string = string + "[" + ((IdlArray)idlObject2).getDimension() + "]";
                }
                return string;
            }
            case 10: {
                if (((IdlIdent)idlObject2).internalObject().name().equals("TypeCode")) {
                    string = string + "CORBA::TypeCode";
                    break;
                }
                string = string + "<A HREF=\"" + this.get_link(((IdlIdent)idlObject2).internalObject(), idlObject3) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl(((IdlIdent)idlObject2).internalObject()) + "</A>";
                break;
            }
            case 27: {
                if (((IdlValueBox)idlObject2).simple()) {
                    string = string + this.fullname_idl(idlObject2);
                    break;
                }
                idlObject2.reset();
                string = this.translateType(idlObject2.current(), string, string2, bl, idlObject3);
            }
        }
        if (bl) {
            string = string + " " + string2;
        }
        return string;
    }

    public String translateParameter(IdlObject idlObject2, String string) {
        IdlParam idlParam = (IdlParam)idlObject2;
        idlParam.reset();
        switch (idlParam.param_attr()) {
            case 0: {
                string = string + "in ";
                break;
            }
            case 1: {
                string = string + "out ";
                break;
            }
            case 2: {
                string = string + "inout ";
            }
        }
        return this.translateType(idlParam.current(), string, idlParam.name(), true, idlObject2);
    }

    public void translateModule(IdlObject idlObject2, File file) {
        File file2 = this.createDirectory(idlObject2.name(), file);
        PrintWriter printWriter = this.create_file(idlObject2.name(), file2);
        ++this.level;
        this.write_page_title(idlObject2.name(), printWriter);
        this.write_navigation_bar(printWriter);
        this.write_title("Module " + idlObject2.name(), printWriter);
        this.translateHierarchy(idlObject2, printWriter);
        this.write_description(idlObject2, printWriter);
        printWriter.println("<BR><BR>");
        this.translateDescription(idlObject2, file2);
        this.translateContentTable(idlObject2, printWriter, 3);
        this.write_alldescriptions_file(idlObject2.name() + " : All descriptions", file2, idlObject2);
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
        --this.level;
    }

    public void translateEnum(IdlObject idlObject2, PrintWriter printWriter) {
        String string = "";
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        IdlEnumMember idlEnumMember = null;
        idlObject2.reset();
        int n = 1;
        string = string + "<UL>" + "enum " + idlObject2.name() + "<BR>";
        string = string + "{<BR><UL>";
        while (!idlObject2.end()) {
            idlEnumMember = (IdlEnumMember)idlObject2.current();
            ++n;
            string = string + idlEnumMember.name();
            idlObject2.next();
            if (!idlObject2.end()) {
                string = string + ", ";
            }
            string = string + "<BR>";
        }
        string = string + "</UL>}<BR></UL>";
        printWriter.println(string);
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateStruct(IdlObject idlObject2, PrintWriter printWriter) {
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        String string = "";
        IdlStructMember idlStructMember2 = null;
        string = string + "<UL>" + "struct " + idlObject2.name() + "<BR>";
        string = string + "{<BR><UL>";
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            idlStructMember2.reset();
            string = this.translateType(idlStructMember2.current(), string, idlStructMember2.name(), true, idlObject2);
            idlObject2.next();
            if (!idlObject2.end()) {
                string = string + ", ";
            }
            string = string + "<BR>";
        }
        string = string + "</UL>}<BR></UL>";
        printWriter.println(string);
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateUnion(IdlObject idlObject2, PrintWriter printWriter) {
        IdlUnionMember idlUnionMember2 = null;
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        String string = "";
        idlObject2.reset();
        idlUnionMember2 = (IdlUnionMember)idlObject2.current();
        idlUnionMember2.reset();
        string = string + "<UL>" + "union " + idlObject2.name() + " switch ( ";
        string = this.translateType(idlUnionMember2.current(), string, idlUnionMember2.name(), false, idlObject2);
        string = string + " )<BR>";
        string = string + "{<BR><UL>";
        idlObject2.next();
        int n = ((IdlUnion)idlObject2).index();
        int n2 = 0;
        while (!idlObject2.end()) {
            idlUnionMember2 = (IdlUnionMember)idlObject2.current();
            idlUnionMember2.reset();
            string = n2 == n ? string + "default : <BR><UL>" : string + "case " + this.adaptExpression(idlUnionMember2.getExpression()) + ": <BR><UL>";
            string = this.translateType(idlUnionMember2.current(), string, idlUnionMember2.name(), true, idlObject2);
            string = string + ";<BR></UL>";
            idlObject2.next();
            ++n2;
        }
        string = string + "</UL>}<BR></UL>";
        printWriter.println(string);
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateException(IdlObject idlObject2, PrintWriter printWriter) {
        String string = "";
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        IdlStructMember idlStructMember2 = null;
        string = string + "<UL>" + "exception " + idlObject2.name() + "<BR>";
        string = string + "{<BR><UL>";
        idlObject2.reset();
        while (!idlObject2.end()) {
            idlStructMember2 = (IdlStructMember)idlObject2.current();
            idlStructMember2.reset();
            string = this.translateType(idlStructMember2.current(), string, idlStructMember2.name(), true, idlObject2);
            idlObject2.next();
            if (!idlObject2.end()) {
                string = string + ", ";
            }
            string = string + "<BR>";
        }
        string = string + "</UL>}<BR></UL>";
        printWriter.println(string);
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateTypedef(IdlObject idlObject2, PrintWriter printWriter) {
        String string = "";
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        string = string + "<UL>" + "typedef ";
        idlObject2.reset();
        string = this.translateType(idlObject2.current(), string, idlObject2.name(), true, idlObject2);
        string = string + ";</UL><BR>";
        printWriter.println(string);
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateValueBox(IdlObject idlObject2, PrintWriter printWriter) {
        String string = "";
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        string = string + "<UL>" + "valuetype " + idlObject2.name() + " ";
        string = this.translateType(idlObject2.current(), string, idlObject2.name(), false, idlObject2);
        string = string + ";</UL><BR>";
        printWriter.println(string);
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateFactory(IdlObject idlObject2, PrintWriter printWriter) {
        String string = "";
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        string = string + "<UL>" + "factory " + idlObject2.name() + "(";
        idlObject2.reset();
        while (!idlObject2.end()) {
            string = string + "in ";
            idlObject2.current().reset();
            string = this.translateType(idlObject2.current().current(), string, idlObject2.current().name(), true, idlObject2);
            idlObject2.next();
            if (idlObject2.end()) continue;
            string = string + ", ";
        }
        string = string + ");</UL><BR>";
        printWriter.println(string);
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateStateMember(IdlObject idlObject2, PrintWriter printWriter) {
        IdlStateMember idlStateMember = null;
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        idlStateMember = (IdlStateMember)idlObject2;
        idlStateMember.reset();
        if (idlStateMember.public_member()) {
            printWriter.print("public ");
        } else {
            printWriter.print("private ");
        }
        printWriter.println(this.translateType(idlStateMember.current(), "", idlStateMember.name(), true, idlObject2));
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlStateMember, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateAttribute(IdlObject idlObject2, PrintWriter printWriter) {
        IdlAttribute idlAttribute2 = (IdlAttribute)idlObject2;
        idlAttribute2.reset();
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        if (idlAttribute2.readOnly()) {
            printWriter.print("readonly ");
        }
        printWriter.print("attribute ");
        printWriter.println(this.translateType(idlAttribute2.current(), "", idlAttribute2.name(), true, idlObject2) + "</PRE>");
        printWriter.println("<DL>");
        printWriter.println("<DD>");
        this.write_description(idlAttribute2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateOperation(IdlObject idlObject2, PrintWriter printWriter) {
        IdlObject idlObject3;
        IdlOp idlOp = (IdlOp)idlObject2;
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        String string = "";
        string = string + "<UL>";
        if (idlOp.oneway()) {
            string = string + "oneway ";
        }
        idlOp.reset();
        string = this.translateType(idlOp.current(), string, idlOp.name(), false, idlObject2);
        idlOp.next();
        string = string + " " + idlOp.name() + "(";
        while (!idlOp.end()) {
            if (idlOp.current().kind() != 19) break;
            string = this.translateParameter(idlOp.current(), string);
            idlOp.next();
            if (idlOp.end() || idlOp.current().kind() != 19) continue;
            string = string + ", ";
        }
        string = string + ")";
        if (!idlOp.end() && idlOp.current().kind() == 20) {
            string = string + "<BR><UL> raises (<BR><UL>";
            idlObject3 = (IdlRaises)idlOp.current();
            idlObject3.reset();
            while (!idlObject3.end()) {
                string = string + "<A HREF=\"" + this.get_link(idlObject3.current(), idlObject2) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl(idlObject3.current()) + "</A>";
                idlObject3.next();
                if (idlObject3.end()) continue;
                string = string + ", <BR>";
            }
            string = string + ")</UL></UL>";
            idlOp.next();
        }
        if (!idlOp.end() && idlOp.current().kind() == 21) {
            string = string + "<BR><UL>";
            string = string + " context (";
            idlObject3 = (IdlContext)idlOp.current();
            Vector vector = ((IdlContext)idlObject3).getValues();
            int n = 0;
            while (n < vector.size()) {
                string = string + "\"" + (String)vector.elementAt(n) + "\"";
                if (n + 1 < vector.size()) {
                    string = string + ", ";
                }
                ++n;
            }
            string = string + ")<BR></UL>";
        }
        printWriter.println(string);
        printWriter.println("</PRE></UL><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateValueType(IdlObject idlObject2, File file) {
        File file2 = this.createDirectory(idlObject2.name(), file);
        PrintWriter printWriter = this.create_file(idlObject2.name(), file2);
        ++this.level;
        this.write_alldescriptions_file(idlObject2.name() + " : All descriptions", file2, idlObject2);
        IdlValue idlValue2 = (IdlValue)idlObject2;
        String string = "";
        this.write_page_title(idlObject2.name(), printWriter);
        this.write_navigation_bar(printWriter);
        this.write_title("ValueType " + idlObject2.name(), printWriter);
        this.translateHierarchy(idlObject2, printWriter);
        this.write_description(idlObject2, printWriter);
        string = string + "<UL>";
        if (idlValue2.abstract_value()) {
            string = string + "abstract ";
        }
        if (idlValue2.custom_value()) {
            string = string + "custom ";
        }
        string = string + "valuetype " + idlObject2.name();
        Vector vector = idlValue2.getInheritanceList();
        if (vector.size() != 0) {
            string = string + " : ";
            int n = 0;
            while (n < vector.size()) {
                if (((IdlValueInheritance)vector.elementAt(n)).truncatable_member()) {
                    string = string + "truncatable ";
                }
                string = string + "<A HREF=\"" + this.get_link(((IdlValueInheritance)vector.elementAt(n)).getValue(), idlObject2) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl(((IdlValueInheritance)vector.elementAt(n)).getValue()) + "</A>";
                if (n + 1 < vector.size()) {
                    string = string + ", ";
                }
                ++n;
            }
        }
        string = string + "<BR><BR></UL>";
        printWriter.println(string);
        this.translateContentTable(idlObject2, printWriter, 1);
        IdlValue idlValue3 = null;
        if (vector.size() != 0) {
            int n = 0;
            while (n < vector.size()) {
                idlValue3 = ((IdlValueInheritance)vector.elementAt(n)).getValue();
                if (!idlValue3.included()) {
                    printWriter.println("<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
                    printWriter.println("<TR BGCOLOR=\"#EEEEFF\" ID=\"TableSubHeadingColor\">");
                    printWriter.println("<TD><B>Members, attributes and operations inherited from <A HREF=\"" + this.get_link(idlValue3, idlObject2) + "\">" + this.fullname_idl(idlValue3) + "</A></B></TD>");
                    printWriter.println("</TR>");
                    printWriter.println("<TR BGCOLOR=\"white\" ID=\"TableRowColor\">");
                    printWriter.println("<TD><CODE>\n");
                    idlValue3.reset();
                    while (!idlValue3.end()) {
                        switch (idlValue3.current().kind()) {
                            case 16: 
                            case 17: 
                            case 29: {
                                printWriter.println("<A HREF=\"" + this.get_link(idlValue3.current(), idlObject2) + "\">" + idlValue3.current().name() + "</A>");
                            }
                        }
                        idlValue3.next();
                    }
                    printWriter.println("</CODE></TD></TR>\n");
                    printWriter.println("</TABLE><BR>\n");
                }
                ++n;
            }
        }
        this.translateContentTable(idlObject2, printWriter, 2);
        --this.level;
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }

    public void translateInterface(IdlObject idlObject2, File file) {
        IdlInterface idlInterface2 = (IdlInterface)idlObject2;
        File file2 = this.createDirectory(idlObject2.name(), file);
        PrintWriter printWriter = this.create_file(idlObject2.name(), file2);
        ++this.level;
        this.write_alldescriptions_file(idlObject2.name() + " : All descriptions", file2, idlObject2);
        String string = "";
        this.write_page_title(idlObject2.name(), printWriter);
        this.write_navigation_bar(printWriter);
        this.write_title("interface " + idlObject2.name(), printWriter);
        this.translateHierarchy(idlObject2, printWriter);
        this.write_description(idlObject2, printWriter);
        string = string + "<UL>";
        if (idlInterface2.abstract_interface()) {
            string = string + "abstract ";
        }
        string = string + "interface " + idlObject2.name();
        Vector vector = idlInterface2.getInheritance();
        if (vector.size() != 0) {
            string = string + " : ";
            int n = 0;
            while (n < vector.size()) {
                string = string + "<A HREF=\"" + this.get_link((IdlInterface)vector.elementAt(n), idlObject2) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl((IdlInterface)vector.elementAt(n)) + "</A>";
                if (n + 1 < vector.size()) {
                    string = string + ", ";
                }
                ++n;
            }
        }
        string = string + "<BR><BR></UL>";
        printWriter.println(string);
        this.translateContentTable(idlObject2, printWriter, 1);
        IdlInterface idlInterface3 = null;
        if (vector.size() != 0) {
            int n = 0;
            while (n < vector.size()) {
                idlInterface3 = (IdlInterface)vector.elementAt(n);
                if (!idlInterface3.included()) {
                    printWriter.println("<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
                    printWriter.println("<TR BGCOLOR=\"#EEEEFF\" ID=\"TableSubHeadingColor\">");
                    printWriter.println("<TD><B>Attributes and operations inherited from <A HREF=\"" + this.get_link(idlInterface3, idlObject2) + "\">" + this.fullname_idl(idlInterface3) + "</A></B></TD>");
                    printWriter.println("</TR>");
                    printWriter.println("<TR BGCOLOR=\"white\" ID=\"TableRowColor\">");
                    printWriter.println("<TD><CODE>\n");
                    idlInterface3.reset();
                    while (!idlInterface3.end()) {
                        switch (idlInterface3.current().kind()) {
                            case 16: 
                            case 17: {
                                printWriter.println("<A HREF=\"" + this.get_link(idlInterface3.current(), idlObject2) + "\">" + idlInterface3.current().name() + "</A>");
                            }
                        }
                        idlInterface3.next();
                    }
                    printWriter.println("</CODE></TD></TR>\n");
                    printWriter.println("</TABLE><BR>\n");
                }
                ++n;
            }
        }
        this.translateContentTable(idlObject2, printWriter, 2);
        --this.level;
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }

    public String correctIdentifier(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        String string3 = null;
        while ((n = string.indexOf(".", n2)) != n2) {
            if (n == -1) {
                string3 = string.substring(n2, string.length());
                vector.addElement(string3);
                break;
            }
            string3 = string.substring(n2, n);
            vector.addElement(string3);
            n2 = n + 1;
        }
        n3 = 0;
        while (n3 < vector.size()) {
            string3 = (String)vector.elementAt(n3);
            if (this._root.isDefined(string3, false)) break;
            ++n3;
        }
        int n4 = n3;
        while (n4 < vector.size()) {
            string2 = string2 + (String)vector.elementAt(n4);
            if (n4 + 1 < vector.size()) {
                string2 = string2 + "::";
            }
            ++n4;
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    public String adaptExpression(String var1_1) {
        var2_2 = new char[500];
        var3_3 = "";
        var4_4 = 0;
        var5_5 = 0;
        while (var4_4 != var1_1.length()) {
            block7: {
                block8: {
                    if (!Character.isDigit(var1_1.charAt(var4_4))) break block7;
                    if (var1_1.charAt(var4_4) != '0' || var4_4 + 1 >= var1_1.length() || var1_1.charAt(var4_4 + 1) != 'X' && var1_1.charAt(var4_4 + 1) != 'x') ** GOTO lbl15
                    var2_2[var5_5++] = var1_1.charAt(var4_4++);
                    var2_2[var5_5++] = var1_1.charAt(var4_4++);
                    while (var4_4 < var1_1.length() && (Character.isDigit(var1_1.charAt(var4_4)) || var1_1.charAt(var4_4) >= 'A' && var1_1.charAt(var4_4) <= 'F' || var1_1.charAt(var4_4) >= 'a' && var1_1.charAt(var4_4) <= 'f')) {
                        var2_2[var5_5++] = var1_1.charAt(var4_4++);
                    }
                    break block8;
lbl-1000:
                    // 1 sources

                    {
                        var2_2[var5_5++] = var1_1.charAt(var4_4++);
lbl15:
                        // 2 sources

                        ** while (var4_4 < var1_1.length() && (Character.isDigit((char)var1_1.charAt((int)var4_4)) || var1_1.charAt((int)var4_4) == '.'))
                    }
                }
                var2_2[var5_5] = '\u0000';
                var3_3 = var3_3 + new String(var2_2, 0, var5_5);
                var5_5 = 0;
                continue;
            }
            if (Character.isLetter(var1_1.charAt(var4_4))) {
                while (var4_4 < var1_1.length() && (Character.isLetterOrDigit(var1_1.charAt(var4_4)) || var1_1.charAt(var4_4) == '.' || var1_1.charAt(var4_4) == '_')) {
                    var2_2[var5_5++] = var1_1.charAt(var4_4++);
                }
                var2_2[var5_5] = '\u0000';
                var3_3 = var3_3 + this.correctIdentifier(new String(var2_2, 0, var5_5));
                var5_5 = 0;
                continue;
            }
            if (var1_1.charAt(var4_4) == '\"') {
                ++var4_4;
                while (var1_1.charAt(var4_4) != '\"') {
                    var2_2[var5_5++] = var1_1.charAt(var4_4++);
                }
                var2_2[var5_5] = '\u0000';
                var3_3 = var3_3 + "\"" + new String(var2_2, 0, var5_5) + "\"";
                var5_5 = 0;
                ++var4_4;
                continue;
            }
            var2_2[0] = var1_1.charAt(var4_4++);
            var2_2[1] = '\u0000';
            var3_3 = var3_3 + new String(var2_2, 0, 1);
        }
        return var3_3;
    }

    public void translateConstant(IdlObject idlObject2, PrintWriter printWriter) {
        String string = "";
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        string = string + "<UL>" + "const ";
        string = this.translateType(idlObject2.current(), string, idlObject2.name(), true, idlObject2);
        string = string + " = " + this.adaptExpression(((IdlConst)idlObject2).expression());
        string = string + ";</UL><BR>";
        printWriter.println(string);
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateNative(IdlObject idlObject2, PrintWriter printWriter) {
        String string = "";
        printWriter.println("<A NAME=\"" + idlObject2.name() + "\"><!-- --></A><H3>");
        printWriter.println(idlObject2.name() + "</H3>");
        printWriter.println("<PRE>");
        string = string + "<UL>" + "native " + idlObject2.name() + ";<BR></UL>";
        printWriter.println(string);
        printWriter.println("</PRE><DL>");
        printWriter.println("<DD>");
        this.write_description(idlObject2, printWriter);
        printWriter.println("</DD>");
        printWriter.println("</DL>");
        printWriter.println("<HR>");
    }

    public void translateInternalDescription(IdlObject idlObject2, File file, PrintWriter printWriter) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (!idlObject2.current().included()) {
                switch (idlObject2.current().kind()) {
                    case 7: {
                        this.translateConstant(idlObject2.current(), printWriter);
                        break;
                    }
                    case 2: {
                        this.translateEnum(idlObject2.current(), printWriter);
                        break;
                    }
                    case 3: {
                        this.translateStruct(idlObject2.current(), printWriter);
                        break;
                    }
                    case 4: {
                        this.translateUnion(idlObject2.current(), printWriter);
                        break;
                    }
                    case 13: {
                        this.translateTypedef(idlObject2.current(), printWriter);
                        break;
                    }
                    case 14: {
                        this.translateException(idlObject2.current(), printWriter);
                        break;
                    }
                    case 25: {
                        this.translateNative(idlObject2.current(), printWriter);
                    }
                }
            }
            idlObject2.next();
        }
    }

    public void translateDescription(IdlObject idlObject2, File file) {
        idlObject2.reset();
        while (!idlObject2.end()) {
            if (!idlObject2.current().included()) {
                switch (idlObject2.current().kind()) {
                    case 1: {
                        this.translateModule(idlObject2.current(), file);
                        break;
                    }
                    case 28: {
                        this.translateValueType(idlObject2.current(), file);
                        break;
                    }
                    case 15: {
                        this.translateInterface(idlObject2.current(), file);
                    }
                }
            }
            idlObject2.next();
        }
    }

    public void translateToHTML(IdlObject idlObject2, String string, String string2) {
        this._root = idlObject2;
        File file = null;
        if (IdlDoc.outdir != null) {
            file = new File(IdlDoc.outdir);
        }
        File file2 = this.createDirectory(string2, file);
        this.write_index_file(string, file2);
        this.write_index(file2);
        this.write_overview_file(idlObject2, string, file2);
        this.write_alldescriptions_file_index(string, file2, idlObject2);
        this.write_summary_file(string, file2);
        this.write_tree(file2);
        this.write_deprecated(file2);
        this.translateDescription(idlObject2, file2);
        if (IdlDoc.stylesheet) {
            this.write_style_sheet(file2);
        }
    }
}

