/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.doc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.doc.html.IdlToHTML;
import org.openorb.compiler.doc.rtf.IdlToRTF;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.parser.IdlParser;

public class IdlDoc {
    public static String[] idl_file_name;
    public static Vector idl_file_name_list;
    public static String packageName;
    public static boolean use_package;
    public static String outdir;
    public static boolean stylesheet;
    public static boolean htmlDoc;
    public static String title;
    public static String header;
    public static String footer;
    public static String filename;
    public static String codepage;
    public static boolean usePrefix;

    public static void printUsage() {
        System.out.println("");
        System.out.println("");
        System.out.println("#################################################");
        System.out.println("#                    OpenORB                    #");
        System.out.println("#                -----------------              #");
        System.out.println("#         (c) 2002 The Community OpenORB        #");
        System.out.println("#################################################");
        System.out.println("# Java Doc Compiler, Release 1.0                #");
        System.out.println("#################################################");
        System.out.println("");
        System.out.println("");
        System.out.println("Options");
        System.out.println("-------");
        System.out.println("\t-release");
        System.out.println("\t\tShow version number");
        System.out.println("\t-html");
        System.out.println("\t\tCreate HTML output");
        System.out.println("\t-outdir:");
        System.out.println("\t\tProvide a way to specify the ouput dir. This option");
        System.out.println("\t\twill not use the corba_pkg directory.");
        System.out.println("\t\tFor example :");
        System.out.println("\t\t idl2doc demo.idl -outdir:/home/me/");
        System.out.println("\t-nopackage");
        System.out.println("\t\tDon't use a package name");
        System.out.println("\t-package: package_name");
        System.out.println("\t\tGenerate files in package_name");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl demo.idl -package:exemple");
        System.out.println("\t-I");
        System.out.println("\t\tAllow specification of include directory");
        System.out.println("\t\tExample:");
        System.out.println("\t\t  idl demo.idl -I/home/me/idl -I../autre");
        System.out.println("\t-D");
        System.out.println("\t\tDefine a symbole. It is equivalent to #define");
        System.out.println("\t-all");
        System.out.println("\t\tGenerate documentation for included files.");
        System.out.println("\t-stylesheet ( for HTML documentation only )");
        System.out.println("\t\tGenerate a style sheet for HTML documentation.");
        System.out.println("\t-title:");
        System.out.println("\t\tSet the documentation title.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2html demo.idl \"-title:My Doc Title\"");
        System.out.println("\t-codepage:");
        System.out.println("\t\tSet the codepage for the generated html files.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2html demo.idl -codepage:ISO-8859-5");
        System.out.println("\t-noprefix");
        System.out.println("\t\t Disable usage of prefix for package name.");
        System.out.println("\t-header ( for RTF documentation only ) :");
        System.out.println("\t\tSet the documentation header.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2rtf demo.idl \"-header:My Doc header\"");
        System.out.println("\t-footer ( for RTF documentation only ) :");
        System.out.println("\t\tSet the documentation footer.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2rtf demo.idl \"-footer:My Doc footer\"");
        System.out.println("\t-docname:");
        System.out.println("\t\tSet the documentation file name for RTF documentation.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2rtf demo.idl -docname:mydoc.rtf");
        System.out.println("\t-codepage:");
        System.out.println("\t\tSet the codepage for the generated files.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t idl2rtf demo.idl -docname:mydoc.rtf");
        System.out.println("");
        System.out.println("");
        System.exit(0);
    }

    public static void analyse_arguments(String[] stringArray) {
        IdlCompiler.includeList = new Vector();
        IdlCompiler.definedMacros = new Hashtable();
        int n = 0;
        while (n < stringArray.length) {
            block65: {
                if (stringArray[n].charAt(0) != '-') {
                    idl_file_name_list.addElement(stringArray[n]);
                } else if (stringArray[n].equals("-release")) {
                    System.out.println("1.3.0");
                    System.exit(0);
                } else if (stringArray[n].equals("-h")) {
                    IdlDoc.printUsage();
                } else if (stringArray[n].equals("-html")) {
                    htmlDoc = true;
                } else if (stringArray[n].equals("-help")) {
                    IdlDoc.printUsage();
                } else if (stringArray[n].equals("-nopackage")) {
                    use_package = false;
                } else if (stringArray[n].equals("-noprefix")) {
                    usePrefix = false;
                } else if (stringArray[n].equals("-stylesheet")) {
                    stylesheet = true;
                } else if (stringArray[n].equals("-all")) {
                    IdlCompiler.map_all = true;
                } else if (stringArray[n].startsWith("-package:")) {
                    try {
                        packageName = stringArray[n].substring(9, stringArray[n].length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (packageName.equals("")) {
                        System.out.println("Package name cannot be empty...");
                        System.exit(0);
                    }
                } else if (stringArray[n].startsWith("-title:")) {
                    try {
                        title = stringArray[n].substring(7, stringArray[n].length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                } else if (stringArray[n].startsWith("-header:")) {
                    try {
                        header = stringArray[n].substring(7, stringArray[n].length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                } else if (stringArray[n].startsWith("-footer:")) {
                    try {
                        footer = stringArray[n].substring(7, stringArray[n].length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                } else if (stringArray[n].startsWith("-docname:")) {
                    try {
                        filename = stringArray[n].substring(9, stringArray[n].length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                } else if (stringArray[n].startsWith("-outdir:")) {
                    try {
                        outdir = stringArray[n].substring(8, stringArray[n].length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (packageName == null) {
                        packageName = "";
                        use_package = false;
                    }
                } else if (stringArray[n].startsWith("-codepage:")) {
                    try {
                        codepage = stringArray[n].substring(10, stringArray[n].length());
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                } else if (stringArray[n].startsWith("-I")) {
                    try {
                        String string = stringArray[n].substring(2, stringArray[n].length());
                        URL uRL = null;
                        try {
                            uRL = new URL(string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            try {
                                uRL = new File(string).toURL();
                            }
                            catch (MalformedURLException malformedURLException2) {
                                // empty catch block
                            }
                        }
                        if (uRL != null) {
                            IdlCompiler.includeList.addElement(uRL);
                        }
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                } else if (stringArray[n].startsWith("-D")) {
                    try {
                        int n2 = stringArray[n].indexOf(61);
                        if (n2 < 0) {
                            IdlCompiler.definedMacros.put(stringArray[n].substring(2, stringArray[n].length()), "");
                            break block65;
                        }
                        IdlCompiler.definedMacros.put(stringArray[n].substring(2, n2), stringArray[n].substring(n2 + 1));
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                } else {
                    System.out.println("Bad parameter");
                    System.out.println("Please, use no flag to display all compiler option flags");
                    System.exit(0);
                }
            }
            ++n;
        }
        if (packageName == null) {
            packageName = new String("corba_pkg");
        }
        IdlCompiler.packageName = packageName;
        idl_file_name = new String[idl_file_name_list.size()];
        int n3 = 0;
        while (n3 < idl_file_name_list.size()) {
            IdlDoc.idl_file_name[n3] = (String)idl_file_name_list.elementAt(n3);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        IdlParser idlParser2 = null;
        idl_file_name_list = new Vector();
        if (stringArray.length != 0) {
            IdlDoc.analyse_arguments(stringArray);
        } else {
            IdlDoc.printUsage();
        }
        IdlCompiler.idl_file_name = idl_file_name;
        if (idl_file_name.length == 0) {
            IdlDoc.printUsage();
        }
        idlParser2 = new IdlParser();
        System.out.println("OpenORB Doc generator");
        IdlObject idlObject2 = null;
        int n = 0;
        while (n < idl_file_name.length) {
            idlObject2 = idlParser2.compile_idl(idl_file_name[n]);
            ++n;
        }
        if (IdlParser.totalError != 0) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            System.exit(0);
        }
        if (htmlDoc) {
            System.out.println("IDL To HTML");
            IdlToHTML idlToHTML = new IdlToHTML();
            idlToHTML.translateToHTML(idlObject2, title, packageName);
        } else {
            System.out.println("IDL To RTF");
            IdlToRTF idlToRTF = new IdlToRTF();
            if (filename == null) {
                System.out.println("IDL to RTF fatal error : you must specify an file name for the RTF documentation with '-docname:' flag.");
                System.exit(0);
            }
            idlToRTF.translateToRTF(idlObject2, filename, title, header, footer);
        }
    }

    static {
        packageName = null;
        use_package = true;
        outdir = null;
        stylesheet = false;
        htmlDoc = false;
        title = "IDL Documentation";
        header = "";
        footer = "";
        filename = "";
        codepage = "ISO-8859-1";
        usePrefix = true;
    }
}

