/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.openorb.compiler.Configurator;
import org.openorb.compiler.generator.IdlToJava;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.parser.IdlParser;

public class IdlCompiler {
    public static final String tab = "    ";
    public static Vector includeList = new Vector();
    public static Hashtable definedMacros = new Hashtable();
    public static Vector importLink = new Vector();
    public static Vector nativeDefinition = new Vector();
    public static String[] idl_file_name;
    public static Vector idl_file_name_list;
    public static boolean map_stub;
    public static boolean local_stub;
    public static boolean map_skeleton;
    public static boolean map_all;
    public static boolean map_tie;
    public static boolean map_user;
    public static boolean pidl;
    public static boolean map_poa;
    public static boolean verbose;
    public static String packageName;
    public static boolean use_package;
    public static boolean portableHelper;
    public static String outdir;
    public static boolean dynamic;
    public static boolean usePrefix;
    public static boolean silentMode;
    public static boolean displayBadFlag;
    public static boolean reversePrefix;
    public static boolean useReflection;
    public static boolean useSwitch;
    public static boolean useClasses;
    public static boolean jdk1_4;
    public static int minTableSize;
    public static String generateValueFactory;
    public static String generateValueImpl;

    public static void display_help() {
        System.out.println("");
        System.out.println("");
        System.out.println("---------------------------------------------------------------");
        System.out.println("OpenORB                                                        ");
        System.out.println("(c) 2002 The Community OpenORB");
        System.out.println("IDL To Java Compiler                                           ");
        System.out.println("---------------------------------------------------------------");
        System.out.println("");
        System.out.println("");
        System.out.println("Options");
        System.out.println("\t-all");
        System.out.println("\t\tGenerate mapping for included files.");
        System.out.println("\t-boa");
        System.out.println("\t\tGenerate skeleton for BOA.");
        System.out.println("\t-d directory_name");
        System.out.println("\t\tProvide a way to specify the ouput dir. This option");
        System.out.println("\t\twill not use the 'generated' directory.");
        System.out.println("\t\tFor example :");
        System.out.println("\t\t org.openorb.compiler.IdlCompiler demo.idl -d /home/me/");
        System.out.println("\t-dynamic");
        System.out.println("\t\tGenerate stub with DII and skeleton with DSI");
        System.out.println("\t\t( portable way before CORBA 2.3 ).");
        System.out.println("\t-D");
        System.out.println("\t\tDefine a symbol. It is equivalent to #define.");
        System.out.println("\t-importLink link");
        System.out.println("\t-I");
        System.out.println("\t\tAllow specification of include directory.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t  org.openorb.compiler.IdlCompiler demo.idl -I /home/me/idl -I ../other");
        System.out.println("\t-native native_name native_mapping");
        System.out.println("\t\tDefine native type mapping.");
        System.out.println("\t\tFor example : ");
        System.out.println("\t\t org.openorb.compiler.IdlCompiler demo.idl -native cookie java.lang.Object");
        System.out.println("\t\t this command implies the mapping of");
        System.out.println("\t\t cookie in java.lang.Object.");
        System.out.println("\t-nolocalstub");
        System.out.println("\t\tGenerate stubs without local invocation path.");
        System.out.println("\t-noprefix");
        System.out.println("\t\tDon't use prefixes as packages names.");
        System.out.println("\t-noreverseprefix");
        System.out.println("\t\tThe prefixes are used as package name but they are not reversed.");
        System.out.println("\t-noskeleton");
        System.out.println("\t\tDon't generate skeleton.");
        System.out.println("\t-nostub");
        System.out.println("\t\tDon't generate stub.");
        System.out.println("\t-notie");
        System.out.println("\t\tDon't generate TIE classes for delegation mode.");
        System.out.println("\t-package package_name");
        System.out.println("\t\tGenerate files in package_name.");
        System.out.println("\t\tExample:");
        System.out.println("\t\t org.openorb.compiler.IdlCompiler demo.idl -package exemple");
        System.out.println("\t-pidl");
        System.out.println("\t-portablehelper");
        System.out.println("\t\tGenerate portable helper classes. Nonportable helpers must be");
        System.out.println("\t\tcompiled using OpenORB, but the generated class files will work");
        System.out.println("\t\tanywhere. Portable helpers can be compiled anywhere and will");
        System.out.println("\t\twork identically on all orbs with Any.extract_Streamable.");
        System.out.println("\t-quiet");
        System.out.println("\t\tSuppress any output. Same as -silence.");
        System.out.println("\t-release");
        System.out.println("\t\tShow version number.");
        System.out.println("\t-silence");
        System.out.println("\t\tSuppress any output. Same as -quiet.");
        System.out.println("\t-verbose");
        System.out.println("\t\tShow debug output.");
        System.out.println("\t-jdk1.4");
        System.out.println("\t\tGenerate classes that use JDK1.4 features.");
        System.out.println("\t\tThe generate classes will not compile on previous versions.");
        System.out.println("\t-invokeMethod <Classes|Reflection|Switch>");
        System.out.println("\t\tThe method used to implement the xxxPOA invoke method.");
        System.out.println("\t\tIf not specified Classes is used.");
        System.out.println("\t-minTableSize <size>");
        System.out.println("\t\tThe minimum size of method table.");
        System.out.println("\t-XgenerateValueFactory <impl postfix>");
        System.out.println("\t\tGenerate default value factories for valuetypes.");
        System.out.println("\t\tCreates instance of <valuetype name><impl postfix>.");
        System.out.println("\t-XgenerateValueImpl <postfix>");
        System.out.println("\t\tGeneratae default implementation of valuetypes.");
        System.out.println("\t\tCreates classes with name <valuetype name><postfix>.");
        System.out.println("");
        System.out.println("");
        System.exit(1);
    }

    public static void scan_arguments(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            block90: {
                if (stringArray[n].charAt(0) != '-') {
                    idl_file_name_list.addElement(stringArray[n]);
                } else if (stringArray[n].equals("-release")) {
                    System.out.println("OpenORB Version 1.3.0");
                    System.exit(1);
                } else if (stringArray[n].equals("-h") || stringArray[n].equals("-help")) {
                    IdlCompiler.display_help();
                } else if (stringArray[n].equals("-silence") || stringArray[n].equals("-quiet")) {
                    silentMode = true;
                } else if (stringArray[n].equals("-verbose")) {
                    verbose = true;
                } else if (stringArray[n].equals("-noprefix")) {
                    usePrefix = false;
                } else if (stringArray[n].equals("-noreverseprefix")) {
                    reversePrefix = false;
                } else if (stringArray[n].equals("-nostub")) {
                    map_stub = false;
                } else if (stringArray[n].equals("-nolocalstub")) {
                    local_stub = false;
                } else if (stringArray[n].equals("-noskeleton")) {
                    map_skeleton = false;
                } else if (stringArray[n].equals("-notie")) {
                    map_tie = false;
                } else if (stringArray[n].equals("-portablehelper")) {
                    portableHelper = true;
                } else if (stringArray[n].equals("-boa")) {
                    map_poa = false;
                } else if (stringArray[n].equals("-dynamic")) {
                    dynamic = true;
                } else if (stringArray[n].equals("-all")) {
                    map_all = true;
                } else if (stringArray[n].equals("-pidl")) {
                    pidl = true;
                    map_stub = false;
                    map_skeleton = false;
                    map_tie = false;
                } else if ("-jdk1.4".equals(stringArray[n])) {
                    jdk1_4 = true;
                } else if ("-XgenerateValueFactory".equals(stringArray[n])) {
                    if (n + 1 == stringArray.length) {
                        System.out.println("Argument expected after '-XgenerateValueFactory'");
                        System.exit(2);
                    }
                    generateValueFactory = stringArray[++n];
                } else if ("-XgenerateValueImpl".equals(stringArray[n])) {
                    if (n + 1 == stringArray.length) {
                        System.out.println("Argument expected after '-XgenerateValueImpl'");
                        System.exit(2);
                    }
                    generateValueImpl = stringArray[++n];
                } else if ("-invokeMethod".equals(stringArray[n])) {
                    if (n + 1 == stringArray.length) {
                        System.out.println("Argument expected after '-invokeMethod'");
                        System.exit(2);
                    }
                    useReflection = false;
                    useSwitch = false;
                    useClasses = false;
                    if ("Classes".equals(stringArray[++n])) {
                        useClasses = true;
                    } else if ("Reflection".equals(stringArray[n])) {
                        useReflection = true;
                    } else if ("Switch".equals(stringArray[n])) {
                        useSwitch = true;
                    } else {
                        System.out.println("'-invokeMethod' support arguments: 'Classes', 'Switch' and 'Reflection'");
                        System.exit(2);
                    }
                } else if ("-minTableSize".equals(stringArray[n])) {
                    if (n + 1 == stringArray.length) {
                        System.out.println("Argument expected after '-minTableSize'");
                        System.exit(2);
                    }
                    minTableSize = Integer.parseInt(stringArray[++n]);
                } else if (stringArray[n].equals("-package")) {
                    if (n + 1 == stringArray.length) {
                        System.out.println("Argument expected after '-package'");
                        System.exit(2);
                    }
                    packageName = stringArray[++n];
                    use_package = false;
                } else if (stringArray[n].equals("-importlink")) {
                    if (n + 1 == stringArray.length) {
                        System.out.println("Argument expected after '-importlink'");
                        System.exit(2);
                    }
                    importLink.addElement(stringArray[++n]);
                } else if (stringArray[n].equals("-d")) {
                    if (n + 1 == stringArray.length) {
                        System.out.println("Argument expected after '-d'");
                        System.exit(2);
                    }
                    outdir = stringArray[++n];
                    if (packageName == null) {
                        packageName = "";
                        use_package = false;
                    }
                } else if (stringArray[n].equals("-I")) {
                    if (++n == stringArray.length) {
                        System.out.println("Argument expected after '-I'");
                        System.exit(2);
                    }
                    URL uRL = null;
                    try {
                        uRL = new URL(stringArray[n]);
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            uRL = new File(stringArray[n]).toURL();
                        }
                        catch (MalformedURLException malformedURLException2) {
                            // empty catch block
                        }
                    }
                    if (uRL != null) {
                        includeList.addElement(uRL);
                    }
                } else if (stringArray[n].startsWith("-I")) {
                    String string = stringArray[n].substring(2);
                    URL uRL = null;
                    try {
                        uRL = new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            uRL = new File(string).toURL();
                        }
                        catch (MalformedURLException malformedURLException3) {
                            // empty catch block
                        }
                    }
                    if (uRL != null) {
                        includeList.addElement(uRL);
                    }
                } else if (stringArray[n].startsWith("-D")) {
                    try {
                        int n2 = stringArray[n].indexOf(61);
                        if (n2 < 0) {
                            definedMacros.put(stringArray[n].substring(2, stringArray[n].length()), "");
                            break block90;
                        }
                        definedMacros.put(stringArray[n].substring(2, n2), stringArray[n].substring(n2 + 1));
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                } else if (stringArray[n].equals("-native")) {
                    if (n + 2 == stringArray.length) {
                        System.out.println("Argument expected after '-native'");
                        System.exit(2);
                    }
                    nativeDefinition.addElement(stringArray[++n] + ":" + stringArray[++n]);
                } else if (displayBadFlag) {
                    System.out.println("Bad parameter : " + stringArray[n]);
                    System.out.println("Please, use no flag to display all compiler option flags");
                    System.exit(2);
                }
            }
            ++n;
        }
        if (outdir == null || outdir.equals("")) {
            outdir = new String("generated");
            if (packageName == null) {
                packageName = "";
                use_package = false;
            }
        }
        idl_file_name = new String[idl_file_name_list.size()];
        int n3 = 0;
        while (n3 < idl_file_name_list.size()) {
            IdlCompiler.idl_file_name[n3] = (String)idl_file_name_list.elementAt(n3);
            ++n3;
        }
    }

    public static void configFile() {
        Configurator configurator = null;
        try {
            Object obj = Thread.currentThread().getContextClassLoader().loadClass("org.openorb.compiler.orb.DefaultConfigurator").newInstance();
            configurator = (Configurator)obj;
        }
        catch (Exception exception) {
            return;
        }
        configurator.updateInfo(includeList, importLink);
    }

    public static void prepare() {
        definedMacros.put("__IDL_TO_JAVA__", "");
        definedMacros.put("__OPENORB__", "OpenORB Version 1.3.0");
        definedMacros.put("__OPENORB_MAJOR__", "1");
        definedMacros.put("__OPENORB_MINOR__", "3");
        definedMacros.put("__OPENORB_MINOR_CHANGE__", "0");
        definedMacros.put("__CORBA_IDL__", "2.4");
        definedMacros.put("__CORBA_MAJOR__", "2");
        definedMacros.put("__CORBA_MINOR__", "4");
        definedMacros.put("__CORBA_MINOR_CHANGE__", "2.4.2");
    }

    public static void compile_file(String string, IdlParser idlParser2) throws CompilationException {
        IdlObject idlObject2 = idlParser2.compile_idl(string);
        if (IdlParser.totalError != 0) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            System.exit(2);
        }
        if (verbose) {
            System.out.println("Now translate to Java...");
        }
        IdlToJava idlToJava = new IdlToJava();
        idlToJava.translateData(idlObject2, packageName);
        if (map_stub) {
            idlToJava.translateStub(idlObject2, packageName);
        }
        if (map_skeleton) {
            idlToJava.translateSkeleton(idlObject2, packageName);
        }
        if (map_tie) {
            idlToJava.translateTIE(idlObject2, packageName);
        }
    }

    public static IdlParser createIDLParser(String[] stringArray) {
        IdlCompiler.prepare();
        IdlCompiler.scan_arguments(stringArray);
        IdlCompiler.configFile();
        return new IdlParser();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            IdlCompiler.display_help();
        }
        IdlParser idlParser2 = IdlCompiler.createIDLParser(stringArray);
        if (idl_file_name.length == 0) {
            IdlCompiler.display_help();
        }
        if (!silentMode) {
            System.out.println("OpenORB  IDL To Java Compiler / (c) 2002 The Community OpenORB");
        }
        try {
            Hashtable hashtable = (Hashtable)definedMacros.clone();
            int n = 0;
            while (n < idl_file_name.length) {
                definedMacros = hashtable;
                if (!silentMode) {
                    System.out.println("compile : " + idl_file_name[n]);
                }
                IdlCompiler.compile_file(idl_file_name[n], idlParser2);
                ++n;
            }
        }
        catch (CompilationException compilationException) {
            System.out.println("there are errors...");
            System.out.println("compilation process stopped !");
            System.exit(2);
        }
    }

    static {
        idl_file_name_list = new Vector();
        map_stub = true;
        local_stub = true;
        map_skeleton = true;
        map_all = false;
        map_tie = true;
        map_user = false;
        pidl = false;
        map_poa = true;
        verbose = false;
        packageName = null;
        use_package = false;
        portableHelper = false;
        outdir = null;
        dynamic = false;
        usePrefix = true;
        silentMode = false;
        displayBadFlag = true;
        reversePrefix = true;
        useClasses = true;
        minTableSize = 9;
    }
}

