/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.SystemException;
import org.openorb.CORBA.kernel.Properties;
import org.openorb.util.ExceptionTool;

public class Property {
    private final String m_name;
    private final String m_value;
    private Object m_typed = null;
    private Properties m_props = null;

    Property(String string, String string2, Properties properties) {
        this.m_name = string;
        this.m_value = string2;
        this.m_props = properties;
    }

    Property(String string, String string2, Object object) {
        this.m_name = string;
        this.m_value = string2;
        this.m_typed = object;
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public int getIntValue() {
        int n;
        if (this.m_typed != null && this.m_typed instanceof Integer) {
            return (Integer)this.m_typed;
        }
        int n2 = 10;
        String string = this.m_value;
        if (string.startsWith("0x") && string.length() > 2) {
            n2 = 16;
            string = string.substring(2);
        } else if (string.startsWith("-0x") && string.length() > 3) {
            n2 = 16;
            string = "-" + string.substring(3);
        } else if (string.startsWith("0") || string.startsWith("-0")) {
            n2 = 8;
        }
        try {
            n = Integer.parseInt(string, n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw ExceptionTool.initCause((SystemException)new INITIALIZE("The property value \"" + this.m_name + "\" cannot be parsed as an integer (" + numberFormatException + ")"), (Throwable)numberFormatException);
        }
        this.m_typed = new Integer(n);
        return n;
    }

    public boolean getBooleanValue() {
        if (this.m_typed != null && this.m_typed instanceof Boolean) {
            return (Boolean)this.m_typed;
        }
        boolean bl = !this.m_value.equalsIgnoreCase("false") && !this.m_value.equalsIgnoreCase("no");
        this.m_typed = new Boolean(bl);
        return bl;
    }

    public Class getClassValue() {
        if (this.m_typed != null && this.m_typed instanceof Class) {
            return (Class)this.m_typed;
        }
        try {
            Class<?> clazz;
            this.m_typed = clazz = Thread.currentThread().getContextClassLoader().loadClass(this.m_value);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ExceptionTool.initCause((SystemException)new INITIALIZE("The property value \"" + this.m_name + "\" cannot be loaded as a class (" + classNotFoundException + ")"), (Throwable)classNotFoundException);
        }
    }

    public URL getURLValue() {
        if (this.m_typed != null && this.m_typed instanceof URL) {
            return (URL)this.m_typed;
        }
        String string = this.m_props.formatString(this.m_value);
        try {
            URL uRL = new URL(string);
            this.m_typed = uRL;
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.exists()) {
                try {
                    URL uRL = file.toURL();
                    this.m_typed = uRL;
                    return uRL;
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
            throw ExceptionTool.initCause((SystemException)new INITIALIZE("The property value \"" + this.m_name + "\" cannot be parsed as a URL (" + malformedURLException + ")"), (Throwable)malformedURLException);
        }
    }
}

