/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.openorb.CORBA.kernel.Properties;
import org.openorb.util.ExceptionTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Configurator {
    private Properties m_props = new Properties();
    private static final String[] SPECIAL_PROPS = new String[]{"openorb.home", "openorb.config", "openorb.profile", "OpenORB", "openorb.dir", "Config", "Profile"};
    private boolean m_ignoreXML = false;
    private URL m_currDoc = null;
    private HashMap m_initializedModules = new HashMap();
    private HashMap m_parsedFiles = new HashMap();
    private HashMap m_cmdLineAlias = new HashMap();
    private Set m_initializers = new HashSet();
    private static final String CONFIG_NS = "http://openorb.sf.net/config";
    private static final String CONFIG_DTD = "http://openorb.sf.net/config/OpenORB.dtd";
    private static final String CONFIG_PUBLIC = "-//openorb.sf.net//OpenORB Config//EN";
    private Logger m_logger;
    private DocumentBuilder m_parser;
    private static final String ORB_INITIALIZER_PATTERN = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private static final String FEATURE_INITIALIZER_PATTERN = "org.openorb.PI.FeatureInitializerClass.";
    static /* synthetic */ Class class$org$openorb$ReleaseInfo;

    public Configurator(String[] stringArray, java.util.Properties properties, Logger logger) {
        this.m_logger = logger;
        this.m_props.enableLogging(this.getLogger());
        this.setupHandler(logger);
        java.util.Properties properties2 = this.getORBProperties();
        java.util.Properties properties3 = null;
        try {
            properties3 = System.getProperties();
        }
        catch (SecurityException securityException) {
            logger.warn("Security settings do not allow reading system properties.The ORB may not work properly in this case.");
        }
        this.m_ignoreXML = this.getIgnoreXMLPropertySetting(properties2, properties3, properties);
        this.parseSpecialArgs(stringArray, properties, properties2);
        if (!this.m_ignoreXML) {
            this.m_currDoc = this.findRootConfig();
            this.handleXMLImport(this.m_currDoc);
        }
        if (properties2 != null) {
            this.addProperties("", properties2);
        }
        if (properties3 != null) {
            this.addProperties("", properties3);
        }
        if (properties != null) {
            this.addProperties("", properties);
        }
        if (stringArray != null) {
            this.m_cmdLineAlias.put("SrvName", "openorb.server.alias");
            this.m_cmdLineAlias.put("Debug", "openorb.debug.level");
            this.m_cmdLineAlias.put("Trace", "openorb.debug.trace");
            this.m_cmdLineAlias.put("DefaultInitialReference", "openorb.defaultInitialReference");
            this.parseArgs(stringArray);
        }
        this.addProperty("openorb.major", Short.toString((short)1));
        this.addProperty("openorb.minor", Short.toString((short)3));
        this.addProperty("openorb.minor.change", Short.toString((short)0));
        this.addProperty("openorb.version", "1.3.0");
        this.addProperty("corba.major", Short.toString((short)2));
        this.addProperty("corba.minor", Short.toString((short)4));
        this.addProperty("corba.minor.change", Short.toString((short)2));
        this.addProperty("corba.version", "2.4.2");
        this.addProperty("version", "1.3.0");
        this.addProperty("release", "OpenORB Version 1.3.0");
        this.addProperty("release.tag", "OpenORB_1_3_0");
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    public Properties getProperties() {
        return this.m_props;
    }

    public String[] getInitializers() {
        String[] stringArray = new String[this.m_initializers.size()];
        this.m_initializers.toArray(stringArray);
        return stringArray;
    }

    public URL addFragment(URL uRL, String string) throws MalformedURLException {
        String string2 = uRL.toString();
        int n = string2.indexOf(35);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (string == null) {
            return new URL(string2);
        }
        return new URL(string2 + '#' + string.toLowerCase());
    }

    private void addProperty(String string, String string2) {
        String string3 = string.toLowerCase();
        int n = 0;
        while (n < SPECIAL_PROPS.length) {
            if (string3.startsWith(SPECIAL_PROPS[n])) {
                return;
            }
            ++n;
        }
        if (string.startsWith("org.openorb.")) {
            if (string.startsWith("org.openorb.messaging.MessagingInitializerClass.")) {
                System.err.println("Non-standard initializer specification is deprecated: org.openorb.messaging.MessagingInitializerClass.");
                if (string.length() >= "org.openorb.messaging.MessagingInitializerClass.".length()) {
                    if (this.m_initializedModules.containsKey(string)) {
                        this.m_initializers.remove(this.m_initializedModules.get(string));
                    }
                    this.m_initializedModules.put(string, string2);
                }
                this.m_initializers.add(string2);
            } else if (string.startsWith("org.openorb.rmi.InitializerClass.")) {
                System.err.println("Non-standard initializer specification is deprecated: org.openorb.rmi.InitializerClass.");
                if (string.length() >= "org.openorb.rmi.InitializerClass.".length()) {
                    if (this.m_initializedModules.containsKey(string)) {
                        this.m_initializers.remove(this.m_initializedModules.get(string));
                    }
                    this.m_initializedModules.put(string, string2);
                }
                this.m_initializers.add(string2);
            } else if (string.startsWith("org.openorb.iiop.IIOPProtocolInitializerClass.")) {
                System.err.println("Non-standard initializer specification is deprecated: org.openorb.iiop.IIOPProtocolInitializerClass.");
                if (string.length() >= "org.openorb.iiop.IIOPProtocolInitializerClass.".length()) {
                    if (this.m_initializedModules.containsKey(string)) {
                        this.m_initializers.remove(this.m_initializedModules.get(string));
                    }
                    this.m_initializedModules.put(string, string2);
                }
                this.m_initializers.add(string2);
            } else if (string.startsWith("org.openorb.adapter.fwd.ForwardInitializerClass.")) {
                System.err.println("Non-standard initializer specification is deprecated: org.openorb.adapter.fwd.ForwardInitializerClass.");
                if (string.length() >= "org.openorb.adapter.fwd.ForwardInitializerClass.".length()) {
                    if (this.m_initializedModules.containsKey(string)) {
                        this.m_initializers.remove(this.m_initializedModules.get(string));
                    }
                    this.m_initializedModules.put(string, string2);
                }
                this.m_initializers.add(string2);
            } else if (string.startsWith("org.openorb.adapter.boa.BOAInitializerClass.")) {
                System.err.println("Non-standard initializer specification is deprecated: org.openorb.adapter.boa.BOAInitializerClass.");
                if (string.length() >= "org.openorb.adapter.boa.BOAInitializerClass.".length()) {
                    if (this.m_initializedModules.containsKey(string)) {
                        this.m_initializers.remove(this.m_initializedModules.get(string));
                    }
                    this.m_initializedModules.put(string, string2);
                }
                this.m_initializers.add(string2);
            } else if (string.startsWith("org.openorb.adapter.poa.POAInitializerClass.")) {
                System.err.println("Non-standard initializer specification is deprecated: org.openorb.adapter.poa.POAInitializerClass.");
                if (string.length() >= "org.openorb.adapter.poa.POAInitializerClass.".length()) {
                    if (this.m_initializedModules.containsKey(string)) {
                        this.m_initializers.remove(this.m_initializedModules.get(string));
                    }
                    this.m_initializedModules.put(string, string2);
                }
                this.m_initializers.add(string2);
            } else if (string.startsWith(FEATURE_INITIALIZER_PATTERN)) {
                String string4 = string.substring(FEATURE_INITIALIZER_PATTERN.length());
                this.m_initializers.add(string4);
            }
        } else if (string.startsWith(ORB_INITIALIZER_PATTERN)) {
            String string5 = string.substring(ORB_INITIALIZER_PATTERN.length());
            this.m_initializers.add(string5);
        } else if (string.startsWith("ImportModule") && !this.m_ignoreXML) {
            URL uRL;
            try {
                uRL = new URL(this.m_props.formatString(string2));
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL(this.m_props.formatString("${openorb.config}#" + string2));
                }
                catch (MalformedURLException malformedURLException2) {
                    this.getLogger().error("Malformed URL in ImportModule", (Throwable)malformedURLException2);
                    throw ExceptionTool.initCause((SystemException)new INITIALIZE("Malformed URL in ImportModule (" + malformedURLException2 + ")"), (Throwable)malformedURLException);
                }
            }
            this.handleURLImport(uRL);
        } else {
            this.m_props.addProperty(string, string2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addProperties(String var1_1, java.util.Properties var2_2) {
        if (var2_2 == null) {
            return;
        }
        try {
            var3_3 = var2_2.propertyNames();
            if (true) ** GOTO lbl17
        }
        catch (SecurityException var4_4) {
            return;
        }
        do {
            var4_5 = null;
            try {
                var4_5 = (String)var3_3.nextElement();
                if (var4_5.startsWith("sun.") || var4_5.startsWith("os.") || var4_5.startsWith("awt.") || var4_5.startsWith("java.")) continue;
                this.addProperty(var1_1 + var4_5, var2_2.getProperty(var4_5));
            }
            catch (SecurityException var5_6) {
                this.getLogger().warn("The property '" + var4_5 + "' could not be added to the internal" + " property set due to security reasons. (" + var5_6 + ")");
            }
lbl17:
            // 4 sources

        } while (var3_3.hasMoreElements());
    }

    private void setupHandler(Logger logger) {
        block5: {
            try {
                String string = System.getProperty("java.protocol.handler.pkgs");
                if (string == null) {
                    System.setProperty("java.protocol.handler.pkgs", "org.openorb.util.urlhandler");
                } else if (string.indexOf("java.protocol.handler.pkgs") < 0) {
                    System.setProperty("java.protocol.handler.pkgs", string + "|" + "org.openorb.util.urlhandler");
                }
            }
            catch (SecurityException securityException) {
                if (logger == null) break block5;
                logger.warn("The URLHandler could not be set! The security settings do not allow system properties to be set! (" + securityException + ")");
            }
        }
    }

    private java.util.Properties getORBProperties() {
        String string;
        java.util.Properties properties = new java.util.Properties();
        try {
            string = System.getProperty("java.home");
        }
        catch (SecurityException securityException) {
            return null;
        }
        File file = new File(string + File.separator + "lib" + File.separator + "orb.properties");
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private URL parseURL(String string) {
        int n = (string = this.m_props.formatString(string)).lastIndexOf(35);
        if (n >= 0) {
            string = string.substring(0, n) + string.substring(n).toLowerCase();
        }
        try {
            return new URL(this.m_currDoc, string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private String parseSpecialArg(String string, String string2, String string3, String[] stringArray, java.util.Properties properties, java.util.Properties properties2) {
        String string4;
        if (stringArray != null) {
            int n = stringArray.length - 1;
            while (n >= 0) {
                if (stringArray[n] != null && stringArray[n].startsWith("-ORB")) {
                    String string5;
                    int n2 = stringArray[n].indexOf(61);
                    if (n2 >= 0) {
                        string5 = stringArray[n].substring(4, n2);
                        if (string5.equals(string3) || string5.equalsIgnoreCase(string + "." + string2)) {
                            return stringArray[n].substring(n2 + 1);
                        }
                    } else if (n + 1 < stringArray.length) {
                        n2 = stringArray[n + 1].indexOf(61);
                        if (n2 >= 0) {
                            if (stringArray[n].substring(4).equalsIgnoreCase(string) && stringArray[n + 1].substring(0, n2).equalsIgnoreCase(string2)) {
                                return stringArray[n + 1].substring(n2 + 1);
                            }
                        } else {
                            string5 = stringArray[n].substring(4);
                            if (string5.equals(string3) || string5.equalsIgnoreCase(string + "." + string2)) {
                                return stringArray[n + 1];
                            }
                        }
                    }
                }
                --n;
            }
        }
        String string6 = string + "." + string2;
        if (properties != null && (string4 = properties.getProperty(string6)) != null) {
            return string4;
        }
        try {
            String string7 = System.getProperty(string6);
            if (string7 != null) {
                return string7;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (properties2 != null) {
            return properties2.getProperty(string6);
        }
        return null;
    }

    private void parseSpecialArgs(String[] stringArray, java.util.Properties properties, java.util.Properties properties2) {
        URL uRL;
        String string = this.parseSpecialArg("openorb", "home", "OpenORB", stringArray, properties, properties2);
        if (string != null) {
            uRL = this.parseURL(string);
            if (uRL == null) {
                throw new INITIALIZE("Can't parse openorb.home property as a URL");
            }
            this.m_props.addProperty("openorb.home", uRL);
        } else {
            try {
                this.m_props.addProperty("openorb.home", new URL("resource:/org/openorb/"));
            }
            catch (MalformedURLException malformedURLException) {
                uRL = (class$org$openorb$ReleaseInfo == null ? (class$org$openorb$ReleaseInfo = Configurator.class$("org.openorb.ReleaseInfo")) : class$org$openorb$ReleaseInfo).getResource("ReleaseInfo.class");
                if (uRL != null) {
                    this.m_props.addProperty("openorb.home", uRL);
                }
                this.getLogger().error("Invalid URL in property openorb.home.", (Throwable)malformedURLException);
                throw ExceptionTool.initCause((SystemException)new INITIALIZE("Can't determine openorb.home property (" + malformedURLException + ")"), (Throwable)malformedURLException);
            }
        }
        string = this.parseSpecialArg("openorb", "config", "Config", stringArray, properties, properties2);
        if (string != null) {
            uRL = this.parseURL(string);
            if (uRL == null) {
                throw new INITIALIZE("Can't parse openorb.config property as a URL");
            }
            this.m_props.addProperty("openorb.config", uRL);
        }
        if ((string = this.parseSpecialArg("openorb", "profile", "Profile", stringArray, properties, properties2)) != null) {
            this.m_props.addProperty("openorb.profile", string);
        }
    }

    private URL findRootConfigIn(String string, String string2, String string3) {
        File file = null;
        try {
            file = new File(System.getProperty(string), string2);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (file != null && file.exists()) {
            try {
                URL uRL = file.toURL();
                this.m_props.addProperty("openorb.config", uRL);
                if (string3 != null) {
                    uRL = this.addFragment(uRL, string3);
                }
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private URL findRootConfig() {
        String string = this.m_props.getStringProperty("openorb.profile", null);
        URL uRL = this.m_props.getURLProperty("openorb.config", null);
        if (uRL != null) {
            if (uRL.getRef() == null && string != null) {
                try {
                    uRL = this.addFragment(uRL, string);
                }
                catch (MalformedURLException malformedURLException) {
                    this.getLogger().error("Invalid URL in property openorb.config.", (Throwable)malformedURLException);
                    throw ExceptionTool.initCause((SystemException)new INITIALIZE("Unable to parse profile from openorb.profile (" + malformedURLException + ")"), (Throwable)malformedURLException);
                }
            }
            return uRL;
        }
        uRL = this.findRootConfigIn("user.dir", "OpenORB.xml", string);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.findRootConfigIn("user.home", "OpenORB.xml", string);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.findRootConfigIn("user.home", ".OpenORB.xml", string);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.findRootConfigIn("java.home", "OpenORB.xml", string);
        if (uRL != null) {
            return uRL;
        }
        uRL = this.m_props.getURLProperty("openorb.home", null);
        if (uRL != null) {
            try {
                uRL = new URL(uRL, "config/OpenORB.xml");
                this.m_props.addProperty("openorb.config", uRL);
                if (string != null) {
                    uRL = this.addFragment(uRL, string);
                }
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        throw new INITIALIZE("Unable to locate OpenORB.xml");
    }

    private String handleURLImport(URL uRL) {
        String string = uRL.getFile();
        if (string.endsWith(".properties")) {
            return this.handlePropertiesImport(uRL);
        }
        if (!this.m_ignoreXML && string.endsWith(".xml")) {
            return this.handleXMLImport(uRL);
        }
        throw new INITIALIZE("Unknown type for URL \"" + uRL + "\"");
    }

    private String handlePropertiesImport(URL uRL) {
        if (this.m_initializedModules.containsKey(uRL)) {
            return uRL.getRef();
        }
        try {
            java.util.Properties properties = new java.util.Properties();
            properties.load(uRL.openStream());
            this.m_initializedModules.put(uRL, null);
            String string = uRL.getRef();
            if (string == null) {
                this.addProperties("", properties);
            } else {
                this.addProperties(string + ".", properties);
            }
            return string;
        }
        catch (IOException iOException) {
            String string = "Unable to read properties file from URL \"" + uRL + "\"";
            this.getLogger().error(string, (Throwable)iOException);
            throw ExceptionTool.initCause((SystemException)new INITIALIZE(string + " (" + iOException + ")"), (Throwable)iOException);
        }
    }

    private Document parseXML(URL uRL) {
        try {
            Document document = (Document)this.m_parsedFiles.get(uRL);
            if (document != null) {
                return document;
            }
            if (this.m_parser == null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.m_parser = documentBuilderFactory.newDocumentBuilder();
                this.m_parser.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String string, String string2) {
                        if (Configurator.CONFIG_PUBLIC.equals(string)) {
                            URL uRL = Configurator.this.parseURL("${openorb.home}config/OpenORB.dtd");
                            InputSource inputSource = new InputSource(uRL.toString());
                            try {
                                inputSource.setByteStream(uRL.openStream());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return inputSource;
                        }
                        return null;
                    }
                });
            }
            document = this.m_parser.parse(uRL.toString());
            this.m_parsedFiles.put(uRL, document);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "ParserConfigurationException while parsing XML File \"" + uRL + "\"";
            this.getLogger().error(string, (Throwable)parserConfigurationException);
            throw ExceptionTool.initCause((SystemException)new INITIALIZE(string + " (" + parserConfigurationException + ")"), (Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = "SAXException while parsing XML File \"" + uRL + "\"";
            this.getLogger().error(string, (Throwable)sAXException);
            throw ExceptionTool.initCause((SystemException)new INITIALIZE(string + " (" + sAXException + ")"), (Throwable)sAXException);
        }
        catch (IOException iOException) {
            String string = "IOException while parsing XML File \"" + uRL + "\"";
            this.getLogger().error(string, (Throwable)iOException);
            throw ExceptionTool.initCause((SystemException)new INITIALIZE(string + " (" + iOException + ")"), (Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleXMLImport(URL uRL) {
        String string;
        URL uRL2;
        block37: {
            String string2;
            block36: {
                Object object;
                block35: {
                    String string3;
                    block34: {
                        uRL2 = this.m_currDoc;
                        try {
                            Element element;
                            Object object2;
                            this.m_currDoc = uRL;
                            String string4 = uRL.getRef();
                            if (string4 != null) {
                                if (this.m_initializedModules.containsKey(uRL)) {
                                    if (this.m_initializedModules.get(uRL) == null) {
                                        String string5 = null;
                                        Object var12_7 = null;
                                        this.m_currDoc = uRL2;
                                        return string5;
                                    }
                                    string3 = string4;
                                    break block34;
                                }
                                try {
                                    this.m_currDoc = this.addFragment(uRL, null);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    String string6 = "Invalid URL : " + uRL;
                                    this.getLogger().error(string6, (Throwable)malformedURLException);
                                    throw ExceptionTool.initCause((SystemException)new INTERNAL(string6), (Throwable)malformedURLException);
                                }
                            }
                            Document document = this.parseXML(this.m_currDoc);
                            Element element2 = document.getDocumentElement();
                            if (string4 == null) {
                                object2 = null;
                                try {
                                    object2 = System.getProperty("user.name");
                                }
                                catch (SecurityException securityException) {
                                    // empty catch block
                                }
                                if (object2 != null) {
                                    object = element2.getElementsByTagName("associations");
                                    switch (object.getLength()) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            object = ((Element)object.item(0)).getElementsByTagName("association");
                                            int n = 0;
                                            while (n < object.getLength() && string4 == null) {
                                                element = (Element)object.item(n);
                                                if (!element.hasAttribute("profile")) {
                                                    throw new INITIALIZE("Association in \"" + this.m_currDoc + "\" is missing profile.");
                                                }
                                                StringTokenizer stringTokenizer = new StringTokenizer(element.getAttribute("user"));
                                                while (stringTokenizer.hasMoreTokens()) {
                                                    if (!stringTokenizer.nextToken().equals(object2)) continue;
                                                    string4 = element.getAttribute("profile");
                                                    break;
                                                }
                                                ++n;
                                            }
                                            break;
                                        }
                                        default: {
                                            throw new INITIALIZE("Document \"" + this.m_currDoc + "\" has multiple associaton elements");
                                        }
                                    }
                                }
                                if (string4 == null) {
                                    string4 = element2.hasAttribute("profile") ? element2.getAttribute("profile") : "default";
                                }
                                try {
                                    uRL = this.addFragment(uRL, string4);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    String string7 = "Unable to parse default profile name from \"" + this.m_currDoc + "\"";
                                    this.getLogger().error(string7, (Throwable)malformedURLException);
                                    throw ExceptionTool.initCause((SystemException)new INITIALIZE(string7), (Throwable)malformedURLException);
                                }
                                if (this.m_initializedModules.containsKey(uRL)) {
                                    if (this.m_initializedModules.get(uRL) == null) {
                                        object = null;
                                        break block35;
                                    }
                                    string2 = string4;
                                    break block36;
                                }
                            }
                            if (element2.hasAttribute("xml:base")) {
                                try {
                                    this.m_currDoc = new URL(this.m_currDoc, this.m_props.formatString(element2.getAttribute("xml:base")));
                                }
                                catch (MalformedURLException malformedURLException) {
                                    object = "The xml:base attribute of the xml file \"" + this.m_currDoc + "\" cannot be parsed";
                                    this.getLogger().error((String)object, (Throwable)malformedURLException);
                                    throw ExceptionTool.initCause((SystemException)new INITIALIZE((String)object), (Throwable)malformedURLException);
                                }
                            }
                            if ((object2 = document.getElementById(string4)) == null) {
                                object = element2.getChildNodes();
                                int n = 0;
                                while (n < object.getLength()) {
                                    Node node = object.item(n);
                                    if (node.getNodeType() == 1 && string4.equalsIgnoreCase((element = (Element)node).getAttribute("name"))) {
                                        object2 = element;
                                        break;
                                    }
                                    ++n;
                                }
                                if (object2 == null) {
                                    throw new INITIALIZE("Cannot find element \"" + uRL + "\"");
                                }
                            }
                            if (((String)(object = object2.getTagName())).equals("profile")) {
                                this.handleImportElem((Element)object2, uRL, true);
                                this.m_initializedModules.put(uRL, null);
                                string4 = null;
                            } else if (((String)object).equals("module")) {
                                if (object2.hasAttribute("initializer")) {
                                    this.m_initializers.add(object2.getAttribute("initializer"));
                                }
                                this.m_initializedModules.put(uRL, string4);
                            }
                            this.handleProperties((Element)object2, string4, uRL);
                            string = string4;
                            break block37;
                        }
                        catch (Throwable throwable) {
                            Object var12_12 = null;
                            this.m_currDoc = uRL2;
                            throw throwable;
                        }
                    }
                    Object var12_8 = null;
                    this.m_currDoc = uRL2;
                    return string3;
                }
                Object var12_9 = null;
                this.m_currDoc = uRL2;
                return object;
            }
            Object var12_10 = null;
            this.m_currDoc = uRL2;
            return string2;
        }
        Object var12_11 = null;
        this.m_currDoc = uRL2;
        return string;
    }

    private boolean handleProperties(Element element, String string, URL uRL) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string2 = element2.getTagName();
                if (string2.equals("import")) {
                    if (uRL == null) {
                        return false;
                    }
                    String string3 = this.handleImportElem(element2, uRL, false);
                    if (!this.handleProperties(element2, string3, null)) {
                        if (string3 == null) {
                            throw new INITIALIZE("Attempt to set properties from import of profile in \"" + uRL + "\"");
                        }
                        throw new INITIALIZE("Import statment in \"" + uRL + "\" has child import");
                    }
                } else if (string2.equals("property") || string2.equals("rootproperty")) {
                    if (string == null) {
                        if (uRL == null) {
                            return false;
                        }
                        throw new INITIALIZE("Profile \"" + uRL + "\" defines properties, disallowed");
                    }
                    this.handlePropertyElem(element2, string, uRL);
                } else if (string2.equals("propalias")) {
                    if (string == null) {
                        if (uRL == null) {
                            return false;
                        }
                        throw new INITIALIZE("Profile \"" + uRL + "\" defines propaliases, disallowed");
                    }
                    this.handlePropaliasElem(element2, string, uRL);
                } else if (string2.equals("propertyset")) {
                    if (string == null) {
                        if (uRL == null) {
                            return false;
                        }
                        throw new INITIALIZE("Profile \"" + uRL + "\" defines propertyset, disallowed");
                    }
                    this.handlePropertySet(element2, string, uRL);
                } else if (!string2.equals("description")) {
                    throw new INITIALIZE("Unknown element type " + string2 + " in \"" + uRL + "\"");
                }
            }
            ++n;
        }
        return true;
    }

    private Element nextElement(Node node) {
        while (node != null && node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        return (Element)node;
    }

    private String handleImportElem(Element element, URL uRL, boolean bl) {
        String string;
        URL uRL2;
        boolean bl2 = element.hasAttribute("extends");
        boolean bl3 = element.hasAttribute("module");
        boolean bl4 = element.hasAttribute("profile");
        boolean bl5 = element.hasAttribute("xlink:href");
        switch ((bl2 ? 1 : 0) + (bl3 ? 1 : 0) + (bl4 ? 1 : 0) + (bl5 ? 1 : 0)) {
            case 0: {
                if (!bl) {
                    throw new INITIALIZE("Import from \"" + uRL + "\" does not specify a target");
                }
                return null;
            }
            case 1: {
                if (bl5 || (bl ? bl2 : bl4 || bl3)) break;
                throw new INITIALIZE("Atribute " + (bl ? (bl4 ? "profile" : "module") : "extends") + " found when " + (bl ? "extends" : "profile or module") + " attribute is expected in \"" + uRL + "\"");
            }
            default: {
                throw new INITIALIZE("Multiple " + (bl ? "extends present in profile" : "import targets in module") + " at \"" + uRL + "\"");
            }
        }
        if (!bl5) {
            try {
                if (bl2) {
                    uRL2 = this.addFragment(uRL, element.getAttribute("extends"));
                }
                if (bl3) {
                    uRL2 = this.addFragment(uRL, element.getAttribute("module"));
                }
                if (bl4) {
                    uRL2 = this.addFragment(uRL, element.getAttribute("profile"));
                }
                throw new Error("Impossible state");
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = "Unable to parse " + (bl ? "extends" : "module") + " for " + (bl ? "profile" : "module import in") + " \"" + uRL + "\"";
                this.getLogger().error(string2, (Throwable)malformedURLException);
                throw ExceptionTool.initCause((SystemException)new INITIALIZE(string2), (Throwable)malformedURLException);
            }
        } else if (element.hasAttribute("xlink:href")) {
            string = element.getAttribute("xlink:href");
            uRL2 = this.parseURL(string);
            if (uRL2 == null) {
                throw new INITIALIZE("Unable to parse URL \"" + string + "\" from " + (bl ? "profile" : "module import in") + " \"" + uRL + "\"");
            }
        } else {
            if (!bl) {
                throw new INITIALIZE("Import from \"" + uRL + "\" does not specify a target");
            }
            return null;
        }
        string = this.handleURLImport(uRL2);
        if (bl) {
            if (string != null) {
                throw new INITIALIZE("Attempted to extend module \"" + uRL2 + "\" from profile \"" + uRL + "\"");
            }
        } else if (!bl5 && (string == null ? bl3 : bl4)) {
            throw new INITIALIZE("Attempted to import " + (string == null ? "profile" : "module") + "  \"" + uRL2 + "\" from " + (string == null ? "module" : "profile") + " \"" + uRL + "\"");
        }
        return string;
    }

    private void handlePropaliasElem(Element element, String string, URL uRL) {
        String string2 = element.getAttribute("name");
        if (string2.length() == 0) {
            throw new INITIALIZE("Propalias in \"" + uRL + "\" does not have a name");
        }
        String string3 = element.getAttribute("alias");
        if (string3.length() == 0) {
            throw new INITIALIZE("Propalias in \"" + uRL + "\" does not have an alias");
        }
        string2 = string + "." + string2;
        this.m_cmdLineAlias.put(string3, string2);
    }

    private void handlePropertyElem(Element element, String string, URL uRL) {
        String string2 = element.getAttribute("name");
        if (string2.length() == 0) {
            throw new INITIALIZE("Property in \"" + uRL + "\" does not have a name");
        }
        String string3 = element.hasAttribute("value") ? element.getAttribute("value") : "true";
        if (element.hasAttribute("root")) {
            String string4 = element.getAttribute("root");
            if (string4.equals("false")) {
                string2 = string + "." + string2;
            } else if (!string4.equals("true")) {
                throw new INITIALIZE("Property " + string2 + " in \"" + uRL + "\" has illegal value for root attribute");
            }
        } else if (!element.getTagName().equals("rootproperty")) {
            string2 = string + "." + string2;
        }
        this.addProperty(string2, string3);
    }

    private void handlePropertySet(Element element, String string, URL uRL) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && !(element2 = (Element)node).getTagName().equals("description")) {
                this.m_props.addProperty(string + "." + element.getAttribute("prefix") + "." + element2.getAttribute("name"), element2.getAttribute("value"));
            }
            ++n;
        }
    }

    private void parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && stringArray[n].startsWith("-ORB")) {
                String string;
                String string2;
                int n2 = stringArray[n].indexOf(61);
                if (n2 < 0) {
                    if (stringArray.length <= n + 1 || stringArray[n + 1] == null || stringArray[n + 1].startsWith("-")) {
                        string2 = stringArray[n].substring(4);
                        string = "true";
                    } else {
                        n2 = stringArray[n + 1].indexOf(61);
                        if (n2 < 0) {
                            string2 = stringArray[n].substring(4);
                            string = stringArray[n + 1];
                        } else {
                            string2 = stringArray[n].substring(4) + "." + stringArray[n + 1].substring(0, n2);
                            string = stringArray[n + 1].substring(n2 + 1);
                        }
                        ++n;
                    }
                } else {
                    string2 = stringArray[n].substring(4, n2);
                    string = stringArray[n].substring(n2 + 1);
                }
                if (this.m_cmdLineAlias.containsKey(string2)) {
                    string2 = (String)this.m_cmdLineAlias.get(string2);
                }
                this.addProperty(string2, string);
            }
            ++n;
        }
    }

    private boolean getIgnoreXMLPropertySetting(java.util.Properties properties, java.util.Properties properties2, java.util.Properties properties3) {
        String string;
        boolean bl = false;
        String string2 = "openorb.ignoreXML";
        if (properties != null && (string = properties.getProperty(string2)) != null) {
            bl = Boolean.getBoolean(string.toLowerCase());
        }
        if (properties2 != null && (string = properties2.getProperty(string2)) != null) {
            bl = Boolean.getBoolean(string.toLowerCase());
        }
        if (properties3 != null && (string = properties3.getProperty(string2)) != null) {
            bl = Boolean.getBoolean(string.toLowerCase());
        }
        if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(string2 + "=" + bl);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

