/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseScorer;

final class SloppyPhraseScorer
extends PhraseScorer {
    private int slop;

    SloppyPhraseScorer(TermPositions[] termPositionsArray, int n, byte[] byArray, float f) throws IOException {
        super(termPositionsArray, byArray, f);
        this.slop = n;
    }

    protected final float phraseFreq() throws IOException {
        this.pq.clear();
        int n = 0;
        PhrasePositions phrasePositions = this.first;
        while (phrasePositions != null) {
            phrasePositions.firstPosition();
            if (phrasePositions.position > n) {
                n = phrasePositions.position;
            }
            this.pq.put(phrasePositions);
            phrasePositions = phrasePositions.next;
        }
        float f = 0.0f;
        boolean bl = false;
        do {
            PhrasePositions phrasePositions2 = (PhrasePositions)this.pq.pop();
            int n2 = phrasePositions2.position;
            int n3 = ((PhrasePositions)this.pq.top()).position;
            int n4 = n2;
            while (n4 <= n3) {
                n2 = n4;
                if (!phrasePositions2.nextPosition()) {
                    bl = true;
                    break;
                }
                n4 = phrasePositions2.position;
            }
            int n5 = n - n2;
            if (n5 <= this.slop) {
                f = (float)((double)f + 1.0 / (double)(n5 + 1));
            }
            if (phrasePositions2.position > n) {
                n = phrasePositions2.position;
            }
            this.pq.put(phrasePositions2);
        } while (!bl);
        return f;
    }
}

