/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocumentWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMDirectory;

public final class IndexWriter {
    private Directory directory;
    private Analyzer analyzer;
    private SegmentInfos segmentInfos = new SegmentInfos();
    private final Directory ramDirectory = new RAMDirectory();
    private Lock writeLock;
    public int maxFieldLength = 10000;
    public int mergeFactor = 10;
    public int maxMergeDocs = Integer.MAX_VALUE;
    public PrintStream infoStream = null;

    public IndexWriter(String string, Analyzer analyzer, boolean bl) throws IOException {
        this(FSDirectory.getDirectory(string, bl), analyzer, bl);
    }

    public IndexWriter(File file, Analyzer analyzer, boolean bl) throws IOException {
        this(FSDirectory.getDirectory(file, bl), analyzer, bl);
    }

    public IndexWriter(Directory directory, Analyzer analyzer, final boolean bl) throws IOException {
        this.directory = directory;
        this.analyzer = analyzer;
        Lock lock = this.directory.makeLock("write.lock");
        if (!lock.obtain()) {
            throw new IOException("Index locked for write: " + lock);
        }
        this.writeLock = lock;
        Directory directory2 = this.directory;
        synchronized (directory2) {
            new Lock.With(this.directory.makeLock("commit.lock")){

                public Object doBody() throws IOException {
                    if (bl) {
                        IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    } else {
                        IndexWriter.this.segmentInfos.read(IndexWriter.this.directory);
                    }
                    return null;
                }
            }.run();
        }
    }

    public final synchronized void close() throws IOException {
        this.flushRamSegments();
        this.ramDirectory.close();
        this.writeLock.release();
        this.writeLock = null;
        this.directory.close();
    }

    protected final void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public final synchronized int docCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.segmentInfos.size()) {
            SegmentInfo segmentInfo = this.segmentInfos.info(n2);
            n += segmentInfo.docCount;
            ++n2;
        }
        return n;
    }

    public final void addDocument(Document document) throws IOException {
        DocumentWriter documentWriter = new DocumentWriter(this.ramDirectory, this.analyzer, this.maxFieldLength);
        String string = this.newSegmentName();
        documentWriter.addDocument(string, document);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.segmentInfos.addElement(new SegmentInfo(string, 1, this.ramDirectory));
            this.maybeMergeSegments();
        }
    }

    private final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    public final synchronized void optimize() throws IOException {
        this.flushRamSegments();
        while (this.segmentInfos.size() > 1 || this.segmentInfos.size() == 1 && (SegmentReader.hasDeletions(this.segmentInfos.info(0)) || this.segmentInfos.info((int)0).dir != this.directory)) {
            int n = this.segmentInfos.size() - this.mergeFactor;
            this.mergeSegments(n < 0 ? 0 : n);
        }
    }

    public final synchronized void addIndexes(Directory[] directoryArray) throws IOException {
        this.optimize();
        int n = 0;
        while (n < directoryArray.length) {
            SegmentInfos segmentInfos = new SegmentInfos();
            segmentInfos.read(directoryArray[n]);
            int n2 = 0;
            while (n2 < segmentInfos.size()) {
                this.segmentInfos.addElement(segmentInfos.info(n2));
                ++n2;
            }
            ++n;
        }
        this.optimize();
    }

    private final void flushRamSegments() throws IOException {
        int n = this.segmentInfos.size() - 1;
        int n2 = 0;
        while (n >= 0 && this.segmentInfos.info((int)n).dir == this.ramDirectory) {
            n2 += this.segmentInfos.info((int)n).docCount;
            --n;
        }
        if (n < 0 || n2 + this.segmentInfos.info((int)n).docCount > this.mergeFactor || this.segmentInfos.info((int)(this.segmentInfos.size() - 1)).dir != this.ramDirectory) {
            ++n;
        }
        if (n >= this.segmentInfos.size()) {
            return;
        }
        this.mergeSegments(n);
    }

    private final void maybeMergeSegments() throws IOException {
        long l = this.mergeFactor;
        while (l <= (long)this.maxMergeDocs) {
            int n = this.segmentInfos.size();
            int n2 = 0;
            while (--n >= 0) {
                SegmentInfo segmentInfo = this.segmentInfos.info(n);
                if ((long)segmentInfo.docCount >= l) break;
                n2 += segmentInfo.docCount;
            }
            if ((long)n2 < l) break;
            this.mergeSegments(n + 1);
            l *= (long)this.mergeFactor;
        }
    }

    private final void mergeSegments(int n) throws IOException {
        Object object;
        String string = this.newSegmentName();
        int n2 = 0;
        if (this.infoStream != null) {
            this.infoStream.print("merging segments");
        }
        SegmentMerger segmentMerger = new SegmentMerger(this.directory, string);
        final Vector<SegmentReader> vector = new Vector<SegmentReader>();
        int n3 = n;
        while (n3 < this.segmentInfos.size()) {
            object = this.segmentInfos.info(n3);
            if (this.infoStream != null) {
                this.infoStream.print(" " + ((SegmentInfo)object).name + " (" + ((SegmentInfo)object).docCount + " docs)");
            }
            SegmentReader segmentReader = new SegmentReader((SegmentInfo)object);
            segmentMerger.add(segmentReader);
            if (segmentReader.directory == this.directory || segmentReader.directory == this.ramDirectory) {
                vector.addElement(segmentReader);
            }
            n2 += ((SegmentInfo)object).docCount;
            ++n3;
        }
        if (this.infoStream != null) {
            this.infoStream.println();
            this.infoStream.println(" into " + string + " (" + n2 + " docs)");
        }
        segmentMerger.merge();
        this.segmentInfos.setSize(n);
        this.segmentInfos.addElement(new SegmentInfo(string, n2, this.directory));
        object = this.directory;
        synchronized (object) {
            new Lock.With(this.directory.makeLock("commit.lock")){

                public Object doBody() throws IOException {
                    IndexWriter.this.segmentInfos.write(IndexWriter.this.directory);
                    IndexWriter.this.deleteSegments(vector);
                    return null;
                }
            }.run();
        }
    }

    private final void deleteSegments(Vector vector) throws IOException {
        Vector vector2 = new Vector();
        this.deleteFiles(this.readDeleteableFiles(), vector2);
        int n = 0;
        while (n < vector.size()) {
            SegmentReader segmentReader = (SegmentReader)vector.elementAt(n);
            if (segmentReader.directory == this.directory) {
                this.deleteFiles(segmentReader.files(), vector2);
            } else {
                this.deleteFiles(segmentReader.files(), segmentReader.directory);
            }
            ++n;
        }
        this.writeDeleteableFiles(vector2);
    }

    private final void deleteFiles(Vector vector, Directory directory) throws IOException {
        int n = 0;
        while (n < vector.size()) {
            directory.deleteFile((String)vector.elementAt(n));
            ++n;
        }
    }

    private final void deleteFiles(Vector vector, Vector vector2) throws IOException {
        int n = 0;
        while (n < vector.size()) {
            block4: {
                String string = (String)vector.elementAt(n);
                try {
                    this.directory.deleteFile(string);
                }
                catch (IOException iOException) {
                    if (!this.directory.fileExists(string)) break block4;
                    if (this.infoStream != null) {
                        this.infoStream.println(iOException.getMessage() + "; Will re-try later.");
                    }
                    vector2.addElement(string);
                }
            }
            ++n;
        }
    }

    private final Vector readDeleteableFiles() throws IOException {
        Vector<String> vector = new Vector<String>();
        if (!this.directory.fileExists("deletable")) {
            return vector;
        }
        InputStream inputStream = this.directory.openFile("deletable");
        try {
            int n = inputStream.readInt();
            while (n > 0) {
                vector.addElement(inputStream.readString());
                --n;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return vector;
    }

    private final void writeDeleteableFiles(Vector vector) throws IOException {
        OutputStream outputStream = this.directory.createFile("deleteable.new");
        try {
            outputStream.writeInt(vector.size());
            int n = 0;
            while (n < vector.size()) {
                outputStream.writeString((String)vector.elementAt(n));
                ++n;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
        this.directory.renameFile("deleteable.new", "deletable");
    }
}

