/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.CharStream;
import org.apache.lucene.analysis.standard.FastCharStream;
import org.apache.lucene.analysis.standard.ParseException;
import org.apache.lucene.analysis.standard.StandardTokenizerConstants;
import org.apache.lucene.analysis.standard.StandardTokenizerTokenManager;

public class StandardTokenizer
extends Tokenizer
implements StandardTokenizerConstants {
    public StandardTokenizerTokenManager token_source;
    public org.apache.lucene.analysis.standard.Token token;
    public org.apache.lucene.analysis.standard.Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[1];
    private final int[] jj_la1_0 = new int[]{255};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public StandardTokenizer(Reader reader) {
        this(new FastCharStream(reader));
        this.input = reader;
    }

    public final Token next() throws ParseException, IOException {
        org.apache.lucene.analysis.standard.Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                token = this.jj_consume_token(1);
                break;
            }
            case 2: {
                token = this.jj_consume_token(2);
                break;
            }
            case 3: {
                token = this.jj_consume_token(3);
                break;
            }
            case 4: {
                token = this.jj_consume_token(4);
                break;
            }
            case 5: {
                token = this.jj_consume_token(5);
                break;
            }
            case 6: {
                token = this.jj_consume_token(6);
                break;
            }
            case 7: {
                token = this.jj_consume_token(7);
                break;
            }
            case 0: {
                token = this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (token.kind == 0) {
            return null;
        }
        return new Token(token.image, token.beginColumn, token.endColumn, StandardTokenizerConstants.tokenImage[token.kind]);
    }

    public StandardTokenizer(CharStream charStream) {
        this.token_source = new StandardTokenizerTokenManager(charStream);
        this.token = new org.apache.lucene.analysis.standard.Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 1) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(CharStream charStream) {
        this.token_source.ReInit(charStream);
        this.token = new org.apache.lucene.analysis.standard.Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 1) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public StandardTokenizer(StandardTokenizerTokenManager standardTokenizerTokenManager) {
        this.token_source = standardTokenizerTokenManager;
        this.token = new org.apache.lucene.analysis.standard.Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 1) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(StandardTokenizerTokenManager standardTokenizerTokenManager) {
        this.token_source = standardTokenizerTokenManager;
        this.token = new org.apache.lucene.analysis.standard.Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 1) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    private final org.apache.lucene.analysis.standard.Token jj_consume_token(int n) throws ParseException {
        org.apache.lucene.analysis.standard.Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final org.apache.lucene.analysis.standard.Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final org.apache.lucene.analysis.standard.Token getToken(int n) {
        org.apache.lucene.analysis.standard.Token token = this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[14];
        int n2 = 0;
        while (n2 < 14) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 1) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 14) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, StandardTokenizerConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

