/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.subscriber;

import org.apache.altrmi.client.InterfaceLookup;
import org.apache.altrmi.client.LookupSource;
import org.apache.altrmi.client.impl.subscriber.AbstractInterfaceLookupFactory;
import org.apache.altrmi.client.impl.subscriber.ConnectionException;
import org.apache.altrmi.client.impl.subscriber.DefaultLookupPool;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;

public class DefaultLookupSource
extends AbstractLogEnabled
implements LookupSource,
Disposable,
Configurable,
ThreadSafe {
    protected DefaultLookupPool m_pool;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (null == this.m_pool) {
            int l_max;
            int l_min;
            Configuration controller = configuration.getChild("pool-controller");
            int min = controller.getAttributeAsInteger("min", 1);
            int max = controller.getAttributeAsInteger("max", 3);
            Configuration fconfig = configuration.getChild("factory");
            if (min < 1) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Min number of connections specified must be at least 1.");
                }
                l_min = 1;
            } else {
                l_min = min;
            }
            if (max < 1) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Max number of connections specified must be at least 1.");
                }
                l_max = 1;
            } else if (max < min) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Maximum number of connections specified must be more than the minimum number of connections.");
                }
                l_max = min + 1;
            } else {
                l_max = max;
            }
            try {
                DefaultPoolController poolController = new DefaultPoolController(l_max / 4);
                AbstractInterfaceLookupFactory factory = this.createFactory(fconfig);
                this.m_pool = new DefaultLookupPool(factory, poolController, l_min, l_max);
                this.m_pool.enableLogging(this.getLogger());
                this.m_pool.initialize();
            }
            catch (Exception e) {
                throw new ConfigurationException("Error configuring LookupSource", (Throwable)e);
            }
        }
    }

    private AbstractInterfaceLookupFactory createFactory(Configuration fconfig) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String className = fconfig.getAttribute("class");
        AbstractInterfaceLookupFactory factory = (AbstractInterfaceLookupFactory)((Object)loader.loadClass(className).newInstance());
        this.setupLogger((Object)factory);
        factory.configure(fconfig);
        return factory;
    }

    public InterfaceLookup get() {
        try {
            return (InterfaceLookup)this.m_pool.get();
        }
        catch (Exception e) {
            throw new ConnectionException(e.getMessage(), e);
        }
    }

    public void dispose() {
        this.m_pool.dispose();
        this.m_pool = null;
    }
}

