/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.subscriber;

import org.apache.altrmi.client.impl.subscriber.AbstractInterfaceLookupFactory;
import org.apache.altrmi.client.impl.subscriber.InterfaceLookupWrapper;
import org.apache.avalon.excalibur.pool.DefaultPoolController;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.SoftResourceLimitingPool;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;

public class DefaultLookupPool
extends SoftResourceLimitingPool
implements Disposable,
Initializable {
    private boolean m_noConnections = false;

    public DefaultLookupPool(AbstractInterfaceLookupFactory factory, DefaultPoolController controller, int min, int max) throws Exception {
        super((ObjectFactory)factory, (PoolController)controller, min, max);
    }

    public void initialize() throws Exception {
        this.grow(this.m_min);
        if (this.size() > 0) {
            this.m_initialized = true;
        } else {
            this.m_noConnections = true;
        }
    }

    protected final Poolable newPoolable() throws Exception {
        InterfaceLookupWrapper wrapper = (InterfaceLookupWrapper)super.newPoolable();
        wrapper.setPool((Pool)this);
        return wrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Poolable get() throws Exception {
        if (!this.m_initialized && this.m_noConnections) {
            throw new IllegalStateException("There are no connections in the pool, check your settings.");
        }
        InterfaceLookupWrapper obj = (InterfaceLookupWrapper)super.get();
        if (!obj.isBroken()) return obj;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("InterfaceLookup was broken, creating one to take its place");
        }
        try {
            try {
                super.lock();
                if (this.m_active.contains((Object)obj)) {
                    this.m_active.remove((Object)obj);
                }
                this.removePoolable(obj);
                obj = (InterfaceLookupWrapper)this.newPoolable();
                this.m_active.add(obj);
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) throw e;
                this.getLogger().warn("Could not get an open connection", (Throwable)e);
                throw e;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            super.unlock();
            throw throwable;
        }
        super.unlock();
        return obj;
    }
}

