/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.altrmi.client.ConnectionRefusedException;
import org.apache.altrmi.client.impl.ClientStreamReadWriter;
import org.apache.altrmi.client.impl.stream.StreamInvocationHandler;
import org.apache.altrmi.common.BadConnectionException;
import org.apache.altrmi.common.ConnectionException;

public abstract class AbstractSocketStreamInvocationHandler
extends StreamInvocationHandler {
    private final String m_host;
    private final int m_port;

    public AbstractSocketStreamInvocationHandler(String host, int port, ClassLoader classLoader) throws ConnectionException {
        super(classLoader);
        this.m_host = host;
        this.m_port = port;
        try {
            Socket socket = this.makeSocket();
            this.setObjectReadWriter(this.createClientStreamReadWriter(socket.getInputStream(), socket.getOutputStream()));
        }
        catch (IOException ioe) {
            if (ioe.getMessage().startsWith("Connection refused")) {
                throw new ConnectionRefusedException("Connection to port " + port + " on host " + host + " refused.");
            }
            throw new BadConnectionException("Cannot open Stream(s) for socket: " + ioe.getMessage());
        }
    }

    protected boolean tryReconnect() {
        try {
            Socket socket = this.makeSocket();
            this.setObjectReadWriter(this.createClientStreamReadWriter(socket.getInputStream(), socket.getOutputStream()));
            return true;
        }
        catch (ConnectionException ce) {
            return false;
        }
        catch (IOException ce) {
            return false;
        }
    }

    private Socket makeSocket() throws IOException {
        Socket socket = new Socket(this.m_host, this.m_port);
        socket.setSoTimeout(60000);
        return socket;
    }

    protected abstract ClientStreamReadWriter createClientStreamReadWriter(InputStream var1, OutputStream var2) throws ConnectionException;
}

