/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.rmi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.InvocationException;
import org.apache.altrmi.client.NoSuchReferenceException;
import org.apache.altrmi.client.NotPublishedException;
import org.apache.altrmi.client.impl.AbstractClientInvocationHandler;
import org.apache.altrmi.common.BadConnectionException;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.NoSuchReferenceReply;
import org.apache.altrmi.common.NotPublishedReply;
import org.apache.altrmi.common.PublishedNameRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.RmiInvocationHandler;
import org.apache.altrmi.common.TryLaterReply;

public final class RmiClientInvocationHandler
extends AbstractClientInvocationHandler {
    private RmiInvocationHandler m_rmiInvocationHandler;
    private String m_URL;
    private boolean m_methodLogging = false;
    private long m_lastRealRequest = System.currentTimeMillis();
    static /* synthetic */ Class class$org$apache$altrmi$common$RmiInvocationHandler;

    public RmiClientInvocationHandler(String host, int port) throws ConnectionException {
        this.m_URL = "rmi://" + host + ":" + port + "/" + (class$org$apache$altrmi$common$RmiInvocationHandler == null ? (class$org$apache$altrmi$common$RmiInvocationHandler = RmiClientInvocationHandler.class$("org.apache.altrmi.common.RmiInvocationHandler")) : class$org$apache$altrmi$common$RmiInvocationHandler).getName();
        try {
            this.m_rmiInvocationHandler = (RmiInvocationHandler)Naming.lookup(this.m_URL);
        }
        catch (NotBoundException nbe) {
            throw new ConnectionException("Cannot bind to the remote RMI service.  Either an IP or RMI issue.");
        }
        catch (MalformedURLException mfue) {
            throw new ConnectionException("Malformed URL, host/port (" + host + "/" + port + ") must be wrong: " + mfue.getMessage());
        }
        catch (ConnectIOException cioe) {
            throw new BadConnectionException("Cannot connect to remote RMI server. It is possible that transport mismatch");
        }
        catch (RemoteException re) {
            throw new ConnectionException("Unknown Remote Exception : " + re.getMessage());
        }
    }

    public void setClientMonitor(ClientMonitor connectionMonitor) {
        super.setClientMonitor(connectionMonitor);
        this.m_methodLogging = connectionMonitor.methodLogging();
    }

    protected boolean tryReconnect() {
        try {
            this.m_rmiInvocationHandler = (RmiInvocationHandler)Naming.lookup(this.m_URL);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Reply handleInvocation(Request request) {
        if (request.getRequestCode() != 306) {
            this.m_lastRealRequest = System.currentTimeMillis();
        }
        again = true;
        reply = null;
        tries = 0;
        start = 0L;
        if (this.m_methodLogging) {
            start = System.currentTimeMillis();
        }
        block2: while (again) {
            block9: {
                ++tries;
                again = false;
                try {
                    reply = this.m_rmiInvocationHandler.handleInvocation(request);
                    if (reply.getReplyCode() < 100) continue;
                    if (reply instanceof TryLaterReply) {
                        millis = ((TryLaterReply)reply).getSuggestedDelayMillis();
                        this.m_clientMonitor.serviceSuspended(this.getClass(), request, tries, millis);
                        again = true;
                        continue;
                    }
                    if (reply instanceof NoSuchReferenceReply) {
                        throw new NoSuchReferenceException(((NoSuchReferenceReply)reply).getReferenceID());
                    }
                    if (!(reply instanceof NotPublishedReply)) continue;
                    pnr = (PublishedNameRequest)request;
                    throw new NotPublishedException(pnr.getPublishedServiceName(), pnr.getObjectName());
                }
                catch (RemoteException re) {
                    if (!(re instanceof ConnectException | re instanceof ConnectIOException)) break block9;
                    retryConnectTries = 0;
                    this.m_rmiInvocationHandler = null;
                    ** while (!this.tryReconnect())
                }
lbl-1000:
                // 1 sources

                {
                    this.m_clientMonitor.serviceAbend(this.getClass(), retryConnectTries, (IOException)re);
                    ++retryConnectTries;
                    continue;
lbl33:
                    // 1 sources

                    continue block2;
                }
            }
            throw new InvocationException("Unknown RMI problem : " + re.getMessage());
        }
        if (this.m_methodLogging && request instanceof MethodRequest) {
            this.m_clientMonitor.methodCalled(this.getClass(), ((MethodRequest)request).getMethodSignature(), System.currentTimeMillis() - start, "");
        }
        return reply;
    }

    public long getLastRealRequest() {
        return this.m_lastRealRequest;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

