/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.altrmi.client.InterfaceLookup;
import org.apache.altrmi.client.InterfaceLookupFactory;
import org.apache.altrmi.client.impl.DefaultInterfaceLookupFactory;
import org.apache.altrmi.common.ConnectionException;

public class DefaultContext
implements Context {
    InterfaceLookupFactory m_altrmiInterfaceLookupFactory = new DefaultInterfaceLookupFactory();
    InterfaceLookup m_altrmiInterfaceLookup = null;

    DefaultContext(String host, String port, String transportStream, Hashtable env) throws NamingException {
        boolean optimize;
        String proxyDetails = null;
        ClassLoader interfacesClassLoader = null;
        proxyDetails = (String)env.get("proxy.type");
        if (proxyDetails == null) {
            proxyDetails = "S";
        } else if (proxyDetails.equals("ClientSideClasses")) {
            proxyDetails = "C";
        } else if (proxyDetails.equals("ServerSideClasses")) {
            proxyDetails = "S";
        } else {
            throw new NamingException("proxy.type should be 'ClientSideClasses' or 'ServerSideClasses', you specified " + proxyDetails);
        }
        String optimizeStr = (String)env.get("optimize");
        if (optimizeStr == null) {
            optimize = true;
        } else if (optimizeStr.equals("true")) {
            optimize = true;
        } else if (optimizeStr.equals("false")) {
            optimize = false;
        } else {
            throw new NamingException("optimize should be 'true' or 'false', you specified " + optimizeStr);
        }
        interfacesClassLoader = (ClassLoader)env.get("interfaces.classloader");
        if (interfacesClassLoader == null) {
            interfacesClassLoader = this.getClass().getClassLoader();
        }
        try {
            this.m_altrmiInterfaceLookup = this.m_altrmiInterfaceLookupFactory.getInterfaceLookup(transportStream + ":" + host + ":" + port + ":" + proxyDetails, interfacesClassLoader, optimize);
        }
        catch (ConnectionException ace) {
            ace.printStackTrace();
            throw new NamingException(ace.getMessage());
        }
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        try {
            return this.m_altrmiInterfaceLookup.lookup(name);
        }
        catch (ConnectionException ace) {
            throw new NamingException(ace.getMessage());
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void unbind(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void unbind(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration list(String name) throws NamingException {
        final String[] names = this.m_altrmiInterfaceLookup.list();
        return new NamingEnumeration(){
            int size;
            int index;
            {
                this.size = names.length;
                this.index = 0;
            }

            public void close() {
            }

            public boolean hasMore() {
                return this.index < names.length;
            }

            public Object next() {
                return names[this.index++];
            }

            public boolean hasMoreElements() {
                return this.hasMore();
            }

            public Object nextElement() {
                return this.next();
            }
        };
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new UnsupportedOperationException();
    }

    public void close() throws NamingException {
        this.m_altrmiInterfaceLookup.close();
    }

    public String getNameInNamespace() throws NamingException {
        throw new UnsupportedOperationException();
    }
}

