/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.direct;

import java.io.IOException;
import org.apache.altrmi.client.ClientMonitor;
import org.apache.altrmi.client.InvocationException;
import org.apache.altrmi.client.NoSuchReferenceException;
import org.apache.altrmi.client.NotPublishedException;
import org.apache.altrmi.client.impl.AbstractClientInvocationHandler;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.NoSuchReferenceReply;
import org.apache.altrmi.common.NotPublishedReply;
import org.apache.altrmi.common.PublishedNameRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.TryLaterReply;

public abstract class AbstractDirectInvocationHandler
extends AbstractClientInvocationHandler {
    protected boolean m_methodLogging = false;
    protected long m_lastRealRequest = System.currentTimeMillis();

    public void setClientMonitor(ClientMonitor connectionMonitor) {
        super.setClientMonitor(connectionMonitor);
        this.m_methodLogging = connectionMonitor.methodLogging();
    }

    public Reply handleInvocation(Request request) {
        if (request.getRequestCode() != 306) {
            this.m_lastRealRequest = System.currentTimeMillis();
        }
        boolean again = true;
        Reply reply = null;
        int tries = 0;
        long start = 0L;
        if (this.m_methodLogging) {
            start = System.currentTimeMillis();
        }
        while (again) {
            ++tries;
            again = false;
            try {
                reply = this.performInvocation(request);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (reply.getReplyCode() < 100) continue;
            if (reply instanceof TryLaterReply) {
                int millis = ((TryLaterReply)reply).getSuggestedDelayMillis();
                this.m_clientMonitor.serviceSuspended(this.getClass(), request, tries, millis);
                again = true;
                continue;
            }
            if (reply instanceof NoSuchReferenceReply) {
                throw new NoSuchReferenceException(((NoSuchReferenceReply)reply).getReferenceID());
            }
            if (!(reply instanceof NotPublishedReply)) continue;
            PublishedNameRequest pnr = (PublishedNameRequest)request;
            throw new NotPublishedException(pnr.getPublishedServiceName(), pnr.getObjectName());
        }
        if (this.m_methodLogging && request instanceof MethodRequest) {
            this.m_clientMonitor.methodCalled(this.getClass(), ((MethodRequest)request).getMethodSignature(), System.currentTimeMillis() - start, "");
        }
        return reply;
    }

    protected boolean tryReconnect() {
        throw new InvocationException("Direct connection broken, unable to reconnect.");
    }

    public long getLastRealRequest() {
        return this.m_lastRealRequest;
    }

    protected abstract Reply performInvocation(Request var1) throws IOException;
}

