/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl.callback.stream;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.HashMap;
import org.apache.altrmi.client.InvocationException;
import org.apache.altrmi.client.impl.ClientStreamReadWriter;
import org.apache.altrmi.common.CallbackException;
import org.apache.altrmi.common.ClientInvocationAbendReply;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.ExceptionReply;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.ReqRepBytes;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.SerializationHelper;
import org.apache.altrmi.common.ThreadContext;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.server.ClassRetriever;
import org.apache.altrmi.server.PublicationException;
import org.apache.altrmi.server.Server;
import org.apache.altrmi.server.ServerException;
import org.apache.altrmi.server.impl.classretrievers.PlainClassRetriever;
import org.apache.altrmi.server.impl.direct.DirectServer;

public class CallbackEnabledClientCustomStreamReadWriter
implements ClientStreamReadWriter,
Runnable {
    private Object m_replyLock = new Object();
    private boolean m_replyLockSyncedOn;
    private Reply m_reply = null;
    private ThreadContext m_messageLoopThreadContext = null;
    private boolean m_isStopped = false;
    private DataInputStream m_dataInputStream;
    private DataOutputStream m_dataOutputStream;
    private ClassLoader m_interfacesClassLoader;
    private HashMap m_exposedObjPublishNameHash_ = new HashMap();
    private Server m_clientServerHostingExposedObjects = new DirectServer();
    private static int m_random = 0;
    private ThreadPool m_threadPool;

    public CallbackEnabledClientCustomStreamReadWriter(ThreadPool threadPool, InputStream inputStream, OutputStream outputStream, ClassLoader interfacesClassLoader) throws ConnectionException {
        this.m_threadPool = threadPool;
        this.m_dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.m_dataInputStream = new DataInputStream(inputStream);
        this.m_interfacesClassLoader = interfacesClassLoader;
        this.m_messageLoopThreadContext = this.m_threadPool.getThreadContext((Runnable)this);
        this.m_messageLoopThreadContext.start();
        try {
            this.m_clientServerHostingExposedObjects.start();
            this.m_clientServerHostingExposedObjects.setClassRetriever((ClassRetriever)new PlainClassRetriever());
        }
        catch (ServerException e) {
            throw new ConnectionException("Error Starting Internal Server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.m_isStopped) {
            ReqRepBytes reqRepBytes = ReqRepBytes.getRequestReplyBytesFromDataStream((DataInputStream)this.m_dataInputStream);
            if (reqRepBytes.getIOException() != null && reqRepBytes.ioeDuringReadInt()) {
                IOException ioe = reqRepBytes.getIOException();
                if (ioe instanceof EOFException && reqRepBytes.ioeDuringReadInt() || ioe instanceof SocketException) {
                    if (this.m_replyLockSyncedOn) {
                        this.m_reply = new ClientInvocationAbendReply(ioe);
                        Object object = this.m_replyLock;
                        synchronized (object) {
                            this.m_replyLock.notify();
                        }
                    }
                    this.m_isStopped = true;
                    return;
                }
                System.out.println("--> ##1 " + reqRepBytes.getIOException());
            }
            if (!reqRepBytes.isRequest()) {
                if (reqRepBytes.hadIOE()) {
                    this.m_reply = new ExceptionReply((Throwable)new InvocationException("IOException", (Throwable)reqRepBytes.getIOException()));
                } else {
                    try {
                        this.m_reply = (Reply)SerializationHelper.getInstanceFromBytes((byte[])reqRepBytes.getBytes(), (ClassLoader)this.m_interfacesClassLoader);
                    }
                    catch (ClassNotFoundException e) {
                        this.m_reply = new ExceptionReply((Throwable)new InvocationException("ClassNotFoundException", (Throwable)e));
                    }
                }
                Object e = this.m_replyLock;
                synchronized (e) {
                    this.m_replyLock.notify();
                    continue;
                }
            }
            if (!reqRepBytes.isRequest()) continue;
            Object obj = null;
            ClientInvocationAbendReply reply = null;
            if (reqRepBytes.hadIOE()) {
                reply = new ClientInvocationAbendReply(reqRepBytes.getIOException());
                try {
                    this.postReply((Reply)reply);
                }
                catch (IOException e) {}
                continue;
            }
            try {
                try {
                    obj = SerializationHelper.getInstanceFromBytes((byte[])reqRepBytes.getBytes(), (ClassLoader)this.m_interfacesClassLoader);
                    reply = this.m_clientServerHostingExposedObjects.handleInvocation((Request)obj, (Object)"callback");
                }
                catch (ClassNotFoundException e) {
                    reply = new ExceptionReply((Throwable)new InvocationException("ClassNotFoundException", (Throwable)e));
                }
                this.postReply((Reply)reply);
            }
            catch (IOException ioe) {
                if (!(ioe instanceof EOFException)) continue;
                this.m_isStopped = true;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply getReplyFromMessageLoop() {
        if (this.m_reply == null) {
            Object object = this.m_replyLock;
            synchronized (object) {
                this.m_replyLockSyncedOn = true;
                try {
                    this.m_replyLock.wait();
                }
                catch (InterruptedException e) {
                    System.out.println("--> InterrupedException ");
                    e.printStackTrace();
                }
                this.m_replyLockSyncedOn = false;
            }
        }
        return this.m_reply;
    }

    public Reply postRequest(Request request) throws IOException, ClassNotFoundException {
        if (this.m_isStopped && request.getRequestCode() != 308) {
            throw new IOException("Server Stoppped ? " + request.getClass().getName());
        }
        this.writeRequest(request);
        Reply r = this.readReply();
        this.m_reply = null;
        return r;
    }

    private void writeRequest(Request altrmiRequest) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiRequest);
        this.m_dataOutputStream.writeInt(aBytes.length);
        this.m_dataOutputStream.writeBoolean(true);
        this.m_dataOutputStream.write(aBytes);
        this.m_dataOutputStream.flush();
    }

    private Reply readReply() {
        return this.getReplyFromMessageLoop();
    }

    public void postReply(Reply altrmiReply) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiReply);
        this.m_dataOutputStream.writeInt(aBytes.length);
        this.m_dataOutputStream.writeBoolean(false);
        this.m_dataOutputStream.write(aBytes);
        this.m_dataOutputStream.flush();
    }

    public boolean exposeObject(Object tobeExposedObject, Class tobeExposedInterface) throws CallbackException {
        if (this.m_exposedObjPublishNameHash_.get(tobeExposedObject) != null) {
            return false;
        }
        String _uniquePublishedName = this.getUniqueNameForExposedObject(tobeExposedObject);
        this.m_exposedObjPublishNameHash_.put(tobeExposedObject, _uniquePublishedName);
        try {
            this.m_clientServerHostingExposedObjects.publish(tobeExposedObject, _uniquePublishedName, tobeExposedInterface);
        }
        catch (PublicationException pce) {
            throw new CallbackException(pce.getMessage());
        }
        return true;
    }

    private String getUniqueNameForExposedObject(Object tobeExposedObject) {
        return tobeExposedObject.getClass().getName().substring(tobeExposedObject.getClass().getName().lastIndexOf(".") + 1) + "_" + ++m_random;
    }

    public String getPublishedName(Object tobeExposedObject) {
        return (String)this.m_exposedObjPublishNameHash_.get(tobeExposedObject);
    }
}

