/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.altrmi.client.NotPublishedException;
import org.apache.altrmi.client.impl.AbstractFactory;
import org.apache.altrmi.client.impl.DefaultProxyHelper;
import org.apache.altrmi.client.impl.TransportedClassLoader;
import org.apache.altrmi.common.ClassReply;
import org.apache.altrmi.common.ClassRequest;
import org.apache.altrmi.common.ClassRetrievalFailedReply;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.RequestFailedReply;

public class ServerSideClassFactory
extends AbstractFactory {
    private HashMap m_publishedServiceClassLoaders = new HashMap();

    public ServerSideClassFactory(boolean unused) {
    }

    public ServerSideClassFactory() {
    }

    protected Class getFacadeClass(String publishedServiceName, String objectName) throws ConnectionException, ClassNotFoundException {
        TransportedClassLoader tcl = null;
        String proxyClassName = "AltrmiGenerated" + publishedServiceName + "_" + objectName;
        if (this.m_publishedServiceClassLoaders.containsKey(proxyClassName)) {
            tcl = (TransportedClassLoader)this.m_publishedServiceClassLoaders.get(proxyClassName);
        } else {
            ClassReply cr = null;
            try {
                Reply ar = this.m_hostContext.getClientInvocationHandler().handleInvocation((Request)new ClassRequest(publishedServiceName, objectName));
                if (ar.getReplyCode() >= 100) {
                    if (ar instanceof RequestFailedReply) {
                        throw new ConnectionException(((RequestFailedReply)ar).getFailureReason());
                    }
                    if (ar instanceof ClassRetrievalFailedReply) {
                        ClassRetrievalFailedReply crfr = (ClassRetrievalFailedReply)ar;
                        throw new ConnectionException("Class Retrieval Failed - " + crfr.getReason());
                    }
                }
                cr = (ClassReply)ar;
            }
            catch (NotPublishedException npe) {
                throw new ConnectionException("Service " + publishedServiceName + " not published on Server");
            }
            tcl = new TransportedClassLoader(this.m_hostContext.getClientInvocationHandler().getInterfacesClassLoader());
            tcl.add(proxyClassName, cr.getProxyClassBytes());
            this.m_publishedServiceClassLoaders.put(proxyClassName, tcl);
        }
        return tcl.loadClass(proxyClassName);
    }

    protected Object getInstance(String publishedServiceName, String objectName, DefaultProxyHelper proxyHelper) throws ConnectionException {
        try {
            Class clazz = this.getFacadeClass(publishedServiceName, objectName);
            Constructor<?>[] constructors = clazz.getConstructors();
            Object retVal = constructors[0].newInstance(proxyHelper);
            return retVal;
        }
        catch (InvocationTargetException ite) {
            throw new ConnectionException("Generated class not instantiated.", ite.getTargetException());
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConnectionException("Generated class not found during lookup.", (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new ConnectionException("Generated class not instantiable during lookup.", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new ConnectionException("Illegal access to generated class during lookup.", (Throwable)iae);
        }
    }

    public void close() {
        this.m_hostContext.getClientInvocationHandler().close();
    }
}

