/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.altrmi.client.ClientInvocationHandler;
import org.apache.altrmi.client.HostContext;
import org.apache.altrmi.client.impl.DynamicClassFactory;
import org.apache.altrmi.client.impl.DynamicStub;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.ListMethodsReply;
import org.apache.altrmi.common.ListMethodsRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;

public class DynamicInvoker {
    private DynamicClassFactory m_factory = new DynamicClassFactory(false);
    private HostContext m_hostContext;
    private ClientInvocationHandler m_clientInvocationHandler;
    private Map m_stubs = new HashMap();

    public DynamicInvoker(HostContext altrmiHostContext) throws Exception {
        this.m_hostContext = altrmiHostContext;
        this.m_factory.setHostContext(this.m_hostContext);
        this.m_clientInvocationHandler = this.m_hostContext.getClientInvocationHandler();
    }

    public void close() {
        this.m_factory.close();
    }

    public String[] list() {
        return this.m_factory.list();
    }

    public String[] listOfMethods(String publishedName) {
        Reply ar = this.m_clientInvocationHandler.handleInvocation((Request)new ListMethodsRequest(publishedName));
        return ((ListMethodsReply)ar).getListOfMethods();
    }

    public Object invoke(String publishedName, String methodName, Object[] args, Class[] argClasses) throws ConnectionException {
        DynamicStub stub = (DynamicStub)this.m_stubs.get(publishedName);
        if (stub == null) {
            stub = (DynamicStub)this.m_factory.lookup(publishedName);
            this.m_stubs.put(publishedName, stub);
        }
        if (args == null) {
            args = new Object[]{};
        }
        if (argClasses == null) {
            argClasses = new Class[]{};
        }
        methodName = methodName.trim();
        StringBuffer buf = new StringBuffer(methodName);
        int i = 0;
        while (i < buf.length()) {
            char c = buf.charAt(i);
            if (c == ' ') {
                buf.deleteCharAt(i);
                --i;
            }
            if (c == ',') {
                buf.insert(i + 1, ' ');
                ++i;
            }
            ++i;
        }
        methodName = buf.toString();
        Object ret = stub.invoke(methodName, args, argClasses);
        return ret;
    }
}

