/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.client.impl;

import java.util.Vector;
import org.apache.altrmi.client.InterfaceLookup;
import org.apache.altrmi.client.InterfaceLookupFactory;
import org.apache.altrmi.common.ConnectionException;

public class AbstractInterfaceLookupFactory
implements InterfaceLookupFactory {
    private Vector m_factories = new Vector();

    protected void addFactory(String factoryStringPrefix, InterfaceLookupFactory factory) {
        this.m_factories.add(new Factory(factoryStringPrefix, factory));
    }

    public final InterfaceLookup getInterfaceLookup(String factoryString, boolean optimize) throws ConnectionException {
        return this.getInterfaceLookup(factoryString, this.getClass().getClassLoader(), optimize);
    }

    public InterfaceLookup getInterfaceLookup(String factoryString, ClassLoader interfacesClassLoader, boolean optimize) throws ConnectionException {
        int i = 0;
        while (i < this.m_factories.size()) {
            Factory factory = (Factory)this.m_factories.elementAt(i);
            if (factoryString.startsWith(factory.factoryStringPrefix)) {
                return factory.altrmiInterfaceLookupFactory.getInterfaceLookup(factoryString, interfacesClassLoader, optimize);
            }
            ++i;
        }
        return null;
    }

    private class Factory {
        private String factoryStringPrefix;
        private InterfaceLookupFactory altrmiInterfaceLookupFactory;

        public Factory(String factoryStringPrefix, InterfaceLookupFactory altrmiInterfaceLookupFactory) {
            this.factoryStringPrefix = factoryStringPrefix;
            this.altrmiInterfaceLookupFactory = altrmiInterfaceLookupFactory;
        }
    }
}

