/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.expression;

import java.util.ArrayList;
import org.outerj.expression.Expression;
import org.outerj.expression.ExpressionException;

public abstract class AbstractExpression
implements Expression {
    protected ArrayList arguments = new ArrayList(3);
    protected int line;
    protected int column;

    public void addArgument(Expression expression) {
        this.arguments.add(expression);
    }

    public void addArgument(int index, Expression expression) {
        this.arguments.add(index, expression);
    }

    public void setPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void check() throws ExpressionException {
    }

    protected void checkArguments(Class[] types) throws ExpressionException {
        if (this.arguments.size() != types.length) {
            throw new ExpressionException(this.getDescription() + " requires " + types.length + " argument(s)", this.getLine(), this.getColumn());
        }
        for (int i = 0; i < types.length; ++i) {
            this.checkArgument(i, types[i]);
        }
    }

    protected void checkArgument(int position, Class clazz) throws ExpressionException {
        Class resultClass = ((Expression)this.arguments.get(position)).getResultType();
        if (resultClass != null && !clazz.isAssignableFrom(resultClass)) {
            throw new ExpressionException("Argument " + position + " of " + this.getDescription() + " is of an incorrect type", this.getLine(), this.getColumn());
        }
    }

    protected void checkNoArguments() throws ExpressionException {
        if (this.arguments.size() > 0) {
            throw new ExpressionException(this.getDescription() + " takes no parameters", this.getLine(), this.getColumn());
        }
    }

    protected void checkArgumentsOfSameType(Class clazz) throws ExpressionException {
        for (int i = 0; i < this.arguments.size(); ++i) {
            Expression expression = (Expression)this.arguments.get(i);
            if (expression.getResultType() == null || clazz.isAssignableFrom(expression.getResultType())) continue;
            throw new ExpressionException("Argument " + i + " of " + this.getDescription() + " is of an incorrect type", this.getLine(), this.getColumn());
        }
    }
}

