/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.publisher;

import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFTagHeader;
import java.io.IOException;

public abstract class SWFTagWriter {
    protected final SWFTagHeader HEADER = new SWFTagHeader();
    private boolean dataInitialized = false;
    private boolean lengthInitialized = false;

    protected SWFTagWriter() {
    }

    protected SWFTagWriter(int typeID) {
        this.HEADER.setID(typeID);
    }

    public long getTotalLength() throws IOException {
        this.doInitDataLength();
        long dataLength = this.getDataLength();
        this.HEADER.setRecordLength(dataLength);
        return dataLength + this.HEADER.length() / 8L;
    }

    public void write(BitOutputStream out) throws IOException {
        this.doInitWriteData();
        this.HEADER.setRecordLength(this.getDataLength());
        this.HEADER.write(out);
        this.writeData(out);
    }

    protected void doInitWriteData() throws IOException {
        if (!this.dataInitialized) {
            this.dataInitialized = true;
            this.initWriteData();
        }
    }

    protected void initWriteData() throws IOException {
    }

    protected void doInitDataLength() throws IOException {
        if (!this.lengthInitialized) {
            this.lengthInitialized = true;
            this.initDataLength();
        }
    }

    protected void initDataLength() throws IOException {
        this.doInitWriteData();
    }

    public int getTypeID() {
        return this.HEADER.getID();
    }

    protected abstract long getDataLength();

    public abstract void writeData(BitOutputStream var1) throws IOException;
}

