/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.parser;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.SWFCurvedEdge;
import de.tivano.flash.swf.common.SWFMoveTo;
import de.tivano.flash.swf.common.SWFShape;
import de.tivano.flash.swf.common.SWFStateChange;
import de.tivano.flash.swf.common.SWFStraightEdge;
import de.tivano.flash.swf.common.SWFTagHeader;
import de.tivano.flash.swf.parser.SWFAttributes;
import de.tivano.flash.swf.parser.SWFTagReaderBase;
import java.io.IOException;
import java.util.Iterator;
import org.xml.sax.SAXException;

public class SWFShapeReader
extends SWFTagReaderBase {
    private final boolean USE_RGBA;

    public SWFShapeReader(boolean useRGBA) {
        this.USE_RGBA = useRGBA;
    }

    public void parse(BitInputStream input, SWFTagHeader header) throws SAXException, IOException {
        this.parse(input);
    }

    public void parse(BitInputStream input) throws SAXException, IOException {
        this.toXML(new SWFShape(input, this.USE_RGBA));
    }

    public void toXML(SWFShape shape) throws IOException, SAXException {
        SWFAttributes attrib = this.createAttributes();
        this.startElement("Shape", null);
        Iterator records = shape.getShapeRecords();
        boolean insidePath = false;
        while (records.hasNext()) {
            SWFStateChange state;
            attrib.clear();
            Object entry = records.next();
            if (entry instanceof SWFCurvedEdge) {
                if (!insidePath) {
                    this.fatalError("SWF edge record found without preceding MoveTo");
                    return;
                }
                SWFCurvedEdge c = (SWFCurvedEdge)entry;
                attrib.addAttribute("x", c.getAnchorX());
                attrib.addAttribute("y", c.getAnchorY());
                attrib.addAttribute("cx", c.getControlX());
                attrib.addAttribute("cy", c.getControlY());
                this.emptyElement("Bezier", attrib);
                continue;
            }
            if (entry instanceof SWFStraightEdge) {
                if (!insidePath) {
                    this.fatalError("SWF edge record found without preceding MoveTo");
                    return;
                }
                SWFStraightEdge s = (SWFStraightEdge)entry;
                attrib.addAttribute("x", s.getX());
                attrib.addAttribute("y", s.getY());
                this.emptyElement("Line", attrib);
                continue;
            }
            if (!(entry instanceof SWFStateChange)) continue;
            if (insidePath) {
                this.endElement("Path");
                insidePath = false;
            }
            if ((state = (SWFStateChange)entry).isEndOfShape()) continue;
            if (state.hasFillStyle0()) {
                attrib.clear();
                attrib.addAttribute("slot", 0L);
                attrib.addAttribute("style", state.getFillStyle0());
                this.emptyElement("FillStyle", attrib);
            }
            if (state.hasFillStyle1()) {
                attrib.clear();
                attrib.addAttribute("slot", 1L);
                attrib.addAttribute("style", state.getFillStyle1());
                this.emptyElement("FillStyle", attrib);
            }
            if (state.hasLineStyle()) {
                attrib.clear();
                attrib.addAttribute("style", state.getLineStyle());
                this.emptyElement("LineStyle", attrib);
            }
            this.startElement("Path", null);
            insidePath = true;
            attrib.clear();
            if (state.hasMoveTo()) {
                SWFMoveTo m = state.getMoveTo();
                attrib.addAttribute("x", m.getX());
                attrib.addAttribute("y", m.getY());
            } else {
                attrib.addAttribute("x", 0L);
                attrib.addAttribute("y", 0L);
            }
            this.emptyElement("Start", attrib);
        }
        this.endElement("Shape");
    }
}

