/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.parser;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.SWFDefineFont2;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFRectangle;
import de.tivano.flash.swf.common.SWFTagHeader;
import de.tivano.flash.swf.parser.SWFAttributes;
import de.tivano.flash.swf.parser.SWFRawShapeReader;
import de.tivano.flash.swf.parser.SWFReader;
import de.tivano.flash.swf.parser.SWFShapeReader;
import de.tivano.flash.swf.parser.SWFTagReaderBase;
import java.io.IOException;
import org.xml.sax.SAXException;

public class SWFDefineFont2Reader
extends SWFTagReaderBase {
    protected SWFShapeReader shapeReader = new SWFRawShapeReader(false);

    public void setSAXDriver(SWFReader driver) {
        super.setSAXDriver(driver);
        this.shapeReader.setSAXDriver(driver);
    }

    public void parse(BitInputStream input, SWFTagHeader header) throws SAXException, IOException {
        SWFDefineFont2 fontTag = new SWFDefineFont2(input);
        SWFFont font = new SWFFont();
        font.setFontID(fontTag.getID());
        font.setFontName(fontTag.getName());
        this.getContextMap().put(new Integer(fontTag.getID()), font);
        boolean hasGlyphLayout = fontTag.hasGlyphLayout();
        String style = null;
        switch (fontTag.getLayout()) {
            case 1: {
                style = "bold";
                break;
            }
            case 2: {
                style = "italic";
                break;
            }
            case 3: {
                style = "bold-italic";
            }
        }
        String encoding = null;
        switch (fontTag.getEncoding()) {
            case 3: {
                encoding = "unicode";
                break;
            }
            case 2: {
                encoding = "shift-jis";
            }
        }
        font.setEncoding(fontTag.getEncoding());
        SWFAttributes attrib = this.createAttributes();
        attrib.addAttribute("id", fontTag.getID(), "ID");
        attrib.addAttribute("name", fontTag.getName());
        if (style != null) {
            attrib.addAttribute("style", style);
        }
        if (encoding != null) {
            attrib.addAttribute("encoding", encoding);
        }
        if (hasGlyphLayout) {
            attrib.addAttribute("ascent", fontTag.getAscent());
            attrib.addAttribute("descent", fontTag.getDescent());
            attrib.addAttribute("leading", fontTag.getLeadingHeight());
        }
        this.startElement("Font", attrib);
        int i = 0;
        while (i < fontTag.getGlyphCount()) {
            String charcode = font.decode(fontTag.getCode(i));
            int advance = fontTag.getAdvance(i);
            font.addGlyph(charcode, fontTag.getAdvance(i), true);
            attrib.clear();
            attrib.addAttribute("char", charcode);
            if (hasGlyphLayout) {
                attrib.addAttribute("advance", advance);
            }
            if (hasGlyphLayout) {
                SWFRectangle bounds = fontTag.getBounds(i);
                attrib.addAttribute("xmin", bounds.getXMin());
                attrib.addAttribute("ymin", bounds.getYMin());
                attrib.addAttribute("xmax", bounds.getXMax());
                attrib.addAttribute("ymax", bounds.getYMax());
            }
            this.startElement("Glyph", attrib);
            this.shapeReader.toXML(fontTag.getShape(i));
            this.endElement("Glyph");
            ++i;
        }
        int i2 = 0;
        while (i2 < fontTag.getKerningCount()) {
            SWFDefineFont2.KerningRecord entry = fontTag.getKerningRecord(i2);
            attrib.clear();
            attrib.addAttribute("chars", font.decode(entry.CHAR_1) + font.decode(entry.CHAR_2));
            attrib.addAttribute("advance", entry.KERNING);
            this.emptyElement("Kerning", attrib);
            ++i2;
        }
        this.endElement("Font");
    }
}

