/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFFormatException;
import java.io.EOFException;
import java.io.IOException;

public class SWFTagHeader {
    public static final int MAX_LENGTH = 6;
    private Integer id;
    private long length;
    private final int LONG_HEADER_FLAG = 63;
    private final int LENGTH_FIELD_MASK = 63;
    private final int ID_FIELD_MASK = 65472;

    public SWFTagHeader(BitInputStream input) throws IOException {
        if (!input.isAtByteBoundary()) {
            throw new SWFFormatException("Tag headers must be byte-aligned");
        }
        int tmp = input.readUW16LSB();
        this.id = new Integer(tmp >>> 6);
        long lengthTmp = tmp & 0x3F;
        if (lengthTmp == 63L) {
            try {
                lengthTmp = input.readUW32LSB();
            }
            catch (EOFException e) {
                throw new SWFFormatException("Could not read 32bit record length");
            }
        }
        this.length = lengthTmp;
    }

    public SWFTagHeader(int id, long length) {
        this(id);
        this.setRecordLength(length);
    }

    public SWFTagHeader(int id) {
        this.setID(id);
    }

    public SWFTagHeader() {
    }

    public int getID() {
        return this.id;
    }

    public Integer getIDAsInteger() {
        return this.id;
    }

    public long getRecordLength() {
        return this.length;
    }

    public void setID(int id) {
        if (id < 0 || id >= 1024) {
            throw new IllegalArgumentException("ID " + id + " is outside the allowed range of 0..1023");
        }
        this.id = new Integer(id);
    }

    public void setRecordLength(long length) {
        if (length < 0L || length >= 0x100000000L) {
            throw new IllegalArgumentException("length " + length + " is outside the allowed range of 0..2^32");
        }
        this.length = length;
    }

    private boolean isLongHeader() {
        switch (this.getID()) {
            default: 
        }
        return this.getRecordLength() >= 63L;
    }

    public long length() {
        if (this.isLongHeader()) {
            return 48L;
        }
        return 16L;
    }

    public void write(BitOutputStream out) throws IOException {
        int tmp = this.getID() << 6;
        if (this.isLongHeader()) {
            out.writeW16LSB(tmp |= 0x3F);
            out.writeW32LSB((int)this.getRecordLength());
        } else {
            tmp = (int)((long)tmp | this.getRecordLength());
            out.writeW16LSB(tmp);
        }
    }
}

