/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import java.io.EOFException;
import java.io.IOException;

public class SWFRectangle
extends SWFDataTypeBase {
    private final int X_MIN;
    private final int Y_MIN;
    private final int X_MAX;
    private final int Y_MAX;

    public SWFRectangle(BitInputStream input) throws IOException {
        try {
            int fieldLen = (int)input.readUBits(5);
            this.X_MIN = (int)input.readSBits(fieldLen);
            this.X_MAX = (int)input.readSBits(fieldLen);
            this.Y_MIN = (int)input.readSBits(fieldLen);
            this.Y_MAX = (int)input.readSBits(fieldLen);
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a rectangle");
        }
    }

    public SWFRectangle(int xmin, int xmax, int ymin, int ymax) {
        if (xmin > xmax) {
            throw new IllegalArgumentException("xmin > xmax");
        }
        if (ymin > ymax) {
            throw new IllegalArgumentException("ymin > ymax");
        }
        if (SWFDataTypeBase.minBitsS(xmin) > 31 || SWFDataTypeBase.minBitsS(xmax) > 31 || SWFDataTypeBase.minBitsS(ymin) > 31 || SWFDataTypeBase.minBitsS(ymax) > 31) {
            throw new IllegalArgumentException("Value(s) too big for a 31 bit field");
        }
        this.X_MIN = xmin;
        this.X_MAX = xmax;
        this.Y_MIN = ymin;
        this.Y_MAX = ymax;
    }

    public int getXMin() {
        return this.X_MIN;
    }

    public int getYMin() {
        return this.Y_MIN;
    }

    public int getXMax() {
        return this.X_MAX;
    }

    public int getYMax() {
        return this.Y_MAX;
    }

    public long length() {
        return 5 + 4 * this.getEntryLength();
    }

    private int getEntryLength() {
        return Math.max(Math.max(SWFDataTypeBase.minBitsS(this.Y_MIN), SWFDataTypeBase.minBitsS(this.Y_MAX)), Math.max(SWFDataTypeBase.minBitsS(this.X_MIN), SWFDataTypeBase.minBitsS(this.X_MAX)));
    }

    public void write(BitOutputStream out) throws IOException {
        int entryLength = this.getEntryLength();
        out.writeBits(entryLength, 5);
        out.writeBits(this.X_MIN, entryLength);
        out.writeBits(this.X_MAX, entryLength);
        out.writeBits(this.Y_MIN, entryLength);
        out.writeBits(this.Y_MAX, entryLength);
    }
}

