/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import java.io.EOFException;
import java.io.IOException;

public class SWFMatrix
extends SWFDataTypeBase {
    private boolean hasScale;
    private double scaleX;
    private double scaleY;
    private boolean hasRotate;
    private double rotate1;
    private double rotate2;
    private double translateX;
    private double translateY;

    public SWFMatrix(BitInputStream input) throws IOException {
        try {
            int nBits;
            this.hasScale = input.readBit();
            if (this.hasScale) {
                nBits = (int)input.readUBits(5);
                this.scaleX = SWFDataTypeBase.fromFixed(input.readSBits(nBits));
                this.scaleY = SWFDataTypeBase.fromFixed(input.readSBits(nBits));
            }
            this.hasRotate = input.readBit();
            if (this.hasRotate) {
                nBits = (int)input.readUBits(5);
                this.rotate1 = SWFDataTypeBase.fromFixed(input.readSBits(nBits));
                this.rotate2 = SWFDataTypeBase.fromFixed(input.readSBits(nBits));
            }
            nBits = (int)input.readUBits(5);
            this.translateX = SWFDataTypeBase.fromFixed(input.readSBits(nBits));
            this.translateY = SWFDataTypeBase.fromFixed(input.readSBits(nBits));
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a matrix structure");
        }
    }

    public boolean hasScale() {
        return this.hasScale;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public boolean hasRotate() {
        return this.hasRotate;
    }

    public double getRotate1() {
        return this.rotate1;
    }

    public double getRotate2() {
        return this.rotate2;
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public long length() {
        long length = 7 + Math.max(SWFDataTypeBase.minBitsS(SWFDataTypeBase.toFixed(this.getTranslateX())), SWFDataTypeBase.minBitsS(SWFDataTypeBase.toFixed(this.getTranslateY())));
        if (this.hasScale()) {
            length += (long)(5 + Math.max(SWFDataTypeBase.minBitsS(SWFDataTypeBase.toFixed(this.getScaleX())), SWFDataTypeBase.minBitsS(SWFDataTypeBase.toFixed(this.getScaleY()))));
        }
        if (this.hasRotate()) {
            length += (long)(5 + Math.max(SWFDataTypeBase.minBitsS(SWFDataTypeBase.toFixed(this.getRotate1())), SWFDataTypeBase.minBitsS(SWFDataTypeBase.toFixed(this.getRotate2()))));
        }
        return length;
    }

    public void write(BitOutputStream out) throws IOException {
        int nBits;
        long y;
        long x;
        out.writeBit(this.hasScale());
        if (this.hasScale()) {
            x = SWFDataTypeBase.toFixed(this.getScaleX());
            y = SWFDataTypeBase.toFixed(this.getScaleY());
            nBits = Math.max(SWFDataTypeBase.minBitsS(x), SWFDataTypeBase.minBitsS(y));
            out.writeBits(x, nBits);
            out.writeBits(y, nBits);
        }
        out.writeBit(this.hasRotate());
        if (this.hasRotate()) {
            x = SWFDataTypeBase.toFixed(this.getRotate1());
            y = SWFDataTypeBase.toFixed(this.getRotate2());
            nBits = Math.max(SWFDataTypeBase.minBitsS(x), SWFDataTypeBase.minBitsS(y));
            out.writeBits(x, nBits);
            out.writeBits(y, nBits);
        }
        x = SWFDataTypeBase.toFixed(this.getTranslateX());
        y = SWFDataTypeBase.toFixed(this.getTranslateY());
        nBits = Math.max(SWFDataTypeBase.minBitsS(x), SWFDataTypeBase.minBitsS(y));
        out.writeBits(x, nBits);
        out.writeBits(y, nBits);
    }
}

