/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFColorRGBA;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFSolidLineStyle;
import de.tivano.flash.swf.common.SWFTransparentLineStyle;
import java.io.EOFException;
import java.io.IOException;

public abstract class SWFLineStyle
extends SWFDataTypeBase {
    private final int WIDTH;

    SWFLineStyle(BitInputStream input) throws IOException {
        this.WIDTH = input.readUW16LSB();
    }

    public static SWFLineStyle parse(BitInputStream input, boolean useRGBA) throws IOException {
        try {
            if (useRGBA) {
                return new SWFSolidLineStyle(input);
            }
            return new SWFTransparentLineStyle(input);
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a line style structure");
        }
    }

    public int getWidth() {
        return this.WIDTH;
    }

    public abstract SWFColorRGBA getColor();

    public abstract boolean getAlpha();

    public void write(BitOutputStream out) throws IOException {
        out.writeW16LSB(this.WIDTH);
    }
}

