/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFillStyleBitmap;
import de.tivano.flash.swf.common.SWFFillStyleGradient;
import de.tivano.flash.swf.common.SWFFillStyleSolid;
import de.tivano.flash.swf.common.SWFFormatException;
import java.io.EOFException;
import java.io.IOException;

public abstract class SWFFillStyle
extends SWFDataTypeBase {
    public static final int TYPE_SOLID_FILL = 0;
    public static final int TYPE_LINEAR_GRADIENT_FILL = 16;
    public static final int TYPE_RADIAL_GRADIENT_FILL = 18;
    public static final int TYPE_TILED_BITMAP_FILL = 64;
    public static final int TYPE_CLIPPED_BITMAP_FILL = 65;
    private int type;
    private boolean useRGBA;

    public static SWFFillStyle parse(BitInputStream input, boolean useRGBA) throws IOException {
        try {
            int type = input.readUByte();
            switch (type) {
                case 0: {
                    return new SWFFillStyleSolid(input, useRGBA);
                }
                case 16: 
                case 18: {
                    return new SWFFillStyleGradient(input, useRGBA, type);
                }
                case 64: 
                case 65: {
                    return new SWFFillStyleBitmap(input, type);
                }
            }
            throw new SWFFormatException("Unknown fill style type: " + type);
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a fill style structure");
        }
    }

    public boolean hasRGBAColors() {
        return this.useRGBA;
    }

    protected void setHasRGBAColors(boolean value) {
        this.useRGBA = value;
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int value) {
        this.type = value;
    }

    public void write(BitOutputStream out) throws IOException {
        out.writeBits(this.getType(), 8);
    }
}

