/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import de.tivano.flash.swf.common.BitInputStream;
import de.tivano.flash.swf.common.BitOutputStream;
import de.tivano.flash.swf.common.SWFColorRGBA;
import de.tivano.flash.swf.common.SWFDataTypeBase;
import de.tivano.flash.swf.common.SWFFont;
import de.tivano.flash.swf.common.SWFFormatException;
import de.tivano.flash.swf.common.SWFRectangle;
import de.tivano.flash.swf.common.SWFTopLevelDataType;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class SWFDefineTextField
extends SWFDataTypeBase
implements SWFTopLevelDataType {
    public static final int TAG_TYPE = 37;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_JUSTIFY = 3;
    private int textID;
    private SWFRectangle bounds;
    private boolean hasLayout;
    private boolean hasFont;
    private boolean isSelectable;
    private boolean isHTML;
    private boolean hasBorder;
    private boolean useWordWrap;
    private boolean isMultiline;
    private boolean isPassword;
    private boolean isReadonly;
    private boolean useOutlines;
    private int maxLength = -1;
    private byte[] text = null;
    private String varName = null;
    private int fontID = 0;
    private int fontHeight = 0;
    private SWFColorRGBA textColor = null;
    private int textAlign;
    private int leftMargin;
    private int rightMargin;
    private int textIndent;
    private int lineSpacing;

    /*
     * WARNING - void declaration
     */
    public SWFDefineTextField(BitInputStream input) throws IOException {
        try {
            int tmp;
            this.textID = input.readUW16LSB();
            this.bounds = new SWFRectangle(input);
            input.skipToByteBoundary();
            boolean hasText = input.readBit();
            this.useWordWrap = input.readBit();
            this.isMultiline = input.readBit();
            this.isPassword = input.readBit();
            this.isReadonly = input.readBit();
            boolean hasColor = input.readBit();
            boolean hasMaxLen = input.readBit();
            this.hasFont = input.readBit();
            input.skipBits(2L);
            this.hasLayout = input.readBit();
            this.isSelectable = !input.readBit();
            this.hasBorder = input.readBit();
            input.skipBits(1L);
            this.isHTML = input.readBit();
            this.useOutlines = input.readBit();
            if (this.hasFont) {
                this.fontID = input.readUW16LSB();
                this.fontHeight = input.readUW16LSB();
            }
            if (hasColor) {
                this.textColor = new SWFColorRGBA(input);
            }
            if (hasMaxLen) {
                this.maxLength = input.readUW16LSB();
            }
            if (this.hasLayout) {
                this.textAlign = input.readUByte();
                this.leftMargin = input.readUW16LSB();
                this.rightMargin = input.readUW16LSB();
                this.textIndent = input.readUW16LSB();
                this.lineSpacing = input.readUW16LSB();
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            while ((tmp = input.read()) != 0) {
                void var6_7;
                buf.write((int)var6_7);
            }
            this.varName = buf.toString(SWFFont.getCanonicalEncodingName(1));
            if (this.varName.length() == 0) {
                this.varName = null;
            }
            if (hasText) {
                buf.reset();
                while ((tmp = input.read()) != 0) {
                    buf.write(tmp);
                }
                this.text = buf.toByteArray();
            }
        }
        catch (EOFException e) {
            throw new SWFFormatException("Premature end of file encoutered while reading a DefineTextField tag");
        }
    }

    public SWFDefineTextField() {
        this.textID = 0;
        this.varName = null;
        this.bounds = null;
        this.hasFont = false;
        this.hasLayout = false;
        this.isSelectable = false;
        this.isReadonly = true;
        this.isPassword = false;
        this.isMultiline = false;
        this.useWordWrap = false;
        this.isHTML = false;
        this.hasBorder = false;
        this.text = null;
        this.maxLength = -1;
        this.textColor = null;
    }

    public int getID() {
        return this.textID;
    }

    public SWFRectangle getBounds() {
        return this.bounds;
    }

    public boolean hasLayout() {
        return this.hasLayout;
    }

    public boolean hasFont() {
        return this.hasFont;
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public boolean isHTML() {
        return this.isHTML;
    }

    public boolean useOutlines() {
        return this.useOutlines;
    }

    public boolean hasBorder() {
        return this.hasBorder;
    }

    public boolean useWordWrap() {
        return this.useWordWrap;
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public boolean isReadonly() {
        return this.isReadonly;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public byte[] getText() {
        return this.text;
    }

    public String getVarName() {
        return this.varName;
    }

    public int getFontID() {
        return this.fontID;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public SWFColorRGBA getTextColor() {
        return this.textColor;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getTextIndent() {
        return this.textIndent;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setID(int value) {
        this.textID = value;
    }

    public void setBounds(SWFRectangle value) {
        this.bounds = value;
    }

    public void setSelectable(boolean value) {
        this.isSelectable = value;
    }

    public void setHTML(boolean value) {
        this.isHTML = value;
    }

    public void setUseOutlines(boolean value) {
        this.useOutlines = value;
    }

    public void setHasBorder(boolean value) {
        this.hasBorder = value;
    }

    public void setUseWordWrap(boolean value) {
        this.useWordWrap = value;
    }

    public void setMultiline(boolean value) {
        this.isMultiline = value;
    }

    public void setPassword(boolean value) {
        this.isPassword = value;
    }

    public void setReadonly(boolean value) {
        this.isReadonly = value;
    }

    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    public void setText(byte[] value) {
        this.text = value;
    }

    public void setVarName(String value) {
        this.varName = value;
    }

    public void setFontID(int value) {
        this.fontID = value;
        this.hasFont = true;
    }

    public void setFontHeight(int value) {
        this.fontHeight = value;
        this.hasFont = true;
    }

    public void setTextColor(SWFColorRGBA value) {
        this.textColor = value;
    }

    public void setTextAlign(int value) {
        this.textAlign = value;
    }

    public void setLeftMargin(int value) {
        this.leftMargin = value;
        this.hasLayout = true;
    }

    public void setRightMargin(int value) {
        this.rightMargin = value;
        this.hasLayout = true;
    }

    public void setTextIndent(int value) {
        this.textIndent = value;
        this.hasLayout = true;
    }

    public void setLineSpacing(int value) {
        this.lineSpacing = value;
        this.hasLayout = true;
    }

    public long length() {
        long length = 32L + SWFDataTypeBase.paddedLength(this.bounds.length());
        if (this.hasFont) {
            length += 32L;
        }
        if (this.textColor != null) {
            length += this.textColor.length();
        }
        if (this.maxLength >= 0) {
            length += 16L;
        }
        if (this.hasLayout) {
            length += 72L;
        }
        length = this.varName != null ? (length += (long)((this.varName.length() + 1) * 8)) : (length += 8L);
        if (this.text != null) {
            length += (long)((this.text.length + 1) * 8);
        }
        return length;
    }

    public void write(BitOutputStream out) throws IOException {
        out.writeW16LSB(this.textID);
        this.bounds.write(out);
        out.padToByteBoundary();
        out.writeBit(this.text != null);
        out.writeBit(this.useWordWrap);
        out.writeBit(this.isMultiline);
        out.writeBit(this.isPassword);
        out.writeBit(this.isReadonly);
        out.writeBit(this.textColor != null);
        out.writeBit(this.maxLength >= 0);
        out.writeBit(this.hasFont);
        out.writeBits(0L, 2);
        out.writeBit(this.hasLayout);
        out.writeBit(!this.isSelectable);
        out.writeBit(this.hasBorder);
        out.writeBit(false);
        out.writeBit(this.isHTML);
        out.writeBit(this.useOutlines);
        if (this.hasFont) {
            out.writeW16LSB(this.fontID);
            out.writeW16LSB(this.fontHeight);
        }
        if (this.textColor != null) {
            this.textColor.write(out);
        }
        if (this.maxLength >= 0) {
            out.writeW16LSB(this.maxLength);
        }
        if (this.hasLayout) {
            out.writeByte((byte)this.textAlign);
            out.writeW16LSB(this.leftMargin);
            out.writeW16LSB(this.rightMargin);
            out.writeW16LSB(this.textIndent);
            out.writeW16LSB(this.lineSpacing);
        }
        if (this.varName != null) {
            out.write(this.varName.getBytes(SWFFont.getCanonicalEncodingName(1)));
        }
        out.write(0);
        if (this.text != null) {
            out.write(this.text);
            out.write(0);
        }
    }

    public int getTagType() {
        return 37;
    }
}

