/*
 * Decompiled with CFR 0.152.
 */
package de.tivano.flash.swf.common;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends FilterOutputStream {
    private int bitsLeft = 0;
    private byte buffer = 0;
    private byte[] bufferTmp = new byte[8];

    public BitOutputStream(OutputStream out) {
        super(out);
    }

    public void writeBits(long value, int n) throws IOException {
        value = value & -1L >>> 64 - n | (long)this.buffer << n;
        int remaining = (n += this.bitsLeft) % 8;
        int bytes = n / 8;
        switch (bytes) {
            case 8: {
                this.bufferTmp[0] = (byte)(value >> 56 + remaining);
            }
            case 7: {
                this.bufferTmp[1] = (byte)(value >> 48 + remaining);
            }
            case 6: {
                this.bufferTmp[2] = (byte)(value >> 40 + remaining);
            }
            case 5: {
                this.bufferTmp[3] = (byte)(value >> 32 + remaining);
            }
            case 4: {
                this.bufferTmp[4] = (byte)(value >> 24 + remaining);
            }
            case 3: {
                this.bufferTmp[5] = (byte)(value >> 16 + remaining);
            }
            case 2: {
                this.bufferTmp[6] = (byte)(value >> 8 + remaining);
            }
            case 1: {
                this.bufferTmp[7] = (byte)(value >> remaining);
                this.out.write(this.bufferTmp, 8 - bytes, bytes);
            }
            case 0: {
                this.bitsLeft = remaining;
                this.buffer = (byte)value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n));
            }
        }
    }

    public void padToByteBoundary() throws IOException {
        this.writeBits(0L, this.countRemainingBits());
    }

    public int countRemainingBits() {
        return (8 - this.bitsLeft) % 8;
    }

    public void discardRemainingBits() {
        this.bitsLeft = 0;
        this.buffer = 0;
    }

    public boolean isAtByteBoundary() {
        return this.bitsLeft == 0;
    }

    public void writeBit(boolean value) throws IOException {
        this.writeBits(value ? 1L : 0L, 1);
    }

    public void writeByte(byte value) throws IOException {
        this.write(value);
    }

    public void writeW16MSB(int value) throws IOException {
        this.writeBits(value, 16);
    }

    public void writeW16LSB(int value) throws IOException {
        this.write(value);
        this.write(value >>> 8);
    }

    public void writeW32MSB(int value) throws IOException {
        this.writeBits(value, 32);
    }

    public void writeW32LSB(int value) throws IOException {
        this.write(value);
        this.write(value >>> 8);
        this.write(value >>> 16);
        this.write(value >>> 24);
    }

    public void write(int b) throws IOException {
        if (this.bitsLeft == 0) {
            this.out.write(b);
        } else {
            this.writeBits(b, 8);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.bitsLeft == 0) {
            this.out.write(b, off, len);
        } else {
            int i = off;
            while (i < off + len) {
                this.writeBits(b[i], 8);
                ++i;
            }
        }
    }

    public void flush() throws IOException {
        if (this.bitsLeft != 0) {
            throw new IllegalStateException("Not at a byte boundary - cannot flush.");
        }
        super.flush();
    }

    public void padAndFlush() throws IOException {
        this.padToByteBoundary();
        this.flush();
    }

    public void close() throws IOException {
        this.padToByteBoundary();
        this.flush();
    }
}

