/*
 * Decompiled with CFR 0.152.
 */
package slidestore.file;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.AbstractService;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceDisconnectionFailedException;
import org.apache.slide.common.ServiceInitializationFailedException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.ServiceResetFailedException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import slidestore.file.UriProperties;

public class XMLFileDescriptorsStore
extends AbstractService
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore {
    protected Hashtable definitions;
    protected String rootpath;

    public void commit() throws ServiceAccessException {
    }

    public synchronized void connect() throws ServiceConnectionFailedException {
        if (this.definitions == null) {
            this.definitions = new Hashtable();
        }
    }

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        try {
            UriProperties aProps = this.getUriProperties(uri);
            if (aProps == null) {
                this.storeObject(uri, object);
            } else {
                aProps.createObject(uri, object);
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            aProps = new UriProperties(this.rootpath, uri);
            this.definitions.put(uri.toString(), aProps);
        }
        aProps.createRevisionDescriptor(uri, revisionDescriptor);
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            aProps = new UriProperties(this.rootpath, uri);
            this.definitions.put(uri.toString(), aProps);
        }
        aProps.createRevisionDescriptors(uri, revisionDescriptors);
    }

    public void disconnect() throws ServiceDisconnectionFailedException {
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            return new Vector().elements();
        }
        return aProps.enumerateLocks();
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            return new Vector().elements();
        }
        return aProps.enumeratePermissions();
    }

    protected UriProperties getUriProperties(Uri uri) {
        return (UriProperties)this.definitions.get(uri.toString());
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            aProps = new UriProperties(this.rootpath, uri);
            this.definitions.put(uri.toString(), aProps);
        }
        aProps.grantPermission(uri, permission);
    }

    public synchronized void initialize(NamespaceAccessToken token) throws ServiceInitializationFailedException {
        super.initialize(token);
        this.definitions = new Hashtable();
    }

    public boolean isConnected() throws ServiceAccessException {
        return true;
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.removeLock(uri, lock);
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            aProps = new UriProperties(this.rootpath, uri);
            this.definitions.put(uri.toString(), aProps);
        }
        aProps.putLock(uri, lock);
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            throw new LockTokenNotFoundException(lock);
        }
        aProps.removeLock(uri, lock);
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            throw new ObjectNotFoundException(uri);
        }
        File file = aProps.getFile(uri);
        if (file.exists()) {
            file.delete();
        }
        aProps.removeObject(uri, object);
        this.definitions.remove(uri.toString());
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps != null) {
            aProps.removeRevisionDescriptor(uri, number);
        }
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps != null) {
            aProps.removeRevisionDescriptors(uri);
        }
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            aProps = new UriProperties(this.rootpath, uri);
            this.definitions.put(uri.toString(), aProps);
        }
        aProps.renewLock(uri, lock);
    }

    public synchronized void reset() throws ServiceResetFailedException {
        this.definitions = new Hashtable();
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            File aFile = UriProperties.getFile(this.rootpath, uri);
            if (aFile.exists()) {
                try {
                    aProps = new UriProperties(this.rootpath, uri);
                }
                catch (ServiceAccessException serviceAccessException) {
                    throw new ObjectNotFoundException(uri);
                }
                this.definitions.put(uri.toString(), aProps);
            } else {
                throw new ObjectNotFoundException(uri);
            }
        }
        return aProps.retrieveObject(uri);
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            aProps = new UriProperties(this.rootpath, uri);
            this.definitions.put(uri.toString(), aProps);
        }
        return aProps.retrieveRevisionDescriptor(uri, revisionNumber);
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        return aProps.retrieveRevisionDescriptors(uri);
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps != null) {
            aProps.revokePermission(uri, permission);
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps != null) {
            aProps.revokePermissions(uri);
        }
    }

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        this.rootpath = (String)parameters.get("rootpath");
        if (this.rootpath == null) {
            this.rootpath = "";
        }
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        UriProperties aProps = this.getUriProperties(uri);
        try {
            if (aProps == null) {
                aProps = new UriProperties(this.rootpath, uri);
                this.definitions.put(uri.toString(), aProps);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        aProps.storeObject(uri, object);
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        aProps.storeRevisionDescriptor(uri, revisionDescriptor);
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        UriProperties aProps = this.getUriProperties(uri);
        if (aProps == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        aProps.storeRevisionDescriptors(uri, revisionDescriptors);
    }
}

